/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Log;
import com.aerospike.client.Value;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.EventLoops;
import com.aerospike.client.async.EventState;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.NodeValidator;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.cluster.Peers;
import com.aerospike.client.cluster.ThreadDaemonFactory;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.Replica;
import com.aerospike.client.policy.TlsPolicy;
import com.aerospike.client.util.Environment;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class Cluster
implements Runnable,
Closeable {
    private static final int MaxSocketIdleSecondLimit = 86400;
    protected final String clusterName;
    private volatile Host[] seeds;
    protected final HashMap<Host, Node> aliases;
    protected final HashMap<String, Node> nodesMap;
    private volatile Node[] nodes;
    public volatile HashMap<String, AtomicReferenceArray<Node>[]> partitionMap;
    protected final Map<String, String> ipMap;
    protected final TlsPolicy tlsPolicy;
    protected final byte[] user;
    protected byte[] password;
    private final AtomicInteger nodeIndex;
    private final AtomicInteger replicaIndex;
    private final ExecutorService threadPool;
    public final EventLoops eventLoops;
    public final EventState[] eventState;
    public final long maxSocketIdleNanos;
    protected final int connectionQueueSize;
    protected final int connPoolsPerNode;
    private final int connectionTimeout;
    private final int tendInterval;
    private Thread tendThread;
    protected volatile boolean tendValid;
    private final boolean sharedThreadPool;
    protected boolean requestProleReplicas;
    protected final boolean useServicesAlternate;
    private boolean asyncComplete;

    public Cluster(ClientPolicy policy, Host[] hosts) throws AerospikeException {
        int i;
        this.clusterName = policy.clusterName;
        if (policy.tlsPolicy != null && !policy.tlsPolicy.encryptOnly) {
            boolean useClusterName = this.clusterName != null && this.clusterName.length() > 0;
            for (i = 0; i < hosts.length; ++i) {
                Host host = hosts[i];
                if (host.tlsName != null) continue;
                String tlsName = useClusterName ? this.clusterName : host.name;
                hosts[i] = new Host(host.name, tlsName, host.port);
            }
        }
        this.seeds = hosts;
        if (policy.user != null && policy.user.length() > 0) {
            this.user = Buffer.stringToUtf8(policy.user);
            String pass = policy.password;
            if (pass == null) {
                pass = "";
            }
            if (pass.length() != 60 || !pass.startsWith("$2a$")) {
                pass = AdminCommand.hashPassword(pass);
            }
            this.password = Buffer.stringToUtf8(pass);
        } else {
            this.user = null;
        }
        this.tlsPolicy = policy.tlsPolicy;
        this.connectionQueueSize = policy.maxConnsPerNode;
        this.connPoolsPerNode = policy.connPoolsPerNode;
        this.connectionTimeout = policy.timeout;
        this.maxSocketIdleNanos = TimeUnit.SECONDS.toNanos(policy.maxSocketIdle <= 86400 ? (long)policy.maxSocketIdle : 86400L);
        this.tendInterval = policy.tendInterval;
        this.ipMap = policy.ipMap;
        this.threadPool = policy.threadPool == null ? Executors.newCachedThreadPool(new ThreadDaemonFactory()) : policy.threadPool;
        this.sharedThreadPool = policy.sharedThreadPool;
        this.requestProleReplicas = policy.requestProleReplicas;
        this.useServicesAlternate = policy.useServicesAlternate;
        this.aliases = new HashMap();
        this.nodesMap = new HashMap();
        this.nodes = new Node[0];
        this.partitionMap = new HashMap();
        this.nodeIndex = new AtomicInteger();
        this.replicaIndex = new AtomicInteger();
        this.eventLoops = policy.eventLoops;
        if (this.eventLoops != null) {
            EventLoop[] loops = this.eventLoops.getArray();
            this.eventState = new EventState[loops.length];
            for (i = 0; i < loops.length; ++i) {
                this.eventState[i] = loops[i].createState();
            }
            if (policy.tlsPolicy != null) {
                this.eventLoops.initTlsContext(policy.tlsPolicy);
            }
        } else {
            this.eventState = null;
        }
    }

    public void initTendThread(boolean failIfNotConnected) throws AerospikeException {
        this.waitTillStabilized(failIfNotConnected);
        if (Log.debugEnabled()) {
            for (Host host : this.seeds) {
                Log.debug("Add seed " + host);
            }
        }
        ArrayList<Host> seedsToAdd = new ArrayList<Host>(this.nodes.length);
        for (Node node : this.nodes) {
            Host host = node.getHost();
            if (!this.findSeed(host)) {
                seedsToAdd.add(host);
            }
            if (Value.UseDoubleType && !node.hasDouble()) {
                if (Log.warnEnabled()) {
                    Log.warn("Some nodes don't support new double type.  Disabling.");
                }
                Value.UseDoubleType = false;
            }
            if (!this.requestProleReplicas || node.hasReplicasAll()) continue;
            if (Log.warnEnabled()) {
                Log.warn("Some nodes don't support 'replicas-all'.  Use 'replicas-master' for all nodes.");
            }
            this.requestProleReplicas = false;
        }
        if (seedsToAdd.size() > 0) {
            this.addSeeds(seedsToAdd.toArray(new Host[seedsToAdd.size()]));
        }
        this.tendValid = true;
        this.tendThread = new Thread(this);
        this.tendThread.setName("tend");
        this.tendThread.setDaemon(true);
        this.tendThread.start();
    }

    public final void addSeeds(Host[] hosts) {
        Host[] seedArray = new Host[this.seeds.length + hosts.length];
        int count = 0;
        for (Host seed : this.seeds) {
            seedArray[count++] = seed;
        }
        for (Host host : hosts) {
            if (Log.debugEnabled()) {
                Log.debug("Add seed " + host);
            }
            seedArray[count++] = host;
        }
        this.seeds = seedArray;
    }

    private final boolean findSeed(Host search) {
        for (Host seed : this.seeds) {
            if (!seed.equals(search)) continue;
            return true;
        }
        return false;
    }

    private final void waitTillStabilized(boolean failIfNotConnected) throws AerospikeException {
        long deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.connectionTimeout);
        int count = -1;
        do {
            this.tend(failIfNotConnected);
            if (count == this.nodes.length) {
                return;
            }
            Util.sleep(1L);
            count = this.nodes.length;
        } while (System.nanoTime() < deadline);
    }

    @Override
    public final void run() {
        while (this.tendValid) {
            block3: {
                try {
                    this.tend(false);
                }
                catch (Exception e) {
                    if (!Log.warnEnabled()) break block3;
                    Log.warn("Cluster tend failed: " + Util.getErrorMessage(e));
                }
            }
            Util.sleep(this.tendInterval);
        }
    }

    private final void tend(boolean failIfNotConnected) throws AerospikeException {
        ArrayList<Node> removeList;
        if (this.nodes.length == 0) {
            this.seedNodes(failIfNotConnected);
        }
        Peers peers = new Peers(this.nodes.length + 16, 16);
        for (Node node : this.nodes) {
            node.referenceCount = 0;
            node.partitionChanged = false;
            if (node.hasPeers()) continue;
            peers.usePeers = false;
        }
        for (Node node : this.nodes) {
            node.refresh(peers);
        }
        if (peers.genChanged) {
            peers.refreshCount = 0;
            for (Node node : this.nodes) {
                node.refreshPeers(peers);
            }
        }
        for (Node node : this.nodes) {
            if (!node.partitionChanged) continue;
            node.refreshPartitions(peers);
        }
        if ((peers.genChanged || !peers.usePeers) && (removeList = this.findNodesToRemove(peers.refreshCount)).size() > 0) {
            this.removeNodes(removeList);
        }
        if (peers.nodes.size() > 0) {
            this.addNodes(peers.nodes);
        }
    }

    private final boolean seedNodes(boolean failIfNotConnected) throws AerospikeException {
        Host[] seedArray = this.seeds;
        Exception[] exceptions = null;
        HashMap<String, Node> nodesToAdd = new HashMap<String, Node>(seedArray.length + 16);
        for (int i = 0; i < seedArray.length; ++i) {
            Host seed = seedArray[i];
            try {
                NodeValidator nv = new NodeValidator();
                nv.seedNodes(this, seed, nodesToAdd);
                continue;
            }
            catch (Exception e) {
                if (failIfNotConnected) {
                    if (exceptions == null) {
                        exceptions = new Exception[seedArray.length];
                    }
                    exceptions[i] = e;
                    continue;
                }
                if (!Log.warnEnabled()) continue;
                Log.warn("Seed " + seed + " failed: " + Util.getErrorMessage(e));
            }
        }
        if (nodesToAdd.size() > 0) {
            this.addNodes(nodesToAdd);
            return true;
        }
        if (failIfNotConnected) {
            StringBuilder sb = new StringBuilder(500);
            sb.append("Failed to connect to host(s): ");
            sb.append(Environment.Newline);
            for (int i = 0; i < seedArray.length; ++i) {
                sb.append(seedArray[i]);
                sb.append(' ');
                Exception ex = exceptions[i];
                if (ex == null) continue;
                sb.append(ex.getMessage());
                sb.append(Environment.Newline);
            }
            throw new AerospikeException.Connection(sb.toString());
        }
        return false;
    }

    protected Node createNode(NodeValidator nv) {
        return new Node(this, nv);
    }

    private final ArrayList<Node> findNodesToRemove(int refreshCount) {
        ArrayList<Node> removeList = new ArrayList<Node>();
        block4: for (Node node : this.nodes) {
            if (!node.isActive()) {
                removeList.add(node);
                continue;
            }
            switch (this.nodes.length) {
                case 1: {
                    if (node.failures < 5) continue block4;
                    removeList.add(node);
                    continue block4;
                }
                case 2: {
                    if (refreshCount != 1 || node.referenceCount != 0 || node.failures <= 0) continue block4;
                    removeList.add(node);
                    continue block4;
                }
                default: {
                    if (refreshCount < 1 || node.referenceCount != 0) continue block4;
                    if (node.failures == 0) {
                        if (this.findNodeInPartitionMap(node)) continue block4;
                        removeList.add(node);
                        continue block4;
                    }
                    removeList.add(node);
                }
            }
        }
        return removeList;
    }

    private final boolean findNodeInPartitionMap(Node filter) {
        for (AtomicReferenceArray<Node>[] replicasArray : this.partitionMap.values()) {
            for (AtomicReferenceArray<Node> nodeArray : replicasArray) {
                int max = nodeArray.length();
                for (int i = 0; i < max; ++i) {
                    Node node = nodeArray.get(i);
                    if (node != filter) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private final void addNodes(HashMap<String, Node> nodesToAdd) {
        Node[] nodeArray = new Node[this.nodes.length + nodesToAdd.size()];
        int count = 0;
        for (Node node : this.nodes) {
            nodeArray[count++] = node;
        }
        for (Node node : nodesToAdd.values()) {
            if (Log.infoEnabled()) {
                Log.info("Add node " + node);
            }
            nodeArray[count++] = node;
            this.nodesMap.put(node.getName(), node);
            for (Host alias : node.aliases) {
                this.aliases.put(alias, node);
            }
        }
        this.nodes = nodeArray;
    }

    private final void removeNodes(List<Node> nodesToRemove) {
        for (Node node : nodesToRemove) {
            this.nodesMap.remove(node.getName());
            for (Host alias : node.aliases) {
                this.aliases.remove(alias);
            }
            node.close();
        }
        this.removeNodesCopy(nodesToRemove);
    }

    private final void removeNodesCopy(List<Node> nodesToRemove) {
        Node[] nodeArray = new Node[this.nodes.length - nodesToRemove.size()];
        int count = 0;
        for (Node node : this.nodes) {
            if (Cluster.findNode(node, nodesToRemove)) {
                if (!Log.infoEnabled()) continue;
                Log.info("Remove node " + node);
                continue;
            }
            nodeArray[count++] = node;
        }
        if (count < nodeArray.length) {
            if (Log.warnEnabled()) {
                Log.warn("Node remove mismatch. Expected " + nodeArray.length + " Received " + count);
            }
            Node[] nodeArray2 = new Node[count];
            System.arraycopy(nodeArray, 0, nodeArray2, 0, count);
            nodeArray = nodeArray2;
        }
        this.nodes = nodeArray;
    }

    private static final boolean findNode(Node search, List<Node> nodeList) {
        for (Node node : nodeList) {
            if (!node.equals(search)) continue;
            return true;
        }
        return false;
    }

    public final boolean isConnected() {
        Node[] nodeArray = this.nodes;
        if (nodeArray.length > 0 && this.tendValid) {
            for (Node node : nodeArray) {
                if (!node.active || node.failures >= 5) continue;
                return true;
            }
        }
        return false;
    }

    public final Node getReadNode(Partition partition, Replica replica) throws AerospikeException.InvalidNode {
        switch (replica) {
            default: {
                return this.getMasterNode(partition);
            }
            case MASTER_PROLES: {
                return this.getMasterProlesNode(partition);
            }
            case RANDOM: 
        }
        return this.getRandomNode();
    }

    public final Node getMasterNode(Partition partition) throws AerospikeException.InvalidNode {
        Node node;
        HashMap<String, AtomicReferenceArray<Node>[]> map = this.partitionMap;
        AtomicReferenceArray<Node>[] replicaArray = map.get(partition.namespace);
        if (replicaArray != null && (node = replicaArray[0].get(partition.partitionId)) != null && node.isActive()) {
            return node;
        }
        return this.getRandomNode();
    }

    public final Node getMasterProlesNode(Partition partition) throws AerospikeException.InvalidNode {
        HashMap<String, AtomicReferenceArray<Node>[]> map = this.partitionMap;
        AtomicReferenceArray<Node>[] replicaArray = map.get(partition.namespace);
        if (replicaArray != null) {
            for (int i = 0; i < replicaArray.length; ++i) {
                int index2 = Math.abs(this.replicaIndex.getAndIncrement() % replicaArray.length);
                Node node = replicaArray[index2].get(partition.partitionId);
                if (node == null || !node.isActive()) continue;
                return node;
            }
        }
        return this.getRandomNode();
    }

    public final Node getRandomNode() throws AerospikeException.InvalidNode {
        Node[] nodeArray = this.nodes;
        for (int i = 0; i < nodeArray.length; ++i) {
            int index2 = Math.abs(this.nodeIndex.getAndIncrement() % nodeArray.length);
            Node node = nodeArray[index2];
            if (!node.isActive()) continue;
            return node;
        }
        throw new AerospikeException.InvalidNode();
    }

    public final Node[] getNodes() {
        Node[] nodeArray = this.nodes;
        return nodeArray;
    }

    public final Node getNode(String nodeName) throws AerospikeException.InvalidNode {
        Node node = this.findNode(nodeName);
        if (node == null) {
            throw new AerospikeException.InvalidNode();
        }
        return node;
    }

    protected final Node findNode(String nodeName) {
        Node[] nodeArray;
        for (Node node : nodeArray = this.nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    public final void printPartitionMap() {
        for (Map.Entry<String, AtomicReferenceArray<Node>[]> entry : this.partitionMap.entrySet()) {
            String namespace = entry.getKey();
            AtomicReferenceArray<Node>[] replicaArray = entry.getValue();
            for (int i = 0; i < replicaArray.length; ++i) {
                AtomicReferenceArray<Node> nodeArray = replicaArray[i];
                int max = nodeArray.length();
                for (int j = 0; j < max; ++j) {
                    Node node = nodeArray.get(j);
                    if (node == null) continue;
                    Log.info(namespace + ',' + i + ',' + j + ',' + node);
                }
            }
        }
    }

    public void changePassword(byte[] user, String password) {
        if (this.user != null && Arrays.equals(user, this.user)) {
            this.password = Buffer.stringToUtf8(password);
        }
    }

    public final ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public final int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public final byte[] getUser() {
        return this.user;
    }

    public final byte[] getPassword() {
        return this.password;
    }

    @Override
    public void close() {
        if (!this.sharedThreadPool) {
            this.threadPool.shutdown();
        }
        this.tendValid = false;
        this.tendThread.interrupt();
        if (this.eventLoops == null) {
            Node[] nodeArray;
            for (Node node : nodeArray = this.nodes) {
                node.closeSyncConnections();
            }
        } else {
            final AtomicInteger eventLoopCount = new AtomicInteger(this.eventState.length);
            for (final EventState state : this.eventState) {
                state.eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (state.pending < 0) {
                            return;
                        }
                        if (state.pending > 0) {
                            state.eventLoop.schedule(this, 200L, TimeUnit.MILLISECONDS);
                            return;
                        }
                        Cluster.this.closeEventLoop(eventLoopCount, state);
                    }
                });
            }
            this.waitAsyncComplete();
        }
    }

    private final void closeEventLoop(AtomicInteger eventLoopCount, EventState state) {
        Node[] nodeArray;
        state.pending = -1;
        for (Node node : nodeArray = this.nodes) {
            node.closeAsyncConnections(state.index);
        }
        if (eventLoopCount.decrementAndGet() == 0) {
            for (Node node : nodeArray) {
                node.closeSyncConnections();
            }
            this.notifyAsyncComplete();
        }
    }

    private synchronized void waitAsyncComplete() {
        while (!this.asyncComplete) {
            try {
                super.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyAsyncComplete() {
        this.asyncComplete = true;
        super.notify();
    }
}

