/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.Log;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.ScheduleTask;
import com.aerospike.client.async.TimerTask;
import java.util.concurrent.TimeUnit;

public final class HashedWheelTimer
implements Runnable {
    private final EventLoop eventLoop;
    private final HashedWheelBucket[] wheel;
    private final ScheduleTask schedule;
    private final long tickDuration;
    private long startTime;
    private long tick;
    private final int mask;
    private boolean scheduled;

    public HashedWheelTimer(EventLoop eventLoop, long tickDuration, TimeUnit unit, int ticksPerWheel) {
        int normalizedTicksPerWheel;
        this.eventLoop = eventLoop;
        this.tickDuration = unit.toNanos(tickDuration);
        for (normalizedTicksPerWheel = 1; normalizedTicksPerWheel < ticksPerWheel; normalizedTicksPerWheel <<= 1) {
        }
        this.wheel = new HashedWheelBucket[normalizedTicksPerWheel];
        for (int i = 0; i < this.wheel.length; ++i) {
            this.wheel[i] = new HashedWheelBucket();
        }
        this.mask = this.wheel.length - 1;
        if (this.tickDuration >= Long.MAX_VALUE / (long)this.wheel.length) {
            throw new IllegalArgumentException(String.format("tickDuration: %d (expected: 0 < tickDuration in nanos < %d", tickDuration, Long.MAX_VALUE / (long)this.wheel.length));
        }
        this.schedule = new ScheduleTask(this);
    }

    public boolean isRunning() {
        return this.scheduled;
    }

    public HashedWheelTimeout addTimeout(TimerTask task, long deadline) {
        if (!this.scheduled) {
            this.scheduled = true;
            this.startTime = System.nanoTime();
            HashedWheelTimeout timeout = this.addTimeout(task, deadline);
            this.eventLoop.schedule(this.schedule, this.tickDuration, TimeUnit.NANOSECONDS);
            return timeout;
        }
        HashedWheelTimeout timeout = new HashedWheelTimeout(task, deadline - this.startTime);
        long calculated = timeout.deadline / this.tickDuration;
        timeout.remainingRounds = (calculated - this.tick) / (long)this.wheel.length;
        long ticks = Math.max(calculated, this.tick);
        int stopIndex = (int)(ticks & (long)this.mask);
        HashedWheelBucket bucket = this.wheel[stopIndex];
        bucket.addTimeout(timeout);
        return timeout;
    }

    public void restoreTimeout(HashedWheelTimeout timeout, long deadline) {
        timeout.deadline = deadline - this.startTime;
        timeout.next = null;
        timeout.prev = null;
        long calculated = timeout.deadline / this.tickDuration;
        timeout.remainingRounds = (calculated - this.tick) / (long)this.wheel.length;
        long ticks = Math.max(calculated, this.tick);
        int stopIndex = (int)(ticks & (long)this.mask);
        HashedWheelBucket bucket = this.wheel[stopIndex];
        bucket.addTimeout(timeout);
    }

    @Override
    public void run() {
        long expectTime;
        long currentTime = System.nanoTime() - this.startTime;
        for (expectTime = this.tickDuration * (this.tick + 1L); expectTime <= currentTime; expectTime += this.tickDuration) {
            int idx = (int)(this.tick & (long)this.mask);
            this.wheel[idx].expireTimeouts(currentTime);
            ++this.tick;
        }
        this.eventLoop.schedule(this.schedule, expectTime - currentTime, TimeUnit.NANOSECONDS);
    }

    private static final class HashedWheelBucket {
        private HashedWheelTimeout head;
        private HashedWheelTimeout tail;

        private HashedWheelBucket() {
        }

        public void addTimeout(HashedWheelTimeout timeout) {
            timeout.bucket = this;
            if (this.head == null) {
                this.head = this.tail = timeout;
            } else {
                this.tail.next = timeout;
                timeout.prev = this.tail;
                this.tail = timeout;
            }
        }

        public void expireTimeouts(long deadline) {
            HashedWheelTimeout timeout = this.head;
            while (timeout != null) {
                HashedWheelTimeout next = timeout.next;
                if (timeout.remainingRounds <= 0L) {
                    next = this.remove(timeout);
                    if (timeout.deadline > deadline && Log.warnEnabled()) {
                        Log.warn("timeout.deadline (" + timeout.deadline + ") > deadline (" + deadline + ")");
                    }
                    timeout.expire();
                } else {
                    timeout.remainingRounds--;
                }
                timeout = next;
            }
        }

        public HashedWheelTimeout remove(HashedWheelTimeout timeout) {
            HashedWheelTimeout next = timeout.next;
            if (timeout.prev != null) {
                timeout.prev.next = next;
            }
            if (timeout.next != null) {
                timeout.next.prev = timeout.prev;
            }
            if (timeout == this.head) {
                if (timeout == this.tail) {
                    this.tail = null;
                    this.head = null;
                } else {
                    this.head = next;
                }
            } else if (timeout == this.tail) {
                this.tail = timeout.prev;
            }
            timeout.prev = null;
            timeout.next = null;
            timeout.bucket = null;
            return next;
        }
    }

    public static final class HashedWheelTimeout {
        private final TimerTask task;
        private long deadline;
        private long remainingRounds;
        private HashedWheelTimeout next;
        private HashedWheelTimeout prev;
        private HashedWheelBucket bucket;

        private HashedWheelTimeout(TimerTask task, long deadline) {
            this.task = task;
            this.deadline = deadline;
        }

        public void cancel() {
            if (this.bucket != null) {
                this.bucket.remove(this);
            }
        }

        private void expire() {
            block2: {
                try {
                    this.task.timeout();
                }
                catch (Throwable t) {
                    if (!Log.warnEnabled()) break block2;
                    Log.warn("task.timeout() failed: " + t.getMessage());
                }
            }
        }
    }
}

