/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.Statement;
import java.util.concurrent.BlockingQueue;
import org.luaj.vm2.LuaValue;

public final class QueryAggregateCommand
extends MultiCommand {
    private final Statement statement;
    private final LuaInstance instance;
    private final BlockingQueue<LuaValue> inputQueue;

    public QueryAggregateCommand(Cluster cluster, Node node, QueryPolicy policy, Statement statement, LuaInstance instance, BlockingQueue<LuaValue> inputQueue, long clusterKey, boolean first) {
        super(cluster, (Policy)policy, node, statement.namespace, clusterKey, first);
        this.statement = statement;
        this.instance = instance;
        this.inputQueue = inputQueue;
    }

    @Override
    protected final void writeBuffer() throws AerospikeException {
        this.setQuery(this.policy, this.statement, false, null);
    }

    @Override
    protected void parseRow(Key key) {
        if (this.opCount != 1) {
            throw new AerospikeException("Query aggregate expected exactly one bin.  Received " + this.opCount);
        }
        int opSize = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
        this.dataOffset += 5;
        byte particleType = this.dataBuffer[this.dataOffset];
        this.dataOffset += 2;
        byte nameSize = this.dataBuffer[this.dataOffset++];
        String name = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, nameSize);
        this.dataOffset += nameSize;
        int particleBytesSize = opSize - (4 + nameSize);
        if (!name.equals("SUCCESS")) {
            if (name.equals("FAILURE")) {
                Object value = Buffer.bytesToParticle(particleType, this.dataBuffer, this.dataOffset, particleBytesSize);
                throw new AerospikeException(213, value.toString());
            }
            throw new AerospikeException(-2, "Query aggregate expected bin name SUCCESS.  Received " + name);
        }
        LuaValue aggregateValue = this.instance.getLuaValue(particleType, this.dataBuffer, this.dataOffset, particleBytesSize);
        this.dataOffset += particleBytesSize;
        if (!this.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        if (aggregateValue != null) {
            try {
                this.inputQueue.put(aggregateValue);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

