/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;

public final class QueryPartitionCommand
extends MultiCommand {
    private final Statement statement;
    private final RecordSet recordSet;
    private final PartitionTracker tracker;
    private final PartitionTracker.NodePartitions nodePartitions;

    public QueryPartitionCommand(Cluster cluster, Node node, Policy policy, Statement statement, RecordSet recordSet, PartitionTracker tracker, PartitionTracker.NodePartitions nodePartitions) {
        super(cluster, policy, nodePartitions.node, statement.namespace, tracker.socketTimeout, tracker.totalTimeout);
        this.statement = statement;
        this.recordSet = recordSet;
        this.tracker = tracker;
        this.nodePartitions = nodePartitions;
    }

    @Override
    public void execute() {
        block2: {
            try {
                this.executeCommand();
            }
            catch (AerospikeException ae) {
                if (this.tracker.shouldRetry(ae)) break block2;
                throw ae;
            }
        }
    }

    @Override
    protected final void writeBuffer() {
        this.setQuery(this.policy, this.statement, false, this.nodePartitions);
    }

    @Override
    protected void parseRow(Key key) {
        if ((this.info3 & 4) != 0) {
            this.tracker.partitionDone(this.nodePartitions, this.generation);
            return;
        }
        this.tracker.setDigest(this.nodePartitions, key);
        Record record = this.parseRecord();
        if (!this.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        if (!this.recordSet.put(new KeyRecord(key, record))) {
            this.stop();
            throw new AerospikeException.QueryTerminated();
        }
    }
}

