/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.lua.LuaBytes;
import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.util.Packer;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNil;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;

public abstract class Value {
    public static final Value NULL = NullValue.INSTANCE;
    public static final Value INFINITY = new InfinityValue();
    public static final Value WILDCARD = new WildcardValue();

    public static Value get(String value) {
        return value == null ? NullValue.INSTANCE : new StringValue(value);
    }

    public static Value get(byte[] value) {
        return value == null ? NullValue.INSTANCE : new BytesValue(value);
    }

    public static Value get(byte[] value, int offset, int length) {
        return value == null ? NullValue.INSTANCE : new ByteSegmentValue(value, offset, length);
    }

    public static Value get(byte value) {
        return new ByteValue(value);
    }

    public static Value get(int value) {
        return new IntegerValue(value);
    }

    public static Value get(long value) {
        return new LongValue(value);
    }

    public static Value get(double value) {
        return new DoubleValue(value);
    }

    public static Value get(float value) {
        return new FloatValue(value);
    }

    public static Value get(boolean value) {
        return new BooleanValue(value);
    }

    public static Value get(List<?> value) {
        return value == null ? NullValue.INSTANCE : new ListValue(value);
    }

    public static Value get(Map<?, ?> value) {
        return value == null ? NullValue.INSTANCE : new MapValue(value);
    }

    public static Value get(Value[] value) {
        return value == null ? NullValue.INSTANCE : new ValueArray(value);
    }

    public static Value getAsBlob(Object value) {
        return value == null ? NullValue.INSTANCE : new BlobValue(value);
    }

    public static Value getAsGeoJSON(String value) {
        return value == null ? NullValue.INSTANCE : new GeoJSONValue(value);
    }

    public static Value getAsNull() {
        return NullValue.INSTANCE;
    }

    public static Value get(Object value) {
        if (value == null) {
            return NullValue.INSTANCE;
        }
        if (value instanceof Value) {
            return (Value)value;
        }
        if (value instanceof byte[]) {
            return new BytesValue((byte[])value);
        }
        if (value instanceof String) {
            return new StringValue((String)value);
        }
        if (value instanceof Integer) {
            return new IntegerValue((Integer)value);
        }
        if (value instanceof Long) {
            return new LongValue((Long)value);
        }
        if (value instanceof Double) {
            return new DoubleValue((Double)value);
        }
        if (value instanceof Float) {
            return new FloatValue(((Float)value).floatValue());
        }
        if (value instanceof Boolean) {
            return new BooleanValue((Boolean)value);
        }
        if (value instanceof Byte) {
            return new ByteValue((Byte)value);
        }
        if (value instanceof List) {
            return new ListValue((List)value);
        }
        if (value instanceof Map) {
            return new MapValue((Map)value);
        }
        return new BlobValue(value);
    }

    public static Value getFromRecordObject(Object value) {
        return Value.get(value);
    }

    public abstract int estimateSize() throws AerospikeException;

    public abstract int write(byte[] var1, int var2) throws AerospikeException;

    public abstract void pack(Packer var1);

    public void validateKeyType() throws AerospikeException {
    }

    public abstract int getType();

    public abstract Object getObject();

    public abstract LuaValue getLuaValue(LuaInstance var1);

    public int toInteger() {
        return 0;
    }

    public long toLong() {
        return 0L;
    }

    public static final class WildcardValue
    extends Value {
        @Override
        public int estimateSize() {
            return 0;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            return 0;
        }

        @Override
        public void pack(Packer packer) {
            packer.packWildcard();
        }

        @Override
        public void validateKeyType() {
            throw new AerospikeException(4, "Invalid key type: wildcard");
        }

        @Override
        public int getType() {
            throw new AerospikeException(4, "Invalid particle type: wildcard");
        }

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            throw new AerospikeException(4, "Invalid lua type: wildcard");
        }

        public String toString() {
            return "*";
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass());
        }

        public final int hashCode() {
            return 0;
        }
    }

    public static final class InfinityValue
    extends Value {
        @Override
        public int estimateSize() {
            return 0;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            return 0;
        }

        @Override
        public void pack(Packer packer) {
            packer.packInfinity();
        }

        @Override
        public void validateKeyType() {
            throw new AerospikeException(4, "Invalid key type: INF");
        }

        @Override
        public int getType() {
            throw new AerospikeException(4, "Invalid particle type: INF");
        }

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            throw new AerospikeException(4, "Invalid lua type: INF");
        }

        public String toString() {
            return "INF";
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass());
        }

        public final int hashCode() {
            return 0;
        }
    }

    public static final class MapValue
    extends Value {
        private final Map<?, ?> map;
        private byte[] bytes;

        public MapValue(Map<?, ?> map) {
            this.map = map;
        }

        @Override
        public int estimateSize() throws AerospikeException {
            this.bytes = Packer.pack(this.map);
            return this.bytes.length;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) {
            packer.packMap(this.map);
        }

        @Override
        public void validateKeyType() {
            throw new AerospikeException(4, "Invalid key type: map");
        }

        @Override
        public int getType() {
            return 19;
        }

        @Override
        public Object getObject() {
            return this.map;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return instance.getLuaMap(this.map);
        }

        public String toString() {
            return this.map.toString();
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.map.equals(((MapValue)other).map);
        }

        public int hashCode() {
            return this.map.hashCode();
        }
    }

    public static final class ListValue
    extends Value {
        private final List<?> list;
        private byte[] bytes;

        public ListValue(List<?> list) {
            this.list = list;
        }

        @Override
        public int estimateSize() throws AerospikeException {
            this.bytes = Packer.pack(this.list);
            return this.bytes.length;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) {
            packer.packList(this.list);
        }

        @Override
        public void validateKeyType() {
            throw new AerospikeException(4, "Invalid key type: list");
        }

        @Override
        public int getType() {
            return 20;
        }

        @Override
        public Object getObject() {
            return this.list;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return instance.getLuaList(this.list);
        }

        public String toString() {
            return this.list.toString();
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.list.equals(((ListValue)other).list);
        }

        public int hashCode() {
            return this.list.hashCode();
        }
    }

    public static final class ValueArray
    extends Value {
        private final Value[] array;
        private byte[] bytes;

        public ValueArray(Value[] array) {
            this.array = array;
        }

        @Override
        public int estimateSize() throws AerospikeException {
            this.bytes = Packer.pack(this.array);
            return this.bytes.length;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) {
            packer.packValueArray(this.array);
        }

        @Override
        public void validateKeyType() {
            throw new AerospikeException(4, "Invalid key type: value[]");
        }

        @Override
        public int getType() {
            return 20;
        }

        @Override
        public Object getObject() {
            return this.array;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return instance.getLuaList(this.array);
        }

        public String toString() {
            return Arrays.toString(this.array);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && Arrays.equals(this.array, ((ValueArray)other).array);
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    public static final class GeoJSONValue
    extends Value {
        private final String value;

        public GeoJSONValue(String value) {
            this.value = value;
        }

        @Override
        public int estimateSize() {
            return 3 + Buffer.estimateSizeUtf8(this.value);
        }

        @Override
        public int write(byte[] buffer, int offset) {
            buffer[offset] = 0;
            Buffer.shortToBytes(0, buffer, offset + 1);
            return 3 + Buffer.stringToUtf8(this.value, buffer, offset + 3);
        }

        @Override
        public void pack(Packer packer) {
            packer.packGeoJSON(this.value);
        }

        @Override
        public void validateKeyType() {
            throw new AerospikeException(4, "Invalid key type: GeoJson");
        }

        @Override
        public int getType() {
            return 23;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaString.valueOf((String)this.value);
        }

        public String toString() {
            return this.value;
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value.equals(((GeoJSONValue)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class BlobValue
    extends Value {
        private final Object object;
        private byte[] bytes;

        public BlobValue(Object object) {
            this.object = object;
        }

        @Override
        public int estimateSize() throws AerospikeException.Serialize {
            try {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream();
                ObjectOutputStream ostream = new ObjectOutputStream(bstream);
                ostream.writeObject(this.object);
                ostream.close();
                this.bytes = bstream.toByteArray();
                return this.bytes.length;
            }
            catch (Exception e) {
                throw new AerospikeException.Serialize(e);
            }
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) {
            packer.packBlob(this.object);
        }

        @Override
        public void validateKeyType() {
            throw new AerospikeException(4, "Invalid key type: jblob");
        }

        @Override
        public int getType() {
            return 7;
        }

        @Override
        public Object getObject() {
            return this.object;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaString.valueOf((byte[])this.bytes);
        }

        public String toString() {
            return Buffer.bytesToHexString(this.bytes);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.object.equals(((BlobValue)other).object);
        }

        public int hashCode() {
            return this.object.hashCode();
        }
    }

    public static final class BooleanValue
    extends Value {
        private final boolean value;

        public BooleanValue(boolean value) {
            this.value = value;
        }

        @Override
        public int estimateSize() {
            return 8;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            Buffer.longToBytes(this.value ? 1L : 0L, buffer, offset);
            return 8;
        }

        @Override
        public void pack(Packer packer) {
            packer.packBoolean(this.value);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaBoolean.valueOf((boolean)this.value);
        }

        public String toString() {
            return Boolean.toString(this.value);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value == ((BooleanValue)other).value;
        }

        public int hashCode() {
            return this.value ? 1231 : 1237;
        }

        @Override
        public int toInteger() {
            return this.value ? 1 : 0;
        }

        @Override
        public long toLong() {
            return this.value ? 1L : 0L;
        }
    }

    public static final class FloatValue
    extends Value {
        private final float value;

        public FloatValue(float value) {
            this.value = value;
        }

        @Override
        public int estimateSize() {
            return 8;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            Buffer.doubleToBytes(this.value, buffer, offset);
            return 8;
        }

        @Override
        public void pack(Packer packer) {
            packer.packFloat(this.value);
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public Object getObject() {
            return Float.valueOf(this.value);
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaDouble.valueOf((double)this.value);
        }

        public String toString() {
            return Float.toString(this.value);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value == ((FloatValue)other).value;
        }

        public int hashCode() {
            return Float.floatToIntBits(this.value);
        }

        @Override
        public int toInteger() {
            return (int)this.value;
        }

        @Override
        public long toLong() {
            return (long)this.value;
        }
    }

    public static final class DoubleValue
    extends Value {
        private final double value;

        public DoubleValue(double value) {
            this.value = value;
        }

        @Override
        public int estimateSize() {
            return 8;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            Buffer.doubleToBytes(this.value, buffer, offset);
            return 8;
        }

        @Override
        public void pack(Packer packer) {
            packer.packDouble(this.value);
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaDouble.valueOf((double)this.value);
        }

        public String toString() {
            return Double.toString(this.value);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value == ((DoubleValue)other).value;
        }

        public int hashCode() {
            long bits = Double.doubleToLongBits(this.value);
            return (int)(bits ^ bits >>> 32);
        }

        @Override
        public int toInteger() {
            return (int)this.value;
        }

        @Override
        public long toLong() {
            return (long)this.value;
        }
    }

    public static final class LongValue
    extends Value {
        private final long value;

        public LongValue(long value) {
            this.value = value;
        }

        @Override
        public int estimateSize() {
            return 8;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            Buffer.longToBytes(this.value, buffer, offset);
            return 8;
        }

        @Override
        public void pack(Packer packer) {
            packer.packLong(this.value);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaInteger.valueOf((long)this.value);
        }

        public String toString() {
            return Long.toString(this.value);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value == ((LongValue)other).value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        @Override
        public int toInteger() {
            return (int)this.value;
        }

        @Override
        public long toLong() {
            return this.value;
        }
    }

    public static final class IntegerValue
    extends Value {
        private final int value;

        public IntegerValue(int value) {
            this.value = value;
        }

        @Override
        public int estimateSize() {
            return 8;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            Buffer.longToBytes(this.value, buffer, offset);
            return 8;
        }

        @Override
        public void pack(Packer packer) {
            packer.packInt(this.value);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaInteger.valueOf((int)this.value);
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value == ((IntegerValue)other).value;
        }

        public int hashCode() {
            return this.value;
        }

        @Override
        public int toInteger() {
            return this.value;
        }

        @Override
        public long toLong() {
            return this.value;
        }
    }

    public static final class StringValue
    extends Value {
        private final String value;

        public StringValue(String value) {
            this.value = value;
        }

        @Override
        public int estimateSize() {
            return Buffer.estimateSizeUtf8(this.value);
        }

        @Override
        public int write(byte[] buffer, int offset) {
            return Buffer.stringToUtf8(this.value, buffer, offset);
        }

        @Override
        public void pack(Packer packer) {
            packer.packString(this.value);
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaString.valueOf((String)this.value);
        }

        public String toString() {
            return this.value;
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value.equals(((StringValue)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class ByteValue
    extends Value {
        private final byte value;

        public ByteValue(byte value) {
            this.value = value;
        }

        @Override
        public int estimateSize() {
            return 8;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            Buffer.longToBytes(this.value, buffer, offset);
            return 8;
        }

        @Override
        public void pack(Packer packer) {
            packer.packByte(this.value);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaInteger.valueOf((int)this.value);
        }

        public String toString() {
            return Byte.toString(this.value);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value == ((ByteValue)other).value;
        }

        public int hashCode() {
            return this.value;
        }

        @Override
        public int toInteger() {
            return this.value;
        }

        @Override
        public long toLong() {
            return this.value;
        }
    }

    public static final class ByteSegmentValue
    extends Value {
        private final byte[] bytes;
        private final int offset;
        private final int length;

        public ByteSegmentValue(byte[] bytes, int offset, int length) {
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int estimateSize() {
            return this.length;
        }

        @Override
        public int write(byte[] buffer, int targetOffset) {
            System.arraycopy(this.bytes, this.offset, buffer, targetOffset, this.length);
            return this.length;
        }

        @Override
        public void pack(Packer packer) {
            packer.packBytes(this.bytes, this.offset, this.length);
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public Object getObject() {
            return this;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaString.valueOf((byte[])this.bytes, (int)this.offset, (int)this.length);
        }

        public String toString() {
            return Buffer.bytesToHexString(this.bytes, this.offset, this.length);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            ByteSegmentValue other = (ByteSegmentValue)obj;
            if (this.length != other.length) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.bytes[this.offset + i] == other.bytes[other.offset + i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 1;
            for (int i = 0; i < this.length; ++i) {
                result = 31 * result + this.bytes[this.offset + i];
            }
            return result;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }
    }

    public static final class BytesValue
    extends Value {
        private final byte[] bytes;

        public BytesValue(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public int estimateSize() {
            return this.bytes.length;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) {
            packer.packBytes(this.bytes);
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public Object getObject() {
            return this.bytes;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return new LuaBytes(instance, this.bytes);
        }

        public String toString() {
            return Buffer.bytesToHexString(this.bytes);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && Arrays.equals(this.bytes, ((BytesValue)other).bytes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }
    }

    public static final class NullValue
    extends Value {
        public static final NullValue INSTANCE = new NullValue();

        @Override
        public int estimateSize() {
            return 0;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            return 0;
        }

        @Override
        public void pack(Packer packer) {
            packer.packNil();
        }

        @Override
        public void validateKeyType() {
            throw new AerospikeException(4, "Invalid key type: null");
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaNil.NIL;
        }

        public String toString() {
            return null;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return true;
            }
            return this.getClass().equals(other.getClass());
        }

        public final int hashCode() {
            return 0;
        }
    }
}

