/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.listener.ExistsListener;
import com.aerospike.client.policy.Policy;

public final class AsyncExists
extends AsyncCommand {
    private final ExistsListener listener;
    private final Key key;
    private final Partition partition;
    private boolean exists;

    public AsyncExists(Cluster cluster, ExistsListener listener, Policy policy, Key key) {
        super(policy, true, true);
        this.listener = listener;
        this.key = key;
        this.partition = Partition.read(cluster, policy, key);
    }

    @Override
    Node getNode(Cluster cluster) {
        return this.partition.getNodeRead(cluster);
    }

    @Override
    protected void writeBuffer() {
        this.setExists(this.policy, this.key);
    }

    @Override
    protected boolean parseResult() {
        this.validateHeaderSize();
        int resultCode = this.dataBuffer[5] & 0xFF;
        if (resultCode == 0) {
            this.exists = true;
            return true;
        }
        if (resultCode == 2) {
            this.exists = false;
            return true;
        }
        if (resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            this.exists = true;
            return true;
        }
        throw new AerospikeException(resultCode);
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryRead(timeout);
        return true;
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.exists);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

