/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.policy.Policy;
import java.util.HashMap;
import java.util.Map;

public class AsyncRead
extends AsyncCommand {
    private final RecordListener listener;
    protected final Key key;
    private final String[] binNames;
    protected Partition partition;
    protected Record record;

    public AsyncRead(Cluster cluster, RecordListener listener, Policy policy, Key key, String[] binNames) {
        super(policy, true, true);
        this.listener = listener;
        this.key = key;
        this.binNames = binNames;
        this.partition = Partition.read(cluster, policy, key);
    }

    public AsyncRead(RecordListener listener, Policy policy, Key key, boolean isRead, Partition partition) {
        super(policy, isRead, true);
        this.listener = listener;
        this.key = key;
        this.binNames = null;
        this.partition = partition;
    }

    @Override
    Node getNode(Cluster cluster) {
        return this.partition.getNodeRead(cluster);
    }

    @Override
    protected void writeBuffer() {
        this.setRead(this.policy, this.key, this.binNames);
    }

    @Override
    protected final boolean parseResult() {
        this.validateHeaderSize();
        int resultCode = this.dataBuffer[5] & 0xFF;
        int generation = Buffer.bytesToInt(this.dataBuffer, 6);
        int expiration = Buffer.bytesToInt(this.dataBuffer, 10);
        int fieldCount = Buffer.bytesToShort(this.dataBuffer, 18);
        int opCount = Buffer.bytesToShort(this.dataBuffer, 20);
        this.dataOffset = 22;
        if (resultCode == 0) {
            if (opCount == 0) {
                this.record = new Record(null, generation, expiration);
                return true;
            }
            this.record = this.parseRecord(opCount, fieldCount, generation, expiration);
            return true;
        }
        if (resultCode == 2) {
            this.handleNotFound(resultCode);
            return true;
        }
        if (resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            return true;
        }
        if (resultCode == 100) {
            this.record = this.parseRecord(opCount, fieldCount, generation, expiration);
            this.handleUdfError(resultCode);
            return true;
        }
        throw new AerospikeException(resultCode);
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryRead(timeout);
        return true;
    }

    protected void handleNotFound(int resultCode) {
    }

    private final void handleUdfError(int resultCode) {
        String message;
        int code;
        String ret = (String)this.record.bins.get("FAILURE");
        if (ret == null) {
            throw new AerospikeException(resultCode);
        }
        try {
            String[] list = ret.split(":");
            code = Integer.parseInt(list[2].trim());
            message = list[0] + ':' + list[1] + ' ' + list[3];
        }
        catch (Exception e) {
            throw new AerospikeException(resultCode, ret);
        }
        throw new AerospikeException(code, message);
    }

    private final Record parseRecord(int opCount, int fieldCount, int generation, int expiration) {
        if (fieldCount > 0) {
            for (int i = 0; i < fieldCount; ++i) {
                int fieldSize = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
                this.dataOffset += 4 + fieldSize;
            }
        }
        HashMap<String, Object> bins = null;
        for (int i = 0; i < opCount; ++i) {
            int opSize = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            byte particleType = this.dataBuffer[this.dataOffset + 5];
            byte nameSize = this.dataBuffer[this.dataOffset + 7];
            String name = Buffer.utf8ToString(this.dataBuffer, this.dataOffset + 8, nameSize);
            this.dataOffset += 8 + nameSize;
            int particleBytesSize = opSize - (4 + nameSize);
            Object value = null;
            value = Buffer.bytesToParticle(particleType, this.dataBuffer, this.dataOffset, particleBytesSize);
            this.dataOffset += particleBytesSize;
            if (bins == null) {
                bins = new HashMap<String, Object>();
            }
            this.addBin(bins, name, value);
        }
        return new Record(bins, generation, expiration);
    }

    protected void addBin(Map<String, Object> bins, String name, Object value) {
        bins.put(name, value);
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.record);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

