/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.HashedWheelTimer;
import com.aerospike.client.async.NettyConnection;
import com.aerospike.client.async.NettyEventLoop;
import com.aerospike.client.async.NettyRecover;
import com.aerospike.client.async.TimerTask;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.Command;
import com.aerospike.client.policy.TlsPolicy;
import com.aerospike.client.util.Util;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;

public final class NettyCommand
implements Runnable,
TimerTask {
    final NettyEventLoop eventLoop;
    final Cluster cluster;
    final AsyncCommand command;
    final EventState eventState;
    Node node;
    NettyConnection conn;
    HashedWheelTimer.HashedWheelTimeout timeoutTask;
    long totalDeadline;
    int state;
    int iteration;
    int commandSentCounter;
    final boolean hasTotalTimeout;
    boolean usingSocketTimeout;
    boolean eventReceived;
    boolean connectInProgress;

    public NettyCommand(NettyEventLoop loop, Cluster cluster, AsyncCommand command) {
        this.eventLoop = loop;
        this.cluster = cluster;
        this.eventState = cluster.eventState[loop.index];
        this.command = command;
        command.bufferQueue = loop.bufferQueue;
        boolean bl = this.hasTotalTimeout = command.policy.totalTimeout > 0;
        if (this.eventLoop.eventLoop.inEventLoop() && this.eventState.errors < 5) {
            this.run();
        } else {
            if (this.hasTotalTimeout) {
                this.totalDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(command.policy.totalTimeout);
            }
            this.state = 1;
            this.eventLoop.execute(this);
        }
    }

    public NettyCommand(NettyCommand other, AsyncCommand command, long deadline) {
        this.eventLoop = other.eventLoop;
        this.cluster = other.cluster;
        this.command = command;
        this.eventState = other.eventState;
        this.totalDeadline = other.totalDeadline;
        this.iteration = other.iteration;
        this.commandSentCounter = other.commandSentCounter;
        this.hasTotalTimeout = other.hasTotalTimeout;
        this.usingSocketTimeout = other.usingSocketTimeout;
        command.bufferQueue = this.eventLoop.bufferQueue;
        if (this.eventState.pending++ == -1) {
            this.eventState.pending = -1;
            ++this.eventState.errors;
            this.state = 10;
            this.notifyFailure(new AerospikeException("Cluster has been closed"));
            return;
        }
        if (deadline > 0L) {
            this.timeoutTask = this.eventLoop.timer.addTimeout(this, deadline);
        }
        if (this.eventLoop.maxCommandsInProcess > 0) {
            this.eventLoop.executeFromDelayQueue();
            if (this.eventLoop.pending >= this.eventLoop.maxCommandsInProcess) {
                if (this.eventLoop.maxCommandsInQueue > 0 && this.eventLoop.delayQueue.size() >= this.eventLoop.maxCommandsInQueue) {
                    this.queueError(new AerospikeException.AsyncQueueFull());
                    return;
                }
                this.eventLoop.delayQueue.addLast(this);
                this.state = 2;
                return;
            }
        }
        ++this.eventLoop.pending;
        this.executeCommand();
    }

    @Override
    public void run() {
        if (this.eventState.pending++ == -1) {
            this.eventState.pending = -1;
            ++this.eventState.errors;
            this.state = 10;
            this.notifyFailure(new AerospikeException("Cluster has been closed"));
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout) {
            currentTime = System.nanoTime();
            if (this.state == 1) {
                if (currentTime >= this.totalDeadline) {
                    this.queueError(new AerospikeException.Timeout(this.command.policy, true));
                    return;
                }
            } else {
                this.totalDeadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.policy.totalTimeout);
            }
        }
        if (this.eventLoop.maxCommandsInProcess > 0) {
            this.eventLoop.executeFromDelayQueue();
            if (this.eventLoop.pending >= this.eventLoop.maxCommandsInProcess) {
                if (this.eventLoop.maxCommandsInQueue > 0 && this.eventLoop.delayQueue.size() >= this.eventLoop.maxCommandsInQueue) {
                    this.queueError(new AerospikeException.AsyncQueueFull());
                    return;
                }
                this.eventLoop.delayQueue.addLast(this);
                if (this.hasTotalTimeout) {
                    this.timeoutTask = this.eventLoop.timer.addTimeout(this, this.totalDeadline);
                }
                this.state = 2;
                return;
            }
        }
        if (this.hasTotalTimeout) {
            long deadline;
            if (this.command.policy.socketTimeout > 0) {
                deadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
                if (deadline < this.totalDeadline) {
                    this.usingSocketTimeout = true;
                } else {
                    deadline = this.totalDeadline;
                }
            } else {
                deadline = this.totalDeadline;
            }
            this.timeoutTask = this.eventLoop.timer.addTimeout(this, deadline);
        } else if (this.command.policy.socketTimeout > 0) {
            this.usingSocketTimeout = true;
            this.timeoutTask = this.eventLoop.timer.addTimeout(this, System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout));
        }
        ++this.eventLoop.pending;
        this.executeCommand();
    }

    private final void queueError(AerospikeException ae) {
        --this.eventState.pending;
        ++this.eventState.errors;
        this.state = 10;
        this.notifyFailure(ae);
    }

    final void executeCommandFromDelayQueue() {
        if (this.command.policy.socketTimeout > 0) {
            long socketDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
            if (this.hasTotalTimeout) {
                if (socketDeadline < this.totalDeadline) {
                    this.timeoutTask.cancel();
                    this.usingSocketTimeout = true;
                    this.eventLoop.timer.restoreTimeout(this.timeoutTask, socketDeadline);
                }
            } else {
                this.usingSocketTimeout = true;
                this.timeoutTask = this.eventLoop.timer.addTimeout(this, socketDeadline);
            }
        }
        ++this.eventLoop.pending;
        this.executeCommand();
    }

    private void executeCommand() {
        this.state = 3;
        ++this.iteration;
        try {
            this.node = this.command.getNode(this.cluster);
            this.conn = (NettyConnection)this.node.getAsyncConnection(this.eventState.index, null);
            if (this.conn != null) {
                InboundHandler handler = (InboundHandler)this.conn.channel.pipeline().last();
                handler.command = this;
                this.writeCommand();
                return;
            }
            this.connectInProgress = true;
            final int itr = this.iteration;
            final InboundHandler handler = new InboundHandler();
            handler.command = this;
            Bootstrap b = new Bootstrap();
            b.group((EventLoopGroup)this.eventLoop.eventLoop);
            if (this.eventLoop.parent.isEpoll) {
                b.channel(EpollSocketChannel.class);
            } else {
                b.channel(NioSocketChannel.class);
            }
            b.option(ChannelOption.TCP_NODELAY, (Object)true);
            b.option(ChannelOption.AUTO_READ, (Object)false);
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    if (NettyCommand.this.state != 3 || itr != NettyCommand.this.iteration) {
                        ch.close();
                        NettyCommand.this.connectInProgress = false;
                        return;
                    }
                    NettyCommand.this.conn = new NettyConnection(ch, NettyCommand.this.cluster.maxSocketIdleNanos);
                    NettyCommand.this.node.connectionOpened(NettyCommand.this.eventLoop.index);
                    NettyCommand.this.connectInProgress = false;
                    ChannelPipeline p = ch.pipeline();
                    if (NettyCommand.this.eventLoop.parent.sslContext != null && !NettyCommand.this.eventLoop.parent.tlsPolicy.forLoginOnly) {
                        p.addLast(new ChannelHandler[]{NettyCommand.this.eventLoop.parent.sslContext.newHandler(ch.alloc())});
                    }
                    p.addLast(new ChannelHandler[]{handler});
                }
            });
            b.connect((SocketAddress)this.node.getAddress());
            this.eventState.errors = 0;
        }
        catch (AerospikeException.Connection ac) {
            ++this.eventState.errors;
            this.onNetworkError(ac);
        }
        catch (Exception e) {
            ++this.eventState.errors;
            this.fail();
            this.notifyFailure(new AerospikeException(e));
            this.eventLoop.tryDelayQueue();
        }
    }

    private void channelActive() {
        if (this.state == 10) {
            return;
        }
        if (this.cluster.getUser() != null) {
            this.writeAuth();
        } else {
            this.writeCommand();
        }
    }

    private void writeAuth() {
        this.state = 4;
        this.command.initBuffer();
        AdminCommand admin = new AdminCommand(this.command.dataBuffer);
        this.command.dataOffset = admin.setAuthenticate(this.cluster, this.node.getSessionToken());
        this.writeByteBuffer();
    }

    private void writeCommand() {
        this.state = 7;
        this.command.writeBuffer();
        this.writeByteBuffer();
    }

    private void writeByteBuffer() {
        ByteBuf byteBuffer = PooledByteBufAllocator.DEFAULT.directBuffer(this.command.dataOffset);
        byteBuffer.clear();
        byteBuffer.writeBytes(this.command.dataBuffer, 0, this.command.dataOffset);
        ChannelFuture cf = this.conn.channel.writeAndFlush((Object)byteBuffer);
        cf.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (NettyCommand.this.state == 7) {
                    NettyCommand.this.state = 8;
                    ++NettyCommand.this.commandSentCounter;
                } else {
                    NettyCommand.this.state = 5;
                }
                NettyCommand.this.command.dataOffset = 0;
                NettyCommand.this.eventReceived = false;
                NettyCommand.this.conn.channel.config().setAutoRead(true);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void read(ByteBuf byteBuffer) {
        this.eventReceived = true;
        try {
            switch (this.state) {
                case 5: {
                    this.readAuthHeader(byteBuffer);
                    return;
                }
                case 6: {
                    this.readAuthBody(byteBuffer);
                    return;
                }
                case 8: {
                    if (this.command.isSingle) {
                        this.readSingleHeader(byteBuffer);
                        return;
                    }
                    this.readMultiHeader(byteBuffer);
                    return;
                }
                case 9: {
                    if (this.command.isSingle) {
                        this.readSingleBody(byteBuffer);
                        return;
                    }
                    this.readMultiBody(byteBuffer);
                    return;
                }
            }
            return;
        }
        finally {
            byteBuffer.release();
        }
    }

    private void readAuthHeader(ByteBuf byteBuffer) {
        int avail = byteBuffer.readableBytes();
        int offset = this.command.dataOffset + avail;
        if (offset < 8) {
            byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, avail);
            this.command.dataOffset = offset;
            return;
        }
        byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, 8 - this.command.dataOffset);
        this.command.receiveSize = (int)(Buffer.bytesToLong(this.command.dataBuffer, 0) & 0xFFFFFFFFFFFFL);
        if (this.command.receiveSize < 2 || this.command.receiveSize > this.command.dataBuffer.length) {
            throw new AerospikeException.Parse("Invalid auth receive size: " + this.command.receiveSize);
        }
        this.state = 6;
        this.command.dataOffset = offset -= 8;
        if (offset > 0) {
            byteBuffer.readBytes(this.command.dataBuffer, 0, offset);
            if (offset >= this.command.receiveSize) {
                this.parseAuthBody();
            }
        }
    }

    private void readAuthBody(ByteBuf byteBuffer) {
        int avail = byteBuffer.readableBytes();
        int offset = this.command.dataOffset + avail;
        if (offset < this.command.receiveSize) {
            byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, avail);
            this.command.dataOffset = offset;
            return;
        }
        this.parseAuthBody();
    }

    private void parseAuthBody() {
        int resultCode = this.command.dataBuffer[1] & 0xFF;
        if (resultCode != 0 && resultCode != 52) {
            this.node.signalLogin();
            throw new AerospikeException(resultCode);
        }
        this.writeCommand();
    }

    private void readSingleHeader(ByteBuf byteBuffer) {
        int readableBytes = byteBuffer.readableBytes();
        int dataSize = this.command.dataOffset + readableBytes;
        if (dataSize < 8) {
            byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, readableBytes);
            this.command.dataOffset = dataSize;
            return;
        }
        dataSize = 8 - this.command.dataOffset;
        byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, dataSize);
        readableBytes -= dataSize;
        this.command.receiveSize = (int)(Buffer.bytesToLong(this.command.dataBuffer, 0) & 0xFFFFFFFFFFFFL);
        if (this.command.receiveSize < 22) {
            throw new AerospikeException.Parse("Invalid receive size: " + this.command.receiveSize);
        }
        this.command.sizeBuffer(this.command.receiveSize);
        this.state = 9;
        if (readableBytes <= 0) {
            this.command.dataOffset = 0;
            return;
        }
        dataSize = readableBytes >= this.command.receiveSize ? this.command.receiveSize : readableBytes;
        byteBuffer.readBytes(this.command.dataBuffer, 0, dataSize);
        this.command.dataOffset = dataSize;
        if (this.command.dataOffset >= this.command.receiveSize) {
            this.parseSingleBody();
        }
    }

    private void readSingleBody(ByteBuf byteBuffer) {
        int needBytes;
        int readableBytes = byteBuffer.readableBytes();
        int dataSize = readableBytes >= (needBytes = this.command.receiveSize - this.command.dataOffset) ? needBytes : readableBytes;
        byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, dataSize);
        this.command.dataOffset += dataSize;
        if (this.command.dataOffset >= this.command.receiveSize) {
            this.parseSingleBody();
        }
    }

    private void parseSingleBody() {
        this.command.parseResult();
        this.finish();
    }

    private final void readMultiHeader(ByteBuf byteBuffer) {
        if (!this.command.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        int readableBytes = byteBuffer.readableBytes();
        while (true) {
            int dataSize;
            if ((dataSize = this.command.dataOffset + readableBytes) < 8) {
                byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, readableBytes);
                this.command.dataOffset = dataSize;
                return;
            }
            dataSize = 8 - this.command.dataOffset;
            byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, dataSize);
            readableBytes -= dataSize;
            this.command.receiveSize = (int)(Buffer.bytesToLong(this.command.dataBuffer, 0) & 0xFFFFFFFFFFFFL);
            if (this.command.receiveSize == 0) {
                this.command.dataOffset = 0;
                continue;
            }
            this.command.sizeBuffer(this.command.receiveSize);
            this.state = 9;
            if (readableBytes <= 0) {
                return;
            }
            dataSize = readableBytes >= this.command.receiveSize ? this.command.receiveSize : readableBytes;
            byteBuffer.readBytes(this.command.dataBuffer, 0, dataSize);
            readableBytes -= dataSize;
            this.command.dataOffset = dataSize;
            if (this.command.dataOffset < this.command.receiveSize) {
                return;
            }
            if (this.command.parseResult()) {
                this.finish();
                return;
            }
            this.state = 8;
            this.command.dataOffset = 0;
        }
    }

    private final void readMultiBody(ByteBuf byteBuffer) {
        int needBytes;
        if (!this.command.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        int readableBytes = byteBuffer.readableBytes();
        int dataSize = readableBytes >= (needBytes = this.command.receiveSize - this.command.dataOffset) ? needBytes : readableBytes;
        byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, dataSize);
        this.command.dataOffset += dataSize;
        if (this.command.dataOffset < this.command.receiveSize) {
            return;
        }
        if (this.command.parseResult()) {
            this.finish();
            return;
        }
        this.state = 8;
        this.command.dataOffset = 0;
        this.readMultiHeader(byteBuffer);
    }

    @Override
    public final void timeout() {
        if (this.state == 10) {
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout) {
            currentTime = System.nanoTime();
            if (currentTime >= this.totalDeadline) {
                this.totalTimeout();
                return;
            }
            if (this.usingSocketTimeout && this.eventReceived) {
                this.eventReceived = false;
                long deadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
                if (deadline >= this.totalDeadline) {
                    deadline = this.totalDeadline;
                    this.usingSocketTimeout = false;
                }
                this.eventLoop.timer.restoreTimeout(this.timeoutTask, deadline);
                return;
            }
        } else if (this.eventReceived) {
            this.eventReceived = false;
            long socketDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
            this.eventLoop.timer.restoreTimeout(this.timeoutTask, socketDeadline);
            return;
        }
        if (this.iteration > this.command.policy.maxRetries) {
            this.totalTimeout();
            return;
        }
        this.recoverConnection();
        long timeout = TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
        if (this.hasTotalTimeout) {
            long remaining = this.totalDeadline - currentTime;
            if (remaining <= timeout) {
                timeout = remaining;
                this.usingSocketTimeout = false;
            }
        } else {
            currentTime = System.nanoTime();
        }
        long deadline = currentTime + timeout;
        if (!this.command.prepareRetry(true) && this.command.retryBatch(this, deadline)) {
            this.timeoutTask = null;
            this.close();
            return;
        }
        this.eventLoop.timer.restoreTimeout(this.timeoutTask, deadline);
        this.executeCommand();
    }

    private final void totalTimeout() {
        AerospikeException.Timeout ae = new AerospikeException.Timeout(this.command.policy, true);
        if (this.state == 2) {
            this.closeFromDelayQueue();
            this.notifyFailure(ae);
            return;
        }
        this.recoverConnection();
        this.timeoutTask = null;
        this.close();
        this.notifyFailure(ae);
        this.eventLoop.tryDelayQueue();
    }

    private final void recoverConnection() {
        if (this.command.policy.timeoutDelay > 0 && (this.state == 8 || this.state == 9 || this.state == 5 || this.state == 6)) {
            new NettyRecover(this);
            this.command.dataBuffer = null;
        } else {
            this.closeConnection();
        }
    }

    protected final void finish() {
        this.complete();
        try {
            this.command.onSuccess();
        }
        catch (Exception e) {
            Log.error("onSuccess() error: " + Util.getErrorMessage(e));
        }
        this.eventLoop.tryDelayQueue();
    }

    protected final void onNetworkError(AerospikeException ae) {
        if (this.state == 10) {
            return;
        }
        this.closeConnection();
        this.retry(ae, true);
    }

    protected final void onServerTimeout() {
        if (this.state == 10) {
            return;
        }
        this.putConnection();
        AerospikeException.Timeout ae = new AerospikeException.Timeout(this.command.policy, false);
        this.retry((AerospikeException)ae, false);
    }

    private final void retry(final AerospikeException ae, boolean queueCommand) {
        if (this.iteration > this.command.policy.maxRetries) {
            this.close();
            this.notifyFailure(ae);
            this.eventLoop.tryDelayQueue();
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout && (currentTime = System.nanoTime()) >= this.totalDeadline) {
            this.close();
            this.notifyFailure(ae);
            this.eventLoop.tryDelayQueue();
            return;
        }
        long deadline = this.totalDeadline;
        if (this.usingSocketTimeout) {
            this.timeoutTask.cancel();
            long timeout = TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
            if (this.hasTotalTimeout) {
                long remaining = this.totalDeadline - currentTime;
                if (remaining <= timeout) {
                    timeout = remaining;
                    this.usingSocketTimeout = false;
                }
            } else {
                currentTime = System.nanoTime();
            }
            deadline = currentTime + timeout;
        }
        if (queueCommand) {
            final long d = deadline;
            this.eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    if (NettyCommand.this.state == 10) {
                        return;
                    }
                    NettyCommand.this.retry(ae, d);
                }
            });
        } else {
            this.retry(ae, deadline);
        }
    }

    private final void retry(AerospikeException ae, long deadline) {
        if (!this.command.prepareRetry(ae.getResultCode() != -8) && this.command.retryBatch(this, deadline)) {
            this.close();
            return;
        }
        if (this.usingSocketTimeout) {
            this.eventLoop.timer.restoreTimeout(this.timeoutTask, deadline);
        }
        this.executeCommand();
    }

    protected final void onApplicationError(AerospikeException ae) {
        if (this.state == 10) {
            return;
        }
        if (ae.keepConnection()) {
            this.complete();
        } else {
            this.fail();
        }
        this.notifyFailure(ae);
        this.eventLoop.tryDelayQueue();
    }

    private final void notifyFailure(AerospikeException ae) {
        try {
            ae.setNode(this.node);
            ae.setPolicy(this.command.policy);
            ae.setIteration(this.iteration);
            ae.setInDoubt(this.command.isRead, this.commandSentCounter);
            if (Log.debugEnabled()) {
                Command.LogPolicy(this.command.policy);
            }
            this.command.onFailure(ae);
        }
        catch (Exception e) {
            Log.error("onFailure() error: " + Util.getErrorMessage(e));
        }
    }

    private final void complete() {
        this.putConnection();
        this.close();
    }

    private final void putConnection() {
        this.conn.channel.config().setAutoRead(false);
        InboundHandler handler = (InboundHandler)this.conn.channel.pipeline().last();
        handler.command = null;
        this.conn.updateLastUsed();
        this.node.putAsyncConnection(this.conn, this.eventState.index);
    }

    private final void fail() {
        this.closeConnection();
        this.close();
    }

    private final void closeConnection() {
        if (this.conn != null) {
            this.node.closeAsyncConnection(this.conn, this.eventState.index);
            this.conn = null;
        } else if (this.connectInProgress) {
            this.node.decrAsyncConnection(this.eventState.index);
            this.connectInProgress = false;
        }
    }

    private final void closeFromDelayQueue() {
        this.command.putBuffer();
        this.state = 10;
        --this.eventState.pending;
    }

    private final void close() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.command.putBuffer();
        this.state = 10;
        --this.eventState.pending;
        --this.eventLoop.pending;
    }

    static class InboundHandler
    extends ChannelInboundHandlerAdapter {
        NettyCommand command;

        InboundHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.command.channelActive();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.command.read((ByteBuf)msg);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (!(evt instanceof SslHandshakeCompletionEvent)) {
                return;
            }
            Throwable cause = ((SslHandshakeCompletionEvent)evt).cause();
            if (cause != null) {
                throw new AerospikeException("TLS connect failed: " + cause.getMessage(), cause);
            }
            TlsPolicy tlsPolicy = this.command.eventLoop.parent.tlsPolicy;
            String tlsName = this.command.node.getHost().tlsName;
            SSLSession session = ((SslHandler)ctx.pipeline().first()).engine().getSession();
            X509Certificate cert = (X509Certificate)session.getPeerCertificates()[0];
            Connection.validateServerCertificate(tlsPolicy, tlsName, cert);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (cause instanceof AerospikeException.Connection) {
                this.command.onNetworkError((AerospikeException.Connection)cause);
            } else if (cause instanceof AerospikeException) {
                AerospikeException ae = (AerospikeException)cause;
                if (ae.getResultCode() == 9) {
                    this.command.onServerTimeout();
                } else {
                    this.command.onApplicationError(ae);
                }
            } else if (cause instanceof IOException) {
                this.command.onNetworkError(new AerospikeException(cause));
            } else {
                this.command.onApplicationError(new AerospikeException(cause));
            }
        }
    }
}

