/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;

public final class ConnectionRecover {
    private final Connection conn;
    private final Node node;
    private byte[] headerBuf;
    private int timeoutDelay;
    private int offset;
    private int length;
    private final boolean isSingle;
    private final boolean checkReturnCode;
    private boolean lastGroup;
    private byte state;

    public ConnectionRecover(Connection conn, Node node, int timeoutDelay, Connection.ReadTimeout crt) {
        this.conn = conn;
        this.node = node;
        this.timeoutDelay = timeoutDelay;
        this.offset = crt.offset;
        switch (crt.state) {
            case 1: {
                this.length = 10;
                this.isSingle = true;
                this.checkReturnCode = true;
                this.state = (byte)2;
                if (this.offset >= this.length) {
                    if (crt.buffer[this.length - 1] != 0) {
                        this.abort();
                        return;
                    }
                    this.length = this.getSize(crt.buffer) - (this.offset - 8);
                    this.offset = 0;
                    this.state = (byte)3;
                    break;
                }
                if (this.offset <= 0) break;
                this.copyHeaderBuf(crt.buffer);
                break;
            }
            case 2: {
                this.length = crt.isSingle ? 8 : 12;
                this.isSingle = crt.isSingle;
                this.checkReturnCode = false;
                this.state = crt.state;
                if (this.offset >= this.length) {
                    if (!this.isSingle) {
                        this.checkLastGroup(crt.buffer);
                    }
                    this.length = this.getSize(crt.buffer) - (this.offset - 8);
                    this.offset = 0;
                    this.state = (byte)3;
                    break;
                }
                if (this.offset <= 0) break;
                this.copyHeaderBuf(crt.buffer);
                break;
            }
            default: {
                this.length = crt.length;
                this.isSingle = crt.isSingle;
                this.checkReturnCode = false;
                this.state = crt.state;
            }
        }
        conn.updateLastUsed();
        try {
            conn.setTimeout(1);
        }
        catch (Exception e) {
            this.abort();
        }
    }

    public boolean drain(byte[] buf) {
        try {
            if (this.isSingle) {
                if (this.state == 2) {
                    this.drainHeader(buf);
                }
                this.drainDetail(buf);
                this.recover();
                return true;
            }
            while (true) {
                if (this.state == 2) {
                    this.drainHeader(buf);
                }
                this.drainDetail(buf);
                if (this.lastGroup) break;
                this.length = 12;
                this.offset = 0;
                this.state = (byte)2;
            }
            this.recover();
            return true;
        }
        catch (SocketTimeoutException ste) {
            if (System.nanoTime() - this.conn.getLastUsed() >= TimeUnit.MILLISECONDS.toNanos(this.timeoutDelay)) {
                this.abort();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.abort();
            return true;
        }
    }

    public boolean isComplete() {
        return this.state == 4;
    }

    public void abort() {
        this.node.closeConnection(this.conn);
        this.state = (byte)4;
    }

    private void recover() {
        this.node.putConnection(this.conn);
        this.state = (byte)4;
    }

    private void drainHeader(byte[] buf) throws IOException {
        byte[] b;
        byte[] byArray = b = this.offset == 0 ? buf : this.headerBuf;
        while (true) {
            int count;
            if ((count = this.conn.read(b, this.offset, this.length - this.offset)) < 0) {
                throw new EOFException();
            }
            this.offset += count;
            if (this.offset >= this.length) break;
            if (b != buf) continue;
            this.copyHeaderBuf(b);
            b = this.headerBuf;
        }
        if (this.checkReturnCode) {
            if (b[this.length - 1] != 0) {
                this.abort();
                return;
            }
        } else if (!this.isSingle) {
            this.checkLastGroup(b);
        }
        this.length = this.getSize(b) - (this.length - 8);
        this.offset = 0;
        this.state = (byte)3;
    }

    private void drainDetail(byte[] buf) throws IOException {
        while (this.offset < this.length) {
            int rem = this.length - this.offset;
            int len = rem <= buf.length ? rem : buf.length;
            int count = this.conn.read(buf, 0, len);
            if (count < 0) {
                throw new EOFException();
            }
            this.offset += count;
        }
    }

    private void copyHeaderBuf(byte[] buf) {
        if (this.headerBuf == null) {
            this.headerBuf = new byte[this.length];
        }
        for (int i = 0; i < this.offset; ++i) {
            this.headerBuf[i] = buf[i];
        }
    }

    private int getSize(byte[] buf) {
        long sz = Buffer.bytesToLong(buf, 0);
        return (int)(sz & 0xFFFFFFFFFFFFL);
    }

    private void checkLastGroup(byte[] buf) {
        byte info3 = buf[this.length - 1];
        if ((info3 & 1) == 1) {
            this.lastGroup = true;
        }
    }
}

