/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.util.Unpacker;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;

public final class Buffer {
    public static Value bytesToKeyValue(int type, byte[] buf, int offset, int len) throws AerospikeException {
        switch (type) {
            case 3: {
                return Value.get(Buffer.utf8ToString(buf, offset, len));
            }
            case 1: {
                return Buffer.bytesToLongValue(buf, offset, len);
            }
            case 2: {
                return new Value.DoubleValue(Buffer.bytesToDouble(buf, offset));
            }
            case 4: {
                return Value.get(Arrays.copyOfRange(buf, offset, offset + len));
            }
        }
        return null;
    }

    public static Object bytesToParticle(int type, byte[] buf, int offset, int len) throws AerospikeException {
        switch (type) {
            case 3: {
                return Buffer.utf8ToString(buf, offset, len);
            }
            case 1: {
                return Buffer.bytesToNumber(buf, offset, len);
            }
            case 2: {
                return Buffer.bytesToDouble(buf, offset);
            }
            case 4: {
                return Arrays.copyOfRange(buf, offset, offset + len);
            }
            case 7: {
                return Buffer.bytesToObject(buf, offset, len);
            }
            case 23: {
                return Buffer.bytesToGeoJSON(buf, offset, len);
            }
            case 20: {
                return Unpacker.unpackObjectList(buf, offset, len);
            }
            case 19: {
                return Unpacker.unpackObjectMap(buf, offset, len);
            }
        }
        return null;
    }

    public static int estimateSizeUtf8(String value) {
        if (value == null) {
            return 0;
        }
        int max = value.length();
        int count = 0;
        for (int i = 0; i < max; ++i) {
            char ch = value.charAt(i);
            if (ch < '\u0080') {
                ++count;
                continue;
            }
            if (ch < '\u0800') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return count;
    }

    public static byte[] stringToUtf8(String s) {
        if (s == null || s.length() == 0) {
            return new byte[0];
        }
        int size = Buffer.estimateSizeUtf8(s);
        byte[] bytes = new byte[size];
        Buffer.stringToUtf8(s, bytes, 0);
        return bytes;
    }

    public static int stringToUtf8(String s, byte[] buf, int offset) {
        if (s == null) {
            return 0;
        }
        int length = s.length();
        int startOffset = offset;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                buf[offset++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                buf[offset++] = (byte)(0xC0 | c >> 6);
                buf[offset++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            try {
                byte[] value = s.getBytes("UTF8");
                System.arraycopy(value, 0, buf, startOffset, value.length);
                return value.length;
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("UTF8 encoding is not supported.");
            }
        }
        return offset - startOffset;
    }

    public static String utf8ToString(byte[] buf, int offset, int length) {
        if (length == 0) {
            return "";
        }
        char[] charBuffer = new char[length];
        int charCount = 0;
        int limit = offset + length;
        int origoffset = offset;
        while (offset < limit) {
            byte b1 = buf[offset];
            if (b1 >= 0) {
                charBuffer[charCount++] = (char)b1;
                ++offset;
                continue;
            }
            if (b1 >> 5 == -2) {
                byte b2 = buf[offset + 1];
                charBuffer[charCount++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                offset += 2;
                continue;
            }
            try {
                return new String(buf, origoffset, length, "UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("UTF8 decoding is not supported.");
            }
        }
        return new String(charBuffer, 0, charCount);
    }

    public static String utf8ToString(byte[] buf, int offset, int length, StringBuilder sb) {
        if (length == 0) {
            return "";
        }
        sb.setLength(0);
        int limit = offset + length;
        int origoffset = offset;
        while (offset < limit) {
            char c;
            if ((buf[offset] & 0x80) == 0) {
                c = (char)buf[offset];
                sb.append(c);
                ++offset;
                continue;
            }
            if ((buf[offset] & 0xE0) == 192) {
                c = (char)((buf[offset] & 0x1F) << 6 | buf[offset + 1] & 0x3F);
                sb.append(c);
                offset += 2;
                continue;
            }
            try {
                return new String(buf, origoffset, length, "UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("UTF8 decoding is not supported.");
            }
        }
        return sb.toString();
    }

    public static int utf8DigitsToInt(byte[] buf, int begin, int end) {
        int val = 0;
        int mult = 1;
        for (int i = end - 1; i >= begin; --i) {
            val += (buf[i] - 48) * mult;
            mult *= 10;
        }
        return val;
    }

    public static String bytesToHexString(byte[] buf) {
        if (buf == null || buf.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            sb.append(String.format("%02x", buf[i]));
        }
        return sb.toString();
    }

    public static String bytesToHexString(byte[] buf, int offset, int length) {
        StringBuilder sb = new StringBuilder(length * 2);
        for (int i = offset; i < length; ++i) {
            sb.append(String.format("%02x", buf[i]));
        }
        return sb.toString();
    }

    public static Object bytesToObject(byte[] buf, int offset, int length) throws AerospikeException.Serialize {
        if (length <= 0) {
            return null;
        }
        try {
            ByteArrayInputStream bastream = new ByteArrayInputStream(buf, offset, length);
            ObjectInputStream oistream = new ObjectInputStream(bastream);
            return oistream.readObject();
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public static Value bytesToLongValue(byte[] buf, int offset, int len) {
        long val = 0L;
        for (int i = 0; i < len; ++i) {
            val <<= 8;
            val |= (long)(buf[offset + i] & 0xFF);
        }
        return new Value.LongValue(val);
    }

    public static Object bytesToGeoJSON(byte[] buf, int offset, int len) {
        int ncells = Buffer.bytesToShort(buf, offset + 1);
        int hdrsz = 3 + ncells * 8;
        return Value.getAsGeoJSON(Buffer.utf8ToString(buf, offset + hdrsz, len - hdrsz));
    }

    public static Object bytesToNumber(byte[] buf, int offset, int len) {
        if (len == 8) {
            return Buffer.bytesToLong(buf, offset);
        }
        if (len == 0) {
            return new Long(0L);
        }
        if (len == 4) {
            return new Long(Buffer.bytesToInt(buf, offset));
        }
        if (len > 8) {
            return Buffer.bytesToBigInteger(buf, offset, len);
        }
        long val = 0L;
        for (int i = 0; i < len; ++i) {
            val <<= 8;
            val |= (long)(buf[offset + i] & 0xFF);
        }
        return new Long(val);
    }

    public static Object bytesToBigInteger(byte[] buf, int offset, int len) {
        boolean negative = false;
        if ((buf[offset] & 0x80) != 0) {
            negative = true;
            int n = offset;
            buf[n] = (byte)(buf[n] & 0x7F);
        }
        byte[] bytes = new byte[len];
        System.arraycopy(buf, offset, bytes, 0, len);
        BigInteger big = new BigInteger(bytes);
        if (negative) {
            big = big.negate();
        }
        return big;
    }

    public static double bytesToDouble(byte[] buf, int offset) {
        return Double.longBitsToDouble(Buffer.bytesToLong(buf, offset));
    }

    public static void doubleToBytes(double v, byte[] buf, int offset) {
        Buffer.longToBytes(Double.doubleToLongBits(v), buf, offset);
    }

    public static void longToBytes(long v, byte[] buf, int offset) {
        buf[offset++] = (byte)(v >>> 56);
        buf[offset++] = (byte)(v >>> 48);
        buf[offset++] = (byte)(v >>> 40);
        buf[offset++] = (byte)(v >>> 32);
        buf[offset++] = (byte)(v >>> 24);
        buf[offset++] = (byte)(v >>> 16);
        buf[offset++] = (byte)(v >>> 8);
        buf[offset] = (byte)(v >>> 0);
    }

    public static void longToLittleBytes(long v, byte[] buf, int offset) {
        buf[offset++] = (byte)(v >>> 0);
        buf[offset++] = (byte)(v >>> 8);
        buf[offset++] = (byte)(v >>> 16);
        buf[offset++] = (byte)(v >>> 24);
        buf[offset++] = (byte)(v >>> 32);
        buf[offset++] = (byte)(v >>> 40);
        buf[offset++] = (byte)(v >>> 48);
        buf[offset] = (byte)(v >>> 56);
    }

    public static long bytesToLong(byte[] buf, int offset) {
        return (long)(buf[offset] & 0xFF) << 56 | (long)(buf[offset + 1] & 0xFF) << 48 | (long)(buf[offset + 2] & 0xFF) << 40 | (long)(buf[offset + 3] & 0xFF) << 32 | (long)(buf[offset + 4] & 0xFF) << 24 | (long)(buf[offset + 5] & 0xFF) << 16 | (long)(buf[offset + 6] & 0xFF) << 8 | (long)(buf[offset + 7] & 0xFF) << 0;
    }

    public static long littleBytesToLong(byte[] buf, int offset) {
        return (long)(buf[offset] & 0xFF) << 0 | (long)(buf[offset + 1] & 0xFF) << 8 | (long)(buf[offset + 2] & 0xFF) << 16 | (long)(buf[offset + 3] & 0xFF) << 24 | (long)(buf[offset + 4] & 0xFF) << 32 | (long)(buf[offset + 5] & 0xFF) << 40 | (long)(buf[offset + 6] & 0xFF) << 48 | (long)(buf[offset + 7] & 0xFF) << 56;
    }

    public static void intToBytes(int v, byte[] buf, int offset) {
        buf[offset++] = (byte)(v >>> 24);
        buf[offset++] = (byte)(v >>> 16);
        buf[offset++] = (byte)(v >>> 8);
        buf[offset] = (byte)(v >>> 0);
    }

    public static void intToLittleBytes(int v, byte[] buf, int offset) {
        buf[offset++] = (byte)(v >>> 0);
        buf[offset++] = (byte)(v >>> 8);
        buf[offset++] = (byte)(v >>> 16);
        buf[offset] = (byte)(v >>> 24);
    }

    public static int bytesToInt(byte[] buf, int offset) {
        return (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | (buf[offset + 3] & 0xFF) << 0;
    }

    public static int littleBytesToInt(byte[] buf, int offset) {
        return (buf[offset] & 0xFF) << 0 | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | (buf[offset + 3] & 0xFF) << 24;
    }

    public static long bigUnsigned32ToLong(byte[] buf, int offset) {
        return (long)(buf[offset] & 0xFF) << 24 | (long)(buf[offset + 1] & 0xFF) << 16 | (long)(buf[offset + 2] & 0xFF) << 8 | (long)(buf[offset + 3] & 0xFF) << 0;
    }

    public static void shortToBytes(int v, byte[] buf, int offset) {
        buf[offset++] = (byte)(v >>> 8);
        buf[offset] = (byte)(v >>> 0);
    }

    public static void shortToLittleBytes(int v, byte[] buf, int offset) {
        buf[offset++] = (byte)(v >>> 0);
        buf[offset] = (byte)(v >>> 8);
    }

    public static int bytesToShort(byte[] buf, int offset) {
        return (buf[offset] & 0xFF) << 8 | (buf[offset + 1] & 0xFF) << 0;
    }

    public static int littleBytesToShort(byte[] buf, int offset) {
        return (buf[offset] & 0xFF) << 0 | (buf[offset + 1] & 0xFF) << 8;
    }

    public static short bigSigned16ToShort(byte[] buf, int offset) {
        return (short)((buf[offset] & 0xFF) << 8 | (buf[offset + 1] & 0xFF) << 0);
    }

    public static int intToVarBytes(int v, byte[] buf, int offset) {
        int i = offset;
        while (i < buf.length && v >= 128) {
            buf[i++] = (byte)(v | 0x80);
            v >>>= 7;
        }
        if (i < buf.length) {
            buf[i++] = (byte)v;
            return i - offset;
        }
        return 0;
    }

    public static int[] varBytesToInt(byte[] buf, int offset) {
        byte b;
        int i = offset;
        int val = 0;
        int shift = 0;
        do {
            b = buf[i++];
            val |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return new int[]{val, i - offset};
    }
}

