/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.query.QueryValidate;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;

public abstract class MultiCommand
extends SyncCommand {
    private static final int MAX_BUFFER_SIZE = 0xA00000;
    private BufferedInputStream bis;
    private final Node node;
    protected final String namespace;
    private final long clusterKey;
    private int receiveSize;
    protected int resultCode;
    protected int generation;
    protected int expiration;
    protected int batchIndex;
    protected int fieldCount;
    protected int opCount;
    private final boolean stopOnNotFound;
    private final boolean first;
    private byte state;
    protected volatile boolean valid = true;

    protected MultiCommand(Node node, boolean stopOnNotFound) {
        this.node = node;
        this.stopOnNotFound = stopOnNotFound;
        this.namespace = null;
        this.clusterKey = 0L;
        this.first = false;
    }

    protected MultiCommand(Node node, String namespace, long clusterKey, boolean first) {
        this.node = node;
        this.stopOnNotFound = true;
        this.namespace = namespace;
        this.clusterKey = clusterKey;
        this.first = first;
    }

    public final void execute(Cluster cluster, Policy policy) {
        if (this.clusterKey != 0L) {
            if (!this.first) {
                QueryValidate.validate(this.node, this.namespace, this.clusterKey);
            }
            super.execute(cluster, policy, true);
            QueryValidate.validate(this.node, this.namespace, this.clusterKey);
        } else {
            super.execute(cluster, policy, true);
        }
    }

    @Override
    protected Node getNode(Cluster cluster) {
        return this.node;
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        return true;
    }

    @Override
    protected final void parseResult(Connection conn) throws IOException {
        this.bis = new BufferedInputStream(conn.getInputStream());
        boolean status = true;
        while (status) {
            this.state = (byte)2;
            this.dataOffset = 0;
            this.readBytes(8);
            long size = Buffer.bytesToLong(this.dataBuffer, 0);
            this.receiveSize = (int)(size & 0xFFFFFFFFFFFFL);
            if (this.receiveSize <= 0) continue;
            status = this.parseGroup();
        }
    }

    private final boolean parseGroup() throws IOException {
        this.state = (byte)3;
        this.dataOffset = 0;
        while (this.dataOffset < this.receiveSize) {
            byte info3;
            this.readBytes(22);
            this.resultCode = this.dataBuffer[5] & 0xFF;
            if (this.resultCode != 0) {
                if (this.resultCode == 2 || this.resultCode == 27) {
                    if (this.stopOnNotFound) {
                        return false;
                    }
                } else {
                    throw new AerospikeException(this.resultCode);
                }
            }
            if (((info3 = this.dataBuffer[3]) & 1) == 1) {
                return false;
            }
            this.generation = Buffer.bytesToInt(this.dataBuffer, 6);
            this.expiration = Buffer.bytesToInt(this.dataBuffer, 10);
            this.batchIndex = Buffer.bytesToInt(this.dataBuffer, 14);
            this.fieldCount = Buffer.bytesToShort(this.dataBuffer, 18);
            this.opCount = Buffer.bytesToShort(this.dataBuffer, 20);
            Key key = this.parseKey(this.fieldCount);
            this.parseRow(key);
        }
        return true;
    }

    protected final Key parseKey(int fieldCount) throws AerospikeException, IOException {
        byte[] digest = null;
        String namespace = null;
        String setName = null;
        Value userKey = null;
        block6: for (int i = 0; i < fieldCount; ++i) {
            this.readBytes(4);
            int fieldlen = Buffer.bytesToInt(this.dataBuffer, 0);
            this.readBytes(fieldlen);
            byte fieldtype = this.dataBuffer[0];
            int size = fieldlen - 1;
            switch (fieldtype) {
                case 4: {
                    digest = new byte[size];
                    System.arraycopy(this.dataBuffer, 1, digest, 0, size);
                    continue block6;
                }
                case 0: {
                    namespace = Buffer.utf8ToString(this.dataBuffer, 1, size);
                    continue block6;
                }
                case 1: {
                    setName = Buffer.utf8ToString(this.dataBuffer, 1, size);
                    continue block6;
                }
                case 2: {
                    userKey = Buffer.bytesToKeyValue(this.dataBuffer[1], this.dataBuffer, 2, size - 1);
                }
            }
        }
        return new Key(namespace, digest, setName, userKey);
    }

    protected final Record parseRecord() throws AerospikeException, IOException {
        HashMap<String, Object> bins = null;
        for (int i = 0; i < this.opCount; ++i) {
            this.readBytes(8);
            int opSize = Buffer.bytesToInt(this.dataBuffer, 0);
            byte particleType = this.dataBuffer[5];
            byte nameSize = this.dataBuffer[7];
            this.readBytes(nameSize);
            String name = Buffer.utf8ToString(this.dataBuffer, 0, nameSize);
            int particleBytesSize = opSize - (4 + nameSize);
            this.readBytes(particleBytesSize);
            Object value = Buffer.bytesToParticle(particleType, this.dataBuffer, 0, particleBytesSize);
            if (bins == null) {
                bins = new HashMap<String, Object>();
            }
            bins.put(name, value);
        }
        return new Record(bins, this.generation, this.expiration);
    }

    protected final void readBytes(int length) throws IOException {
        if (length > this.dataBuffer.length) {
            if (length > 0xA00000) {
                throw new IllegalArgumentException("Invalid readBytes length: " + length);
            }
            this.dataBuffer = new byte[length];
        }
        int pos = 0;
        while (pos < length) {
            int count;
            try {
                count = this.bis.read(this.dataBuffer, pos, length - pos);
            }
            catch (SocketTimeoutException ste) {
                if (this.state == 3 && this.dataOffset < 4) {
                    for (int i = 0; i < this.dataOffset; ++i) {
                        this.dataBuffer[8 + i] = this.dataBuffer[i];
                    }
                    this.dataOffset += 8;
                    long size = (long)this.receiveSize | 0x200000000000000L | 0x3000000000000L;
                    Buffer.longToBytes(size, this.dataBuffer, 0);
                    this.state = (byte)2;
                }
                throw new Connection.ReadTimeout(this.dataBuffer, this.dataOffset, this.receiveSize, this.state, false);
            }
            if (count < 0) {
                throw new EOFException();
            }
            pos += count;
            this.dataOffset += count;
        }
    }

    public void stop() {
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    protected abstract void parseRow(Key var1) throws IOException;
}

