/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.policy.Policy;
import java.io.IOException;

public class ReadHeaderCommand
extends SyncCommand {
    private final Policy policy;
    private final Key key;
    private final Partition partition;
    private Record record;

    public ReadHeaderCommand(Cluster cluster, Policy policy, Key key) {
        this.policy = policy;
        this.key = key;
        this.partition = Partition.read(cluster, policy, key);
    }

    @Override
    protected Node getNode(Cluster cluster) {
        return this.partition.getNodeRead(cluster);
    }

    @Override
    protected void writeBuffer() {
        this.setReadHeader(this.policy, this.key);
    }

    @Override
    protected void parseResult(Connection conn) throws IOException {
        conn.readFully(this.dataBuffer, 30, (byte)2);
        int resultCode = this.dataBuffer[13] & 0xFF;
        if (resultCode == 0) {
            int generation = Buffer.bytesToInt(this.dataBuffer, 14);
            int expiration = Buffer.bytesToInt(this.dataBuffer, 18);
            this.record = new Record(null, generation, expiration);
            return;
        }
        if (resultCode == 2) {
            return;
        }
        if (resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            return;
        }
        throw new AerospikeException(resultCode);
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryRead(timeout);
        return true;
    }

    public Record getRecord() {
        return this.record;
    }
}

