/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.ConnectionRecover;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.Command;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.ThreadLocalData;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;

public abstract class SyncCommand
extends Command {
    public final void execute(Cluster cluster, Policy policy, boolean isRead) {
        long deadline = 0L;
        int socketTimeout = policy.socketTimeout;
        int totalTimeout = policy.totalTimeout;
        if (totalTimeout > 0) {
            deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(totalTimeout);
            if (socketTimeout == 0 || socketTimeout > totalTimeout) {
                socketTimeout = totalTimeout;
            }
        }
        this.execute(cluster, policy, isRead, socketTimeout, totalTimeout, deadline, 1, 0);
    }

    public final void execute(Cluster cluster, Policy policy, boolean isRead, int socketTimeout, int totalTimeout, long deadline, int iteration, int commandSentCounter) {
        Node node;
        boolean isClientTimeout;
        AerospikeException exception;
        block26: {
            exception = null;
            do {
                block25: {
                    try {
                        node = this.getNode(cluster);
                    }
                    catch (AerospikeException ae) {
                        if (cluster.isActive()) {
                            ae.setPolicy(policy);
                            ae.setIteration(iteration);
                            ae.setInDoubt(isRead, commandSentCounter);
                            throw ae;
                        }
                        throw new AerospikeException("Cluster has been closed");
                    }
                    try {
                        Connection conn = node.getConnection(socketTimeout, policy.timeoutDelay);
                        try {
                            this.writeBuffer();
                            if (totalTimeout != policy.totalTimeout) {
                                Buffer.intToBytes(totalTimeout, this.dataBuffer, 22);
                            }
                            conn.write(this.dataBuffer, this.dataOffset);
                            ++commandSentCounter;
                            this.parseResult(conn);
                            node.putConnection(conn);
                            return;
                        }
                        catch (AerospikeException ae) {
                            if (ae.keepConnection()) {
                                node.putConnection(conn);
                            } else {
                                node.closeConnection(conn);
                            }
                            if (ae.getResultCode() == 9) {
                                exception = new AerospikeException.Timeout(policy, false);
                                isClientTimeout = false;
                                break block25;
                            }
                            throw ae;
                        }
                        catch (Connection.ReadTimeout crt) {
                            if (policy.timeoutDelay > 0) {
                                cluster.recoverConnection(new ConnectionRecover(conn, node, policy.timeoutDelay, crt));
                            } else {
                                node.closeConnection(conn);
                            }
                            isClientTimeout = true;
                        }
                        catch (RuntimeException re) {
                            node.closeConnection(conn);
                            throw re;
                        }
                        catch (SocketTimeoutException ste) {
                            node.closeConnection(conn);
                            isClientTimeout = true;
                        }
                        catch (IOException ioe) {
                            node.closeConnection(conn);
                            exception = new AerospikeException.Connection(ioe);
                            isClientTimeout = false;
                        }
                    }
                    catch (Connection.ReadTimeout crt) {
                        isClientTimeout = true;
                    }
                    catch (AerospikeException.Connection ce) {
                        exception = ce;
                        isClientTimeout = false;
                    }
                    catch (AerospikeException ae) {
                        ae.setNode(node);
                        ae.setPolicy(policy);
                        ae.setIteration(iteration);
                        ae.setInDoubt(isRead, commandSentCounter);
                        if (Log.debugEnabled()) {
                            SyncCommand.LogPolicy(policy);
                        }
                        throw ae;
                    }
                }
                if (iteration > policy.maxRetries) break block26;
                if (policy.totalTimeout > 0) {
                    long remaining = deadline - System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(policy.sleepBetweenRetries);
                    if (remaining <= 0L) break block26;
                    if ((remaining = TimeUnit.NANOSECONDS.toMillis(remaining)) < (long)totalTimeout && socketTimeout > (totalTimeout = (int)remaining)) {
                        socketTimeout = totalTimeout;
                    }
                }
                if (isClientTimeout || policy.sleepBetweenRetries <= 0) continue;
                Util.sleep(policy.sleepBetweenRetries);
            } while (this.prepareRetry(isClientTimeout || exception.getResultCode() != -8) || !this.retryBatch(cluster, socketTimeout, totalTimeout, deadline, ++iteration, commandSentCounter));
            return;
        }
        if (isClientTimeout) {
            exception = new AerospikeException.Timeout(policy, true);
        }
        exception.setNode(node);
        exception.setPolicy(policy);
        exception.setIteration(iteration);
        exception.setInDoubt(isRead, commandSentCounter);
        if (Log.debugEnabled()) {
            SyncCommand.LogPolicy(policy);
        }
        throw exception;
    }

    @Override
    protected final void sizeBuffer() {
        this.dataBuffer = ThreadLocalData.getBuffer();
        if (this.dataOffset > this.dataBuffer.length) {
            this.dataBuffer = ThreadLocalData.resizeBuffer(this.dataOffset);
        }
    }

    protected final void sizeBuffer(int size) {
        if (size > this.dataBuffer.length) {
            this.dataBuffer = ThreadLocalData.resizeBuffer(size);
        }
    }

    protected boolean retryBatch(Cluster cluster, int socketTimeout, int totalTimeout, long deadline, int iteration, int commandSentCounter) {
        return false;
    }

    protected abstract Node getNode(Cluster var1);

    protected abstract void writeBuffer();

    protected abstract void parseResult(Connection var1) throws AerospikeException, IOException;

    protected abstract boolean prepareRetry(boolean var1);
}

