/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.policy.WritePolicy;
import java.io.IOException;

public final class TouchCommand
extends SyncCommand {
    private final WritePolicy policy;
    private final Key key;
    private final Partition partition;

    public TouchCommand(Cluster cluster, WritePolicy policy, Key key) {
        this.policy = policy;
        this.key = key;
        this.partition = Partition.write(cluster, policy, key);
    }

    @Override
    protected Node getNode(Cluster cluster) {
        return this.partition.getNodeWrite(cluster);
    }

    @Override
    protected void writeBuffer() {
        this.setTouch(this.policy, this.key);
    }

    @Override
    protected void parseResult(Connection conn) throws IOException {
        conn.readFully(this.dataBuffer, 30, (byte)2);
        int resultCode = this.dataBuffer[13] & 0xFF;
        if (resultCode == 0) {
            return;
        }
        if (resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            return;
        }
        throw new AerospikeException(resultCode);
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryWrite(timeout);
        return true;
    }
}

