/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.policy;

import com.aerospike.client.policy.Priority;
import com.aerospike.client.policy.ReadModeAP;
import com.aerospike.client.policy.ReadModeSC;
import com.aerospike.client.policy.Replica;
import com.aerospike.client.query.PredExp;

public class Policy {
    public Priority priority = Priority.DEFAULT;
    public ReadModeAP readModeAP = ReadModeAP.ONE;
    public ReadModeSC readModeSC = ReadModeSC.SESSION;
    public Replica replica = Replica.SEQUENCE;
    public PredExp[] predExp;
    public int socketTimeout = 30000;
    public int totalTimeout;
    public int timeoutDelay;
    public int maxRetries = 2;
    public int sleepBetweenRetries;
    public boolean sendKey;
    public boolean failOnFilteredOut;

    public Policy(Policy other) {
        this.priority = other.priority;
        this.readModeAP = other.readModeAP;
        this.readModeSC = other.readModeSC;
        this.replica = other.replica;
        this.predExp = other.predExp;
        this.socketTimeout = other.socketTimeout;
        this.totalTimeout = other.totalTimeout;
        this.timeoutDelay = other.timeoutDelay;
        this.maxRetries = other.maxRetries;
        this.sleepBetweenRetries = other.sleepBetweenRetries;
        this.sendKey = other.sendKey;
        this.failOnFilteredOut = other.failOnFilteredOut;
    }

    public Policy() {
    }

    public final void setTimeout(int timeout) {
        this.socketTimeout = timeout;
        this.totalTimeout = timeout;
    }

    public final void setTimeouts(int socketTimeout, int totalTimeout) {
        this.socketTimeout = socketTimeout;
        this.totalTimeout = totalTimeout;
        if (totalTimeout > 0 && (socketTimeout == 0 || socketTimeout > totalTimeout)) {
            this.socketTimeout = totalTimeout;
        }
    }

    public final void setPredExp(PredExp ... predExp) {
        this.predExp = predExp;
    }
}

