/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.QueryExecutor;
import com.aerospike.client.query.QueryRecordCommand;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;

public final class QueryRecordExecutor
extends QueryExecutor {
    private final RecordSet recordSet;

    public QueryRecordExecutor(Cluster cluster, QueryPolicy policy, Statement statement, Node node) throws AerospikeException {
        super(cluster, policy, statement, node);
        this.recordSet = new RecordSet(this, policy.recordQueueSize);
        statement.prepare(true);
        this.initializeThreads();
    }

    public void execute() {
        this.startThreads();
    }

    @Override
    protected MultiCommand createCommand(Node node, long clusterKey, boolean first) {
        return new QueryRecordCommand(node, this.policy, this.statement, this.recordSet, clusterKey, first);
    }

    @Override
    protected void sendCancel() {
        this.recordSet.abort();
    }

    @Override
    protected void sendCompleted() {
        this.recordSet.put(RecordSet.END);
    }

    public RecordSet getRecordSet() {
        return this.recordSet;
    }
}

