/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.query.QueryValidate;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public abstract class MultiCommand
extends SyncCommand {
    private static final int MAX_BUFFER_SIZE = 0x8000000;
    private final Node node;
    protected final String namespace;
    private final long clusterKey;
    protected int info3;
    protected int resultCode;
    protected int generation;
    protected int expiration;
    protected int batchIndex;
    protected int fieldCount;
    protected int opCount;
    private final boolean stopOnNotFound;
    private final boolean first;
    protected volatile boolean valid = true;

    protected MultiCommand(Cluster cluster, Policy policy, Node node, boolean stopOnNotFound) {
        super(cluster, policy);
        this.node = node;
        this.stopOnNotFound = stopOnNotFound;
        this.namespace = null;
        this.clusterKey = 0L;
        this.first = false;
    }

    protected MultiCommand(Cluster cluster, Policy policy, Node node, String namespace, int socketTimeout, int totalTimeout) {
        super(cluster, policy, socketTimeout, totalTimeout);
        this.node = node;
        this.stopOnNotFound = true;
        this.namespace = namespace;
        this.clusterKey = 0L;
        this.first = false;
    }

    protected MultiCommand(Cluster cluster, Policy policy, Node node, String namespace, long clusterKey, boolean first) {
        super(cluster, policy, policy.socketTimeout, policy.totalTimeout);
        this.node = node;
        this.stopOnNotFound = true;
        this.namespace = namespace;
        this.clusterKey = clusterKey;
        this.first = first;
    }

    public void executeAndValidate() {
        if (this.clusterKey != 0L) {
            if (!this.first) {
                QueryValidate.validate(this.node, this.namespace, this.clusterKey);
            }
            super.execute();
            QueryValidate.validate(this.node, this.namespace, this.clusterKey);
        } else {
            super.execute();
        }
    }

    @Override
    protected boolean isSingle() {
        return false;
    }

    @Override
    protected Node getNode() {
        return this.node;
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        return true;
    }

    @Override
    protected final void parseResult(Connection conn) throws IOException {
        byte[] buf = null;
        byte[] ubuf = null;
        while (true) {
            int receiveSize;
            byte[] protoBuf = new byte[8];
            conn.readFully(protoBuf, 8, (byte)2);
            long proto = Buffer.bytesToLong(protoBuf, 0);
            int size = (int)(proto & 0xFFFFFFFFFFFFL);
            if (size <= 0) continue;
            if (buf == null || size > buf.length) {
                if (size > 0x8000000) {
                    throw new AerospikeException("Invalid proto size: " + size);
                }
                int capacity = size + 16383 & 0xFFFFC000;
                buf = new byte[capacity];
            }
            try {
                conn.readFully(buf, size, (byte)3);
                conn.updateLastUsed();
            }
            catch (Connection.ReadTimeout rt) {
                int i;
                if (rt.offset >= 4) {
                    throw rt;
                }
                byte[] b = new byte[12];
                int count = 0;
                for (i = 0; i < 8; ++i) {
                    b[count++] = protoBuf[i];
                }
                for (i = 0; i < rt.offset; ++i) {
                    b[count++] = buf[i];
                }
                throw new Connection.ReadTimeout(b, rt.offset + 8, count, 2);
            }
            long type = proto >> 48 & 0xFFL;
            if (type == 3L) {
                this.dataBuffer = buf;
                this.dataOffset = 0;
                receiveSize = size;
            } else if (type == 4L) {
                int rsize;
                int usize = (int)Buffer.bytesToLong(buf, 0);
                if (ubuf == null || usize > ubuf.length) {
                    if (usize > 0x8000000) {
                        throw new AerospikeException("Invalid proto size: " + usize);
                    }
                    int capacity = usize + 16383 & 0xFFFFC000;
                    ubuf = new byte[capacity];
                }
                Inflater inf = new Inflater();
                inf.setInput(buf, 8, size - 8);
                try {
                    rsize = inf.inflate(ubuf);
                }
                catch (DataFormatException dfe) {
                    throw new AerospikeException.Serialize(dfe);
                }
                if (rsize != usize) {
                    throw new AerospikeException("Decompressed size " + rsize + " is not expected " + usize);
                }
                this.dataBuffer = ubuf;
                this.dataOffset = 8;
                receiveSize = usize - 8;
            } else {
                throw new AerospikeException("Invalid proto type: " + type + " Expected: " + 3L);
            }
            if (!this.parseGroup(receiveSize)) break;
        }
    }

    private final boolean parseGroup(int receiveSize) throws IOException {
        while (this.dataOffset < receiveSize) {
            this.dataOffset += 3;
            this.info3 = this.dataBuffer[this.dataOffset] & 0xFF;
            this.dataOffset += 2;
            this.resultCode = this.dataBuffer[this.dataOffset] & 0xFF;
            if (this.resultCode != 0) {
                if (this.resultCode == 2 || this.resultCode == 27) {
                    if (this.stopOnNotFound) {
                        return false;
                    }
                } else {
                    throw new AerospikeException(this.resultCode);
                }
            }
            if ((this.info3 & 1) != 0) {
                return false;
            }
            ++this.dataOffset;
            this.generation = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.expiration = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.batchIndex = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.fieldCount = Buffer.bytesToShort(this.dataBuffer, this.dataOffset);
            this.dataOffset += 2;
            this.opCount = Buffer.bytesToShort(this.dataBuffer, this.dataOffset);
            this.dataOffset += 2;
            Key key = this.parseKey(this.fieldCount);
            this.parseRow(key);
        }
        return true;
    }

    protected final Record parseRecord() {
        if (this.opCount <= 0) {
            return new Record(null, this.generation, this.expiration);
        }
        LinkedHashMap<String, Object> bins = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.opCount; ++i) {
            int opSize = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            byte particleType = this.dataBuffer[this.dataOffset + 5];
            byte nameSize = this.dataBuffer[this.dataOffset + 7];
            String name = Buffer.utf8ToString(this.dataBuffer, this.dataOffset + 8, nameSize);
            this.dataOffset += 8 + nameSize;
            int particleBytesSize = opSize - (4 + nameSize);
            Object value = Buffer.bytesToParticle(particleType, this.dataBuffer, this.dataOffset, particleBytesSize);
            this.dataOffset += particleBytesSize;
            bins.put(name, value);
        }
        return new Record(bins, this.generation, this.expiration);
    }

    public void stop() {
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    protected abstract void parseRow(Key var1);
}

