/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.EventLoopStats;
import com.aerospike.client.async.EventLoops;
import com.aerospike.client.async.EventState;
import com.aerospike.client.cluster.ClusterStats;
import com.aerospike.client.cluster.ConnectionRecover;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.NodeStats;
import com.aerospike.client.cluster.NodeValidator;
import com.aerospike.client.cluster.Partitions;
import com.aerospike.client.cluster.Peers;
import com.aerospike.client.cluster.ThreadDaemonFactory;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.AuthMode;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.TlsPolicy;
import com.aerospike.client.util.ThreadLocalData;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class Cluster
implements Runnable,
Closeable {
    protected final String clusterName;
    private volatile Host[] seeds;
    protected final HashMap<Host, Node> aliases;
    protected final HashMap<String, Node> nodesMap;
    private volatile Node[] nodes;
    public volatile HashMap<String, Partitions> partitionMap;
    protected final Map<String, String> ipMap;
    protected final TlsPolicy tlsPolicy;
    public final AuthMode authMode;
    protected final byte[] user;
    private byte[] password;
    private byte[] passwordHash;
    private final AtomicInteger nodeIndex;
    final AtomicInteger replicaIndex;
    private final AtomicInteger recoverCount;
    private final ConcurrentLinkedDeque<ConnectionRecover> recoverQueue;
    private final ExecutorService threadPool;
    public final EventLoops eventLoops;
    public final EventState[] eventState;
    private final long maxSocketIdleNanosTran;
    private final long maxSocketIdleNanosTrim;
    protected final int minConnsPerNode;
    protected final int maxConnsPerNode;
    protected final int asyncMinConnsPerNode;
    protected final int asyncMaxConnsPerNode;
    protected final int connPoolsPerNode;
    int maxErrorRate;
    int errorRateWindow;
    public final int connectionTimeout;
    public final int loginTimeout;
    public final int rackId;
    private final int tendInterval;
    private int tendCount;
    private Thread tendThread;
    protected volatile boolean tendValid;
    private final boolean sharedThreadPool;
    protected final boolean useServicesAlternate;
    final boolean rackAware;
    private boolean asyncComplete;

    public Cluster(ClientPolicy policy, Host[] hosts) throws AerospikeException {
        int i;
        this.clusterName = policy.clusterName;
        this.tlsPolicy = policy.tlsPolicy;
        this.authMode = policy.authMode;
        if (this.tlsPolicy != null) {
            boolean useClusterName = this.clusterName != null && this.clusterName.length() > 0;
            for (i = 0; i < hosts.length; ++i) {
                Host host = hosts[i];
                if (host.tlsName != null) continue;
                String tlsName = useClusterName ? this.clusterName : host.name;
                hosts[i] = new Host(host.name, tlsName, host.port);
            }
        } else if (this.authMode == AuthMode.EXTERNAL) {
            throw new AerospikeException("TLS is required for authentication mode: " + (Object)((Object)this.authMode));
        }
        this.seeds = hosts;
        if (policy.user != null && policy.user.length() > 0) {
            String pass;
            this.user = Buffer.stringToUtf8(policy.user);
            if (this.authMode != AuthMode.INTERNAL) {
                this.password = Buffer.stringToUtf8(policy.password);
            }
            if ((pass = policy.password) == null) {
                pass = "";
            }
            if (pass.length() != 60 || !pass.startsWith("$2a$")) {
                pass = AdminCommand.hashPassword(pass);
            }
            this.passwordHash = Buffer.stringToUtf8(pass);
        } else {
            this.user = null;
        }
        if (policy.maxSocketIdle < 0) {
            throw new AerospikeException("Invalid maxSocketIdle: " + policy.maxSocketIdle);
        }
        if (policy.maxSocketIdle == 0) {
            this.maxSocketIdleNanosTran = 0L;
            this.maxSocketIdleNanosTrim = TimeUnit.SECONDS.toNanos(55L);
        } else {
            this.maxSocketIdleNanosTrim = this.maxSocketIdleNanosTran = TimeUnit.SECONDS.toNanos(policy.maxSocketIdle);
        }
        this.minConnsPerNode = policy.minConnsPerNode;
        this.maxConnsPerNode = policy.maxConnsPerNode;
        if (this.minConnsPerNode > this.maxConnsPerNode) {
            throw new AerospikeException("Invalid connection range: " + this.minConnsPerNode + " - " + this.maxConnsPerNode);
        }
        this.asyncMinConnsPerNode = policy.asyncMinConnsPerNode;
        int n = this.asyncMaxConnsPerNode = policy.asyncMaxConnsPerNode >= 0 ? policy.asyncMaxConnsPerNode : policy.maxConnsPerNode;
        if (this.asyncMinConnsPerNode > this.asyncMaxConnsPerNode) {
            throw new AerospikeException("Invalid async connection range: " + this.asyncMinConnsPerNode + " - " + this.asyncMaxConnsPerNode);
        }
        this.connPoolsPerNode = policy.connPoolsPerNode;
        this.maxErrorRate = policy.maxErrorRate;
        this.errorRateWindow = policy.errorRateWindow;
        this.connectionTimeout = policy.timeout;
        this.loginTimeout = policy.loginTimeout;
        this.tendInterval = policy.tendInterval;
        this.ipMap = policy.ipMap;
        this.threadPool = policy.threadPool == null ? Executors.newCachedThreadPool(new ThreadDaemonFactory()) : policy.threadPool;
        this.sharedThreadPool = policy.sharedThreadPool;
        this.useServicesAlternate = policy.useServicesAlternate;
        this.rackAware = policy.rackAware;
        this.rackId = policy.rackId;
        this.aliases = new HashMap();
        this.nodesMap = new HashMap();
        this.nodes = new Node[0];
        this.partitionMap = new HashMap();
        this.nodeIndex = new AtomicInteger();
        this.replicaIndex = new AtomicInteger();
        this.recoverCount = new AtomicInteger();
        this.recoverQueue = new ConcurrentLinkedDeque();
        this.eventLoops = policy.eventLoops;
        if (this.eventLoops != null) {
            EventLoop[] loops = this.eventLoops.getArray();
            this.eventState = new EventState[loops.length];
            for (i = 0; i < loops.length; ++i) {
                this.eventState[i] = loops[i].createState();
            }
            if (policy.tlsPolicy != null) {
                this.eventLoops.initTlsContext(policy.tlsPolicy);
            }
        } else {
            this.eventState = null;
        }
        if (policy.forceSingleNode) {
            try {
                this.forceSingleNode();
            }
            catch (RuntimeException e) {
                this.close();
                throw e;
            }
        } else {
            this.initTendThread(policy.failIfNotConnected);
        }
    }

    public void forceSingleNode() {
        this.tendValid = true;
        this.tendThread = new Thread(this);
        Host seed = this.seeds[0];
        NodeValidator nv = new NodeValidator();
        Node node = null;
        try {
            node = nv.seedNode(this, seed, null);
        }
        catch (Exception e) {
            throw new AerospikeException("Seed " + seed + " failed: " + e.getMessage(), (Throwable)e);
        }
        this.addNode(node);
        Peers peers = new Peers(this.nodes.length + 16, 16);
        node.refreshPartitions(peers);
        for (Partitions partitions : this.partitionMap.values()) {
            for (AtomicReferenceArray<Node> nodeArray : partitions.replicas) {
                int max = nodeArray.length();
                for (int i = 0; i < max; ++i) {
                    nodeArray.set(i, node);
                }
            }
        }
    }

    public void initTendThread(boolean failIfNotConnected) throws AerospikeException {
        this.waitTillStabilized(failIfNotConnected);
        if (Log.debugEnabled()) {
            for (Host host : this.seeds) {
                Log.debug("Add seed " + host);
            }
        }
        ArrayList<Host> seedsToAdd = new ArrayList<Host>(this.nodes.length);
        for (Node node : this.nodes) {
            Host host = node.getHost();
            if (this.findSeed(host)) continue;
            seedsToAdd.add(host);
        }
        if (seedsToAdd.size() > 0) {
            this.addSeeds(seedsToAdd.toArray(new Host[seedsToAdd.size()]));
        }
        this.tendValid = true;
        this.tendThread = new Thread(this);
        this.tendThread.setName("tend");
        this.tendThread.setDaemon(true);
        this.tendThread.start();
    }

    public final void addSeeds(Host[] hosts) {
        Host[] seedArray = new Host[this.seeds.length + hosts.length];
        int count = 0;
        for (Host seed : this.seeds) {
            seedArray[count++] = seed;
        }
        for (Host host : hosts) {
            if (Log.debugEnabled()) {
                Log.debug("Add seed " + host);
            }
            seedArray[count++] = host;
        }
        this.seeds = seedArray;
    }

    private final boolean findSeed(Host search) {
        for (Host seed : this.seeds) {
            if (!seed.equals(search)) continue;
            return true;
        }
        return false;
    }

    private final void waitTillStabilized(boolean failIfNotConnected) throws AerospikeException {
        int count = -1;
        for (int i = 0; i < 3; ++i) {
            this.tend(failIfNotConnected);
            if (count == this.nodes.length) {
                return;
            }
            Util.sleep(1L);
            count = this.nodes.length;
        }
        String message = "Cluster not stabilized after multiple tend attempts";
        if (failIfNotConnected) {
            throw new AerospikeException(message);
        }
        Log.warn(message);
    }

    @Override
    public final void run() {
        while (this.tendValid) {
            block3: {
                try {
                    this.tend(false);
                }
                catch (Exception e) {
                    if (!Log.warnEnabled()) break block3;
                    Log.warn("Cluster tend failed: " + Util.getErrorMessage(e));
                }
            }
            Util.sleep(this.tendInterval);
        }
    }

    private final void tend(boolean failIfNotConnected) throws AerospikeException {
        ArrayList<Node> removeList;
        Peers peers = new Peers(this.nodes.length + 16, 16);
        for (Node node : this.nodes) {
            node.referenceCount = 0;
            node.partitionChanged = false;
            node.rebalanceChanged = false;
        }
        if (this.nodes.length == 0) {
            this.seedNode(peers, failIfNotConnected);
        } else {
            for (Node node : this.nodes) {
                node.refresh(peers);
            }
            if (peers.genChanged) {
                peers.refreshCount = 0;
                for (Node node : this.nodes) {
                    node.refreshPeers(peers);
                }
            }
        }
        for (Node node : this.nodes) {
            if (node.partitionChanged) {
                node.refreshPartitions(peers);
            }
            if (!node.rebalanceChanged) continue;
            node.refreshRacks();
        }
        if (peers.genChanged && (removeList = this.findNodesToRemove(peers.refreshCount)).size() > 0) {
            this.removeNodes(removeList);
        }
        if (peers.nodes.size() > 0) {
            this.addNodes(peers.nodes);
        }
        ++this.tendCount;
        if (this.tendCount % 30 == 0) {
            for (Node node : this.nodes) {
                if (!node.errorCountWithinLimit()) continue;
                node.balanceConnections();
            }
            if (this.eventState != null) {
                for (EventState eventState : this.eventState) {
                    final EventLoop eventLoop = eventState.eventLoop;
                    eventLoop.execute(new Runnable(){

                        @Override
                        public void run() {
                            Node[] nodeArray;
                            for (Node node : nodeArray = Cluster.this.nodes) {
                                if (!node.errorCountWithinLimit()) continue;
                                node.balanceAsyncConnections(eventLoop);
                            }
                        }
                    });
                }
            }
        }
        if (this.maxErrorRate > 0 && this.tendCount % this.errorRateWindow == 0) {
            for (Node node : this.nodes) {
                node.resetErrorCount();
            }
        }
        this.processRecoverQueue();
    }

    private final boolean seedNode(Peers peers, boolean failIfNotConnected) {
        Host[] seedArray = this.seeds;
        Exception[] exceptions = null;
        NodeValidator nv = new NodeValidator();
        for (int i = 0; i < seedArray.length; ++i) {
            Host seed = seedArray[i];
            try {
                Node node = nv.seedNode(this, seed, peers);
                if (node == null) continue;
                this.addNode(node);
                return true;
            }
            catch (Exception e) {
                if (seed.tlsName != null && this.tlsPolicy == null) {
                    throw new AerospikeException.Connection("Seed host tlsName '" + seed.tlsName + "' defined but client tlsPolicy not enabled", e);
                }
                if (failIfNotConnected) {
                    if (exceptions == null) {
                        exceptions = new Exception[seedArray.length];
                    }
                    exceptions[i] = e;
                    continue;
                }
                if (!Log.warnEnabled()) continue;
                Log.warn("Seed " + seed + " failed: " + Util.getErrorMessage(e));
            }
        }
        if (nv.fallback != null) {
            this.addNode(nv.fallback);
            return true;
        }
        if (failIfNotConnected) {
            StringBuilder sb = new StringBuilder(500);
            sb.append("Failed to connect to [" + seedArray.length + "] host(s): ");
            sb.append(System.lineSeparator());
            for (int i = 0; i < seedArray.length; ++i) {
                Exception ex;
                sb.append(seedArray[i]);
                sb.append(' ');
                Exception exception = ex = exceptions == null ? null : exceptions[i];
                if (ex == null) continue;
                sb.append(ex.getMessage());
                sb.append(System.lineSeparator());
            }
            throw new AerospikeException.Connection(sb.toString());
        }
        return false;
    }

    protected Node createNode(NodeValidator nv) {
        Node node = new Node(this, nv);
        node.createMinConnections();
        return node;
    }

    private final ArrayList<Node> findNodesToRemove(int refreshCount) {
        ArrayList<Node> removeList = new ArrayList<Node>();
        for (Node node : this.nodes) {
            if (!node.isActive()) {
                removeList.add(node);
                continue;
            }
            if (refreshCount == 0 && node.failures >= 5) {
                removeList.add(node);
                continue;
            }
            if (this.nodes.length <= 1 || refreshCount < 1 || node.referenceCount != 0) continue;
            if (node.failures == 0) {
                if (this.findNodeInPartitionMap(node)) continue;
                removeList.add(node);
                continue;
            }
            removeList.add(node);
        }
        return removeList;
    }

    private final boolean findNodeInPartitionMap(Node filter) {
        for (Partitions partitions : this.partitionMap.values()) {
            for (AtomicReferenceArray<Node> nodeArray : partitions.replicas) {
                int max = nodeArray.length();
                for (int i = 0; i < max; ++i) {
                    Node node = nodeArray.get(i);
                    if (node != filter) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private final void addNode(Node node) {
        node.createMinConnections();
        HashMap<String, Node> nodesToAdd = new HashMap<String, Node>(1);
        nodesToAdd.put(node.getName(), node);
        this.addNodes(nodesToAdd);
    }

    private final void addNodes(HashMap<String, Node> nodesToAdd) {
        Node[] nodeArray = new Node[this.nodes.length + nodesToAdd.size()];
        int count = 0;
        for (Node node : this.nodes) {
            nodeArray[count++] = node;
        }
        for (Node node : nodesToAdd.values()) {
            if (Log.infoEnabled()) {
                Log.info("Add node " + node);
            }
            nodeArray[count++] = node;
            this.nodesMap.put(node.getName(), node);
            for (Host alias : node.aliases) {
                this.aliases.put(alias, node);
            }
        }
        this.nodes = nodeArray;
    }

    private final void removeNodes(List<Node> nodesToRemove) {
        for (Node node : nodesToRemove) {
            this.nodesMap.remove(node.getName());
            for (Host alias : node.aliases) {
                this.aliases.remove(alias);
            }
            node.close();
        }
        this.removeNodesCopy(nodesToRemove);
    }

    private final void removeNodesCopy(List<Node> nodesToRemove) {
        Node[] nodeArray = new Node[this.nodes.length - nodesToRemove.size()];
        int count = 0;
        for (Node node : this.nodes) {
            if (Cluster.findNode(node, nodesToRemove)) {
                if (!Log.infoEnabled()) continue;
                Log.info("Remove node " + node);
                continue;
            }
            nodeArray[count++] = node;
        }
        if (count < nodeArray.length) {
            if (Log.warnEnabled()) {
                Log.warn("Node remove mismatch. Expected " + nodeArray.length + " Received " + count);
            }
            Node[] nodeArray2 = new Node[count];
            System.arraycopy(nodeArray, 0, nodeArray2, 0, count);
            nodeArray = nodeArray2;
        }
        this.nodes = nodeArray;
    }

    private static final boolean findNode(Node search, List<Node> nodeList) {
        for (Node node : nodeList) {
            if (!node.equals(search)) continue;
            return true;
        }
        return false;
    }

    public final boolean isConnected() {
        Node[] nodeArray = this.nodes;
        if (nodeArray.length > 0 && this.tendValid) {
            for (Node node : nodeArray) {
                if (!node.active || node.failures >= 5) continue;
                return true;
            }
        }
        return false;
    }

    public final Node getRandomNode() throws AerospikeException.InvalidNode {
        Node[] nodeArray = this.nodes;
        for (int i = 0; i < nodeArray.length; ++i) {
            int index2 = Math.abs(this.nodeIndex.getAndIncrement() % nodeArray.length);
            Node node = nodeArray[index2];
            if (!node.isActive()) continue;
            return node;
        }
        throw new AerospikeException.InvalidNode("Cluster is empty");
    }

    public final Node[] getNodes() {
        Node[] nodeArray = this.nodes;
        return nodeArray;
    }

    public final Node[] validateNodes() {
        Node[] nodeArray = this.nodes;
        if (nodeArray.length == 0) {
            throw new AerospikeException(-8, "Cluster is empty");
        }
        return nodeArray;
    }

    public final Node getNode(String nodeName) throws AerospikeException.InvalidNode {
        Node node = this.findNode(nodeName);
        if (node == null) {
            throw new AerospikeException.InvalidNode("Invalid node name: " + nodeName);
        }
        return node;
    }

    protected final Node findNode(String nodeName) {
        Node[] nodeArray;
        for (Node node : nodeArray = this.nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    public final boolean isConnCurrentTran(long lastUsed) {
        return this.maxSocketIdleNanosTran == 0L || System.nanoTime() - lastUsed <= this.maxSocketIdleNanosTran;
    }

    public final boolean isConnCurrentTrim(long lastUsed) {
        return System.nanoTime() - lastUsed <= this.maxSocketIdleNanosTrim;
    }

    public final void recoverConnection(ConnectionRecover cs) {
        if (cs.isComplete()) {
            return;
        }
        if (this.recoverCount.getAndIncrement() < 10000) {
            this.recoverQueue.offerLast(cs);
        } else {
            this.recoverCount.getAndDecrement();
            cs.abort();
        }
    }

    private void processRecoverQueue() {
        ConnectionRecover cs;
        byte[] buf = ThreadLocalData.getBuffer();
        ConnectionRecover last = this.recoverQueue.peekLast();
        while ((cs = this.recoverQueue.pollFirst()) != null) {
            if (cs.drain(buf)) {
                this.recoverCount.getAndDecrement();
            } else {
                this.recoverQueue.offerLast(cs);
            }
            if (cs != last) continue;
            break;
        }
    }

    public final ClusterStats getStats() {
        Node[] nodeArray = this.nodes;
        NodeStats[] nodeStats = new NodeStats[nodeArray.length];
        int count = 0;
        for (Node node : nodeArray) {
            nodeStats[count++] = new NodeStats(node);
        }
        EventLoopStats[] eventLoopStats = null;
        if (this.eventLoops != null) {
            EventLoop[] eventLoopArray = this.eventLoops.getArray();
            eventLoopStats = new EventLoopStats[eventLoopArray.length];
            count = 0;
            for (EventLoop eventLoop : eventLoopArray) {
                eventLoopStats[count++] = new EventLoopStats(eventLoop);
            }
        }
        int threadsInUse = 0;
        if (this.threadPool instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.threadPool;
            threadsInUse = tpe.getActiveCount();
        }
        return new ClusterStats(nodeStats, eventLoopStats, threadsInUse, this.recoverCount.get());
    }

    public final void interruptTendSleep() {
        this.tendThread.interrupt();
    }

    public final void printPartitionMap() {
        for (Map.Entry<String, Partitions> entry : this.partitionMap.entrySet()) {
            String namespace = entry.getKey();
            Partitions partitions = entry.getValue();
            AtomicReferenceArray<Node>[] replicas = partitions.replicas;
            for (int i = 0; i < replicas.length; ++i) {
                AtomicReferenceArray<Node> nodeArray = replicas[i];
                int max = nodeArray.length();
                for (int j = 0; j < max; ++j) {
                    Node node = nodeArray.get(j);
                    if (node == null) continue;
                    Log.info(namespace + ',' + i + ',' + j + ',' + node);
                }
            }
        }
    }

    public void changePassword(byte[] user, byte[] password, byte[] passwordHash) {
        if (this.user != null && Arrays.equals(user, this.user)) {
            this.passwordHash = passwordHash;
            if (this.authMode != AuthMode.INTERNAL) {
                this.password = password;
            }
        }
    }

    public final void setMaxErrorRate(int rate) {
        this.maxErrorRate = rate;
    }

    public final void setErrorRateWindow(int window) {
        this.errorRateWindow = window;
    }

    public final ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public final byte[] getUser() {
        return this.user;
    }

    public final byte[] getPassword() {
        return this.password;
    }

    public final byte[] getPasswordHash() {
        return this.passwordHash;
    }

    public final boolean isActive() {
        return this.tendValid;
    }

    @Override
    public void close() {
        if (!this.sharedThreadPool) {
            this.threadPool.shutdown();
        }
        this.tendValid = false;
        this.tendThread.interrupt();
        if (this.eventLoops == null) {
            Node[] nodeArray;
            for (Node node : nodeArray = this.nodes) {
                node.closeSyncConnections();
            }
        } else {
            final AtomicInteger eventLoopCount = new AtomicInteger(this.eventState.length);
            boolean inEventLoop = false;
            for (final EventState state : this.eventState) {
                if (state.eventLoop.inEventLoop()) {
                    inEventLoop = true;
                }
                state.eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (state.pending < 0) {
                            return;
                        }
                        if (state.pending > 0) {
                            state.eventLoop.schedule(this, 200L, TimeUnit.MILLISECONDS);
                            return;
                        }
                        Cluster.this.closeEventLoop(eventLoopCount, state);
                    }
                });
            }
            if (!inEventLoop) {
                this.waitAsyncComplete();
            }
        }
    }

    private final void closeEventLoop(AtomicInteger eventLoopCount, EventState state) {
        Node[] nodeArray;
        state.pending = -1;
        for (Node node : nodeArray = this.nodes) {
            node.closeAsyncConnections(state.index);
        }
        if (eventLoopCount.decrementAndGet() == 0) {
            for (Node node : nodeArray) {
                node.closeSyncConnections();
            }
            this.notifyAsyncComplete();
        }
    }

    private synchronized void waitAsyncComplete() {
        while (!this.asyncComplete) {
            try {
                super.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyAsyncComplete() {
        this.asyncComplete = true;
        super.notify();
    }
}

