/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.exp;

import com.aerospike.client.exp.Expression;
import com.aerospike.client.util.Packer;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public abstract class Exp {
    private static final int EQ = 1;
    private static final int NE = 2;
    private static final int GT = 3;
    private static final int GE = 4;
    private static final int LT = 5;
    private static final int LE = 6;
    private static final int REGEX = 7;
    private static final int GEO = 8;
    private static final int AND = 16;
    private static final int OR = 17;
    private static final int NOT = 18;
    private static final int DIGEST_MODULO = 64;
    private static final int DEVICE_SIZE = 65;
    private static final int LAST_UPDATE = 66;
    private static final int SINCE_UPDATE = 67;
    private static final int VOID_TIME = 68;
    private static final int TTL = 69;
    private static final int SET_NAME = 70;
    private static final int KEY_EXISTS = 71;
    private static final int IS_TOMBSTONE = 72;
    private static final int MEMORY_SIZE = 73;
    private static final int KEY = 80;
    private static final int BIN = 81;
    private static final int BIN_TYPE = 82;
    private static final int QUOTED = 126;
    private static final int CALL = 127;
    public static final int MODIFY = 64;
    private static final long NANOS_PER_MILLIS = 1000000L;

    public static Expression build(Exp exp) {
        return new Expression(exp);
    }

    public static Exp key(Type type) {
        return new CmdInt(80, type.code);
    }

    public static Exp keyExists() {
        return new Cmd(71);
    }

    public static Exp bin(String name, Type type) {
        return new Bin(name, type);
    }

    public static Exp intBin(String name) {
        return new Bin(name, Type.INT);
    }

    public static Exp floatBin(String name) {
        return new Bin(name, Type.FLOAT);
    }

    public static Exp stringBin(String name) {
        return new Bin(name, Type.STRING);
    }

    public static Exp blobBin(String name) {
        return new Bin(name, Type.BLOB);
    }

    public static Exp geoBin(String name) {
        return new Bin(name, Type.GEO);
    }

    public static Exp listBin(String name) {
        return new Bin(name, Type.LIST);
    }

    public static Exp mapBin(String name) {
        return new Bin(name, Type.MAP);
    }

    public static Exp hllBin(String name) {
        return new Bin(name, Type.HLL);
    }

    public static Exp binExists(String name) {
        return Exp.ne(Exp.binType(name), Exp.val(0L));
    }

    public static Exp binType(String name) {
        return new CmdStr(82, name);
    }

    public static Exp setName() {
        return new Cmd(70);
    }

    public static Exp deviceSize() {
        return new Cmd(65);
    }

    public static Exp memorySize() {
        return new Cmd(73);
    }

    public static Exp lastUpdate() {
        return new Cmd(66);
    }

    public static Exp sinceUpdate() {
        return new Cmd(67);
    }

    public static Exp voidTime() {
        return new Cmd(68);
    }

    public static Exp ttl() {
        return new Cmd(69);
    }

    public static Exp isTombstone() {
        return new Cmd(72);
    }

    public static Exp digestModulo(int mod) {
        return new CmdInt(64, mod);
    }

    public static Exp regexCompare(String regex, int flags, Exp bin) {
        return new Regex(bin, regex, flags);
    }

    public static Exp geoCompare(Exp left, Exp right) {
        return new CmdExp(8, new Exp[]{left, right});
    }

    public static Exp geo(String val) {
        return new Geo(val);
    }

    public static Exp val(boolean val) {
        return new Bool(val);
    }

    public static Exp val(long val) {
        return new Int(val);
    }

    public static Exp val(Calendar val) {
        return new Int(val.getTimeInMillis() * 1000000L);
    }

    public static Exp val(double val) {
        return new Float(val);
    }

    public static Exp val(String val) {
        return new Str(val);
    }

    public static Exp val(byte[] val) {
        return new Blob(val);
    }

    public static Exp val(List<?> list) {
        return new ListVal(list);
    }

    public static Exp val(Map<?, ?> map) {
        return new MapVal(map);
    }

    public static Exp nil() {
        return new Nil();
    }

    public static Exp not(Exp exp) {
        return new CmdExp(18, new Exp[]{exp});
    }

    public static Exp and(Exp ... exps) {
        return new CmdExp(16, exps);
    }

    public static Exp or(Exp ... exps) {
        return new CmdExp(17, exps);
    }

    public static Exp eq(Exp left, Exp right) {
        return new CmdExp(1, new Exp[]{left, right});
    }

    public static Exp ne(Exp left, Exp right) {
        return new CmdExp(2, new Exp[]{left, right});
    }

    public static Exp gt(Exp left, Exp right) {
        return new CmdExp(3, new Exp[]{left, right});
    }

    public static Exp ge(Exp left, Exp right) {
        return new CmdExp(4, new Exp[]{left, right});
    }

    public static Exp lt(Exp left, Exp right) {
        return new CmdExp(5, new Exp[]{left, right});
    }

    public static Exp le(Exp left, Exp right) {
        return new CmdExp(6, new Exp[]{left, right});
    }

    public abstract void pack(Packer var1);

    private static final class Nil
    extends Exp {
        private Nil() {
        }

        @Override
        public void pack(Packer packer) {
            packer.packNil();
        }
    }

    private static final class MapVal
    extends Exp {
        private final Map<?, ?> map;

        private MapVal(Map<?, ?> map) {
            this.map = map;
        }

        @Override
        public void pack(Packer packer) {
            packer.packMap(this.map);
        }
    }

    private static final class ListVal
    extends Exp {
        private final List<?> list;

        private ListVal(List<?> list) {
            this.list = list;
        }

        @Override
        public void pack(Packer packer) {
            packer.packArrayBegin(2);
            packer.packInt(126);
            packer.packList(this.list);
        }
    }

    private static final class Blob
    extends Exp {
        private final byte[] val;

        private Blob(byte[] val) {
            this.val = val;
        }

        @Override
        public void pack(Packer packer) {
            packer.packParticleBytes(this.val);
        }
    }

    private static final class Geo
    extends Exp {
        private final String val;

        private Geo(String val) {
            this.val = val;
        }

        @Override
        public void pack(Packer packer) {
            packer.packGeoJSON(this.val);
        }
    }

    private static final class Str
    extends Exp {
        private final String val;

        private Str(String val) {
            this.val = val;
        }

        @Override
        public void pack(Packer packer) {
            packer.packParticleString(this.val);
        }
    }

    private static final class Float
    extends Exp {
        private final double val;

        private Float(double val) {
            this.val = val;
        }

        @Override
        public void pack(Packer packer) {
            packer.packDouble(this.val);
        }
    }

    private static final class Int
    extends Exp {
        private final long val;

        private Int(long val) {
            this.val = val;
        }

        @Override
        public void pack(Packer packer) {
            packer.packLong(this.val);
        }
    }

    private static final class Bool
    extends Exp {
        private final boolean val;

        private Bool(boolean val) {
            this.val = val;
        }

        @Override
        public void pack(Packer packer) {
            packer.packBoolean(this.val);
        }
    }

    private static final class Cmd
    extends Exp {
        private final int cmd;

        private Cmd(int cmd) {
            this.cmd = cmd;
        }

        @Override
        public void pack(Packer packer) {
            packer.packArrayBegin(1);
            packer.packInt(this.cmd);
        }
    }

    private static final class CmdStr
    extends Exp {
        private final String str;
        private final int cmd;

        private CmdStr(int cmd, String str) {
            this.str = str;
            this.cmd = cmd;
        }

        @Override
        public void pack(Packer packer) {
            packer.packArrayBegin(2);
            packer.packInt(this.cmd);
            packer.packString(this.str);
        }
    }

    private static final class CmdInt
    extends Exp {
        private final int cmd;
        private final int val;

        private CmdInt(int cmd, int val) {
            this.cmd = cmd;
            this.val = val;
        }

        @Override
        public void pack(Packer packer) {
            packer.packArrayBegin(2);
            packer.packInt(this.cmd);
            packer.packInt(this.val);
        }
    }

    private static final class CmdExp
    extends Exp {
        private final Exp[] exps;
        private final int cmd;

        private CmdExp(int cmd, Exp ... exps) {
            this.exps = exps;
            this.cmd = cmd;
        }

        @Override
        public void pack(Packer packer) {
            packer.packArrayBegin(this.exps.length + 1);
            packer.packInt(this.cmd);
            for (Exp exp : this.exps) {
                exp.pack(packer);
            }
        }
    }

    private static final class Regex
    extends Exp {
        private final Exp bin;
        private final String regex;
        private final int flags;

        private Regex(Exp bin, String regex, int flags) {
            this.bin = bin;
            this.regex = regex;
            this.flags = flags;
        }

        @Override
        public void pack(Packer packer) {
            packer.packArrayBegin(4);
            packer.packInt(7);
            packer.packInt(this.flags);
            packer.packString(this.regex);
            this.bin.pack(packer);
        }
    }

    private static final class Bin
    extends Exp {
        private final String name;
        private final Type type;

        public Bin(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public void pack(Packer packer) {
            packer.packArrayBegin(3);
            packer.packInt(81);
            packer.packInt(this.type.code);
            packer.packString(this.name);
        }
    }

    static class Module
    extends Exp {
        private final Exp bin;
        private final byte[] bytes;
        private final int retType;
        private final int module;

        public Module(Exp bin, byte[] bytes, int retType, int module) {
            this.bin = bin;
            this.bytes = bytes;
            this.retType = retType;
            this.module = module;
        }

        @Override
        public void pack(Packer packer) {
            packer.packArrayBegin(5);
            packer.packInt(127);
            packer.packInt(this.retType);
            packer.packInt(this.module);
            packer.packByteArray(this.bytes, 0, this.bytes.length);
            this.bin.pack(packer);
        }
    }

    public static enum Type {
        NIL(0),
        BOOL(1),
        INT(2),
        STRING(3),
        LIST(4),
        MAP(5),
        BLOB(6),
        FLOAT(7),
        GEO(8),
        HLL(9);

        public final int code;

        private Type(int code) {
            this.code = code;
        }
    }
}

