/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.Value;
import java.util.List;
import java.util.Map;

public final class Record {
    public final Map<String, Object> bins;
    public final int generation;
    public final int expiration;

    public Record(Map<String, Object> bins, int generation, int expiration) {
        this.bins = bins;
        this.generation = generation;
        this.expiration = expiration;
    }

    public Object getValue(String name) {
        return this.bins == null ? null : this.bins.get(name);
    }

    public String getString(String name) {
        return (String)this.getValue(name);
    }

    public double getDouble(String name) {
        Object result = this.getValue(name);
        return result instanceof Double ? (Double)result : (result != null ? Double.longBitsToDouble((Long)result) : 0.0);
    }

    public float getFloat(String name) {
        return (float)this.getDouble(name);
    }

    public long getLong(String name) {
        Object result = this.getValue(name);
        return result != null ? (Long)result : 0L;
    }

    public int getInt(String name) {
        return (int)this.getLong(name);
    }

    public short getShort(String name) {
        return (short)this.getLong(name);
    }

    public byte getByte(String name) {
        return (byte)this.getLong(name);
    }

    public boolean getBoolean(String name) {
        Object result = this.getValue(name);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result != null) {
            long v = (Long)result;
            return v != 0L;
        }
        return false;
    }

    public List<?> getList(String name) {
        return (List)this.getValue(name);
    }

    public Map<?, ?> getMap(String name) {
        return (Map)this.getValue(name);
    }

    @Deprecated
    public String getGeoJSON(String name) {
        return this.getGeoJSONString(name);
    }

    public String getGeoJSONString(String name) {
        Object value = this.getValue(name);
        return value != null ? value.toString() : null;
    }

    public Value.GeoJSONValue getGeoJSONValue(String name) {
        return (Value.GeoJSONValue)this.getValue(name);
    }

    public Value.HLLValue getHLLValue(String name) {
        return (Value.HLLValue)this.getValue(name);
    }

    public int getTimeToLive() {
        if (this.expiration == 0) {
            return -1;
        }
        int now = (int)((System.currentTimeMillis() - 1262304000000L) / 1000L);
        return this.expiration < 0 && now >= 0 || this.expiration > now ? this.expiration - now : 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(500);
        sb.append("(gen:");
        sb.append(this.generation);
        sb.append("),(exp:");
        sb.append(this.expiration);
        sb.append("),(bins:");
        if (this.bins != null) {
            boolean sep = false;
            for (Map.Entry<String, Object> entry : this.bins.entrySet()) {
                if (sep) {
                    sb.append(',');
                } else {
                    sep = true;
                }
                sb.append('(');
                sb.append(entry.getKey());
                sb.append(':');
                sb.append(entry.getValue());
                sb.append(')');
                if (sb.length() <= 1000) continue;
                sb.append("...");
                break;
            }
        } else {
            sb.append("null");
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Record other = (Record)obj;
        if (this.expiration != other.expiration) {
            return false;
        }
        if (this.generation != other.generation) {
            return false;
        }
        if (this.bins == null) {
            return other.bins == null;
        }
        return this.bins.equals(other.bins);
    }
}

