/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.Policy;
import java.util.LinkedHashMap;

public abstract class AsyncMultiCommand
extends AsyncCommand {
    final AsyncMultiExecutor parent;
    final Node node;
    int groups;
    int info3;
    int resultCode;
    int generation;
    int expiration;
    int batchIndex;
    int fieldCount;
    int opCount;
    final boolean stopOnNotFound;

    public AsyncMultiCommand(AsyncMultiExecutor parent, Node node, Policy policy) {
        super(policy, false);
        this.parent = parent;
        this.node = node;
        this.stopOnNotFound = false;
    }

    public AsyncMultiCommand(AsyncMultiExecutor parent, Node node, Policy policy, int socketTimeout, int totalTimeout) {
        super(policy, socketTimeout, totalTimeout);
        this.parent = parent;
        this.node = node;
        this.stopOnNotFound = true;
    }

    @Override
    protected Node getNode(Cluster cluster) {
        return this.node;
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        return true;
    }

    @Override
    final boolean parseResult() {
        while (this.dataOffset < this.receiveSize) {
            this.dataOffset += 3;
            this.info3 = this.dataBuffer[this.dataOffset] & 0xFF;
            this.dataOffset += 2;
            this.resultCode = this.dataBuffer[this.dataOffset] & 0xFF;
            if (this.resultCode != 0) {
                if (this.resultCode == 2 || this.resultCode == 27) {
                    if (this.stopOnNotFound) {
                        return true;
                    }
                } else {
                    throw new AerospikeException(this.resultCode);
                }
            }
            if ((this.info3 & 1) != 0) {
                return true;
            }
            ++this.dataOffset;
            this.generation = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.expiration = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.batchIndex = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.fieldCount = Buffer.bytesToShort(this.dataBuffer, this.dataOffset);
            this.dataOffset += 2;
            this.opCount = Buffer.bytesToShort(this.dataBuffer, this.dataOffset);
            this.dataOffset += 2;
            Key key = this.parseKey();
            this.parseRow(key);
        }
        return false;
    }

    private final Key parseKey() {
        byte[] digest = null;
        String namespace = null;
        String setName = null;
        Value userKey = null;
        block6: for (int i = 0; i < this.fieldCount; ++i) {
            int fieldlen = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            byte fieldtype = this.dataBuffer[this.dataOffset++];
            int size = fieldlen - 1;
            switch (fieldtype) {
                case 4: {
                    digest = new byte[size];
                    System.arraycopy(this.dataBuffer, this.dataOffset, digest, 0, size);
                    this.dataOffset += size;
                    continue block6;
                }
                case 0: {
                    namespace = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, size);
                    this.dataOffset += size;
                    continue block6;
                }
                case 1: {
                    setName = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, size);
                    this.dataOffset += size;
                    continue block6;
                }
                case 2: {
                    byte type = this.dataBuffer[this.dataOffset++];
                    userKey = Buffer.bytesToKeyValue(type, this.dataBuffer, this.dataOffset, --size);
                    this.dataOffset += size;
                }
            }
        }
        return new Key(namespace, digest, setName, userKey);
    }

    protected final Record parseRecord() {
        if (this.opCount <= 0) {
            return new Record(null, this.generation, this.expiration);
        }
        LinkedHashMap<String, Object> bins = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.opCount; ++i) {
            int opSize = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            byte particleType = this.dataBuffer[this.dataOffset + 5];
            byte nameSize = this.dataBuffer[this.dataOffset + 7];
            String name = Buffer.utf8ToString(this.dataBuffer, this.dataOffset + 8, nameSize);
            this.dataOffset += 8 + nameSize;
            int particleBytesSize = opSize - (4 + nameSize);
            Object value = Buffer.bytesToParticle(particleType, this.dataBuffer, this.dataOffset, particleBytesSize);
            this.dataOffset += particleBytesSize;
            bins.put(name, value);
        }
        return new Record(bins, this.generation, this.expiration);
    }

    @Override
    protected final void onSuccess() {
        this.parent.childSuccess(this.node);
    }

    @Override
    protected void onFailure(AerospikeException e) {
        this.parent.childFailure(e);
    }

    protected abstract void parseRow(Key var1);
}

