/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.AsyncConnector;
import com.aerospike.client.async.NettyCommand;
import com.aerospike.client.async.NettyConnection;
import com.aerospike.client.async.NettyEventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.TlsPolicy;
import com.aerospike.client.util.Util;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;

public final class NettyConnector
extends AsyncConnector {
    private final NettyEventLoop eventLoop;
    private final byte[] dataBuffer;
    private NettyConnection conn;
    private int dataOffset;
    private int receiveSize;

    public NettyConnector(NettyEventLoop eventLoop, Cluster cluster, Node node, AsyncConnector.Listener listener) {
        super(eventLoop, cluster, node, listener);
        this.eventLoop = eventLoop;
        this.dataBuffer = cluster.getUser() != null ? new byte[256] : null;
    }

    @Override
    public void createConnection() {
        this.state = 3;
        final InboundHandler handler = new InboundHandler();
        handler.command = this;
        Bootstrap b = new Bootstrap();
        NettyCommand.initBootstrap(b, this.eventLoop);
        b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                if (NettyConnector.this.state != 3) {
                    try {
                        ch.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return;
                }
                NettyConnector.this.state = 4;
                NettyConnector.this.conn = new NettyConnection(ch);
                NettyConnector.this.pool.connectionOpened();
                ChannelPipeline p = ch.pipeline();
                if (((NettyConnector)NettyConnector.this).eventLoop.parent.sslContext != null && !((NettyConnector)NettyConnector.this).eventLoop.parent.tlsPolicy.forLoginOnly) {
                    NettyConnector.this.state = 5;
                    p.addLast(new ChannelHandler[]{((NettyConnector)NettyConnector.this).eventLoop.parent.sslContext.newHandler(ch.alloc())});
                }
                p.addLast(new ChannelHandler[]{handler});
            }
        });
        b.connect((SocketAddress)this.node.getAddress());
    }

    private void channelActive() {
        byte[] token = this.node.getSessionToken();
        if (token != null) {
            this.writeAuth(token);
        } else {
            this.finish();
        }
    }

    private void writeAuth(byte[] token) {
        this.state = 6;
        AdminCommand admin = new AdminCommand(this.dataBuffer);
        this.dataOffset = admin.setAuthenticate(this.cluster, token);
        ByteBuf byteBuffer = PooledByteBufAllocator.DEFAULT.directBuffer(this.dataOffset);
        byteBuffer.clear();
        byteBuffer.writeBytes(this.dataBuffer, 0, this.dataOffset);
        ChannelFuture cf = this.conn.channel.writeAndFlush((Object)byteBuffer);
        cf.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (NettyConnector.this.state == 6) {
                    NettyConnector.this.state = 7;
                    NettyConnector.this.dataOffset = 0;
                    ((NettyConnector)NettyConnector.this).conn.channel.config().setAutoRead(true);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void read(ByteBuf byteBuffer) {
        try {
            switch (this.state) {
                case 7: {
                    this.readAuthHeader(byteBuffer);
                    return;
                }
                case 8: {
                    this.readAuthBody(byteBuffer);
                    return;
                }
            }
            return;
        }
        finally {
            byteBuffer.release();
        }
    }

    private void readAuthHeader(ByteBuf byteBuffer) {
        int avail = byteBuffer.readableBytes();
        int offset = this.dataOffset + avail;
        if (offset < 8) {
            byteBuffer.readBytes(this.dataBuffer, this.dataOffset, avail);
            this.dataOffset = offset;
            return;
        }
        byteBuffer.readBytes(this.dataBuffer, this.dataOffset, 8 - this.dataOffset);
        this.receiveSize = (int)(Buffer.bytesToLong(this.dataBuffer, 0) & 0xFFFFFFFFFFFFL);
        if (this.receiveSize < 2 || this.receiveSize > this.dataBuffer.length) {
            throw new AerospikeException.Parse("Invalid auth receive size: " + this.receiveSize);
        }
        this.state = 8;
        this.dataOffset = offset -= 8;
        if (offset > 0) {
            byteBuffer.readBytes(this.dataBuffer, 0, offset);
            if (offset >= this.receiveSize) {
                this.parseAuthBody();
            }
        }
    }

    private void readAuthBody(ByteBuf byteBuffer) {
        int avail = byteBuffer.readableBytes();
        int offset = this.dataOffset + avail;
        if (offset < this.receiveSize) {
            byteBuffer.readBytes(this.dataBuffer, this.dataOffset, avail);
            this.dataOffset = offset;
            return;
        }
        this.parseAuthBody();
    }

    private void parseAuthBody() {
        int resultCode = this.dataBuffer[1] & 0xFF;
        if (resultCode != 0 && resultCode != 52) {
            this.node.signalLogin();
            throw new AerospikeException(resultCode);
        }
        this.finish();
    }

    private final void finish() {
        ChannelPipeline p = this.conn.channel.pipeline();
        p.removeLast();
        p.addLast(new ChannelHandler[]{new NettyCommand.InboundHandler(this.pool)});
        this.conn.channel.config().setAutoRead(false);
        this.conn.updateLastUsed();
        this.success();
    }

    @Override
    final boolean addConnection() {
        boolean ret = this.pool.putConnection(this.conn);
        this.conn = null;
        return ret;
    }

    @Override
    final void closeConnection() {
        if (this.conn != null) {
            this.pool.closeConnection(this.node, this.conn);
            this.conn = null;
        } else {
            this.pool.release(this.node);
        }
    }

    static final class InboundHandler
    extends ChannelInboundHandlerAdapter {
        NettyConnector command;

        InboundHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) {
            if (this.command.state == 4) {
                this.command.channelActive();
            }
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.command.read((ByteBuf)msg);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (!(evt instanceof SslHandshakeCompletionEvent)) {
                return;
            }
            Throwable cause = ((SslHandshakeCompletionEvent)evt).cause();
            if (cause != null) {
                throw new AerospikeException("TLS connect failed: " + cause.getMessage(), cause);
            }
            TlsPolicy tlsPolicy = ((NettyConnector)this.command).eventLoop.parent.tlsPolicy;
            String tlsName = this.command.node.getHost().tlsName;
            SSLSession session = ((SslHandler)ctx.pipeline().first()).engine().getSession();
            X509Certificate cert = (X509Certificate)session.getPeerCertificates()[0];
            Connection.validateServerCertificate(tlsPolicy, tlsName, cert);
            if (this.command.state == 5) {
                this.command.channelActive();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (this.command == null) {
                Log.error("Connection exception: " + Util.getErrorMessage(cause));
                return;
            }
            this.command.fail(new AerospikeException(cause));
        }
    }
}

