/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.async.AsyncConnection;
import com.aerospike.client.async.AsyncConnectorExecutor;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.NettyConnection;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.ConnectionStats;
import com.aerospike.client.cluster.Node;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;

public final class AsyncPool {
    private final ArrayDeque<AsyncConnection> queue;
    private final int minSize;
    private final int maxSize;
    private final int index;
    private int total;
    private int opened;
    private int closed;
    private int removeClosed;

    public AsyncPool(int minSize, int maxSize, int eventLoopIndex) {
        this.queue = new ArrayDeque(maxSize);
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.index = eventLoopIndex;
    }

    public AsyncConnection getConnection(Node node, ByteBuffer byteBuffer) {
        AsyncConnection conn;
        Cluster cluster = node.cluster;
        while ((conn = this.queue.pollFirst()) != null) {
            if (!cluster.isConnCurrentTran(conn.getLastUsed())) {
                this.closeIdleConnection(conn);
                continue;
            }
            if (!conn.isValid(byteBuffer)) {
                this.closeConnection(node, conn);
                continue;
            }
            return conn;
        }
        if (this.reserve()) {
            return null;
        }
        throw new AerospikeException.Connection(-7, "Max async conns reached: " + this + ',' + this.index + ',' + this.total + ',' + this.queue.size() + ',' + this.maxSize);
    }

    public boolean putConnection(AsyncConnection conn) {
        if (conn == null) {
            if (Log.warnEnabled()) {
                Log.warn("Async conn is null: " + this + ',' + this.index);
            }
            return false;
        }
        if (this.queue.size() < this.maxSize) {
            this.queue.addFirst(conn);
            return true;
        }
        conn.close();
        if (Log.warnEnabled()) {
            Log.warn("Async conn pool is full: " + this + ',' + this.index + ',' + this.total + ',' + this.queue.size() + ',' + this.maxSize);
        }
        return false;
    }

    public void balance(EventLoop eventLoop, Node node) {
        int excess;
        if (this.removeClosed > 0) {
            this.removeClosed = 0;
            this.removeClosedAll();
        }
        if ((excess = this.total - this.minSize) > 0) {
            this.closeIdleConnections(node, excess);
        } else if (excess < 0 && node.errorCountWithinLimit()) {
            new AsyncConnectorExecutor(eventLoop, node.cluster, node, -excess, 1, null, null);
        }
    }

    public void removeClosedAll() {
        NettyConnection first;
        NettyConnection conn = first = (NettyConnection)this.queue.pollFirst();
        while (conn != null) {
            if (conn.isOpen()) {
                this.queue.addLast(conn);
            } else {
                this.connectionClosed();
            }
            if ((conn = (NettyConnection)this.queue.pollFirst()) != first) continue;
        }
    }

    public void removeClosedTail() {
        NettyConnection conn;
        ++this.removeClosed;
        while ((conn = (NettyConnection)this.queue.peekLast()) != null && !conn.isOpen()) {
            this.queue.pollLast();
            this.connectionClosed();
            --this.removeClosed;
        }
    }

    private void closeIdleConnections(Node node, int count) {
        AsyncConnection conn;
        Cluster cluster = node.cluster;
        while (count > 0 && (conn = this.queue.peekLast()) != null && !cluster.isConnCurrentTrim(conn.getLastUsed())) {
            this.queue.pollLast();
            this.closeIdleConnection(conn);
            --count;
        }
    }

    private void closeIdleConnection(AsyncConnection conn) {
        this.connectionClosed();
        conn.close();
    }

    public void closeConnections() {
        AsyncConnection conn;
        while ((conn = this.queue.pollFirst()) != null) {
            conn.close();
        }
    }

    public void closeConnection(Node node, AsyncConnection conn) {
        this.connectionClosed();
        conn.close();
        node.incrErrorCount();
    }

    public boolean reserve() {
        if (this.total >= this.maxSize || this.queue.size() >= this.maxSize) {
            return false;
        }
        ++this.total;
        return true;
    }

    public void release(Node node) {
        --this.total;
        node.incrErrorCount();
    }

    public void connectionOpened() {
        ++this.opened;
    }

    private void connectionClosed() {
        --this.total;
        ++this.closed;
    }

    public ConnectionStats getConnectionStats() {
        int inPool = this.queue.size();
        return new ConnectionStats(this.total - inPool, inPool, this.opened, this.closed);
    }

    public int getMinSize() {
        return this.minSize;
    }
}

