/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Peer;
import java.util.ArrayList;
import java.util.List;

public final class PeerParser {
    private final Cluster cluster;
    private final Info parser;
    private String tlsName;
    private final int portDefault;
    public final int generation;

    public PeerParser(Cluster cluster, Connection conn, List<Peer> peers) {
        this.cluster = cluster;
        String command = cluster.tlsPolicy != null ? (cluster.useServicesAlternate ? "peers-tls-alt" : "peers-tls-std") : (cluster.useServicesAlternate ? "peers-clear-alt" : "peers-clear-std");
        this.parser = new Info(conn, command);
        if (this.parser.length == 0) {
            throw new AerospikeException.Parse(command + " response is empty");
        }
        this.parser.skipToValue();
        this.generation = this.parser.parseInt();
        this.parser.expect(',');
        this.portDefault = this.parser.parseInt();
        this.parser.expect(',');
        this.parser.expect('[');
        peers.clear();
        if (this.parser.buffer[this.parser.offset] == 93) {
            return;
        }
        while (true) {
            Peer peer = this.parsePeer();
            peers.add(peer);
            if (this.parser.offset >= this.parser.length || this.parser.buffer[this.parser.offset] != 44) break;
            ++this.parser.offset;
        }
    }

    private Peer parsePeer() {
        Peer peer = new Peer();
        this.parser.expect('[');
        peer.nodeName = this.parser.parseString(',');
        ++this.parser.offset;
        peer.tlsName = this.tlsName = this.parser.parseString(',');
        ++this.parser.offset;
        peer.hosts = this.parseHosts();
        this.parser.expect(']');
        return peer;
    }

    private List<Host> parseHosts() {
        ArrayList<Host> hosts = new ArrayList<Host>(4);
        this.parser.expect('[');
        if (this.parser.buffer[this.parser.offset] == 93) {
            return hosts;
        }
        while (true) {
            Host host = this.parseHost();
            hosts.add(host);
            if (this.parser.buffer[this.parser.offset] == 93) {
                ++this.parser.offset;
                return hosts;
            }
            ++this.parser.offset;
        }
    }

    private Host parseHost() {
        String alternativeHost;
        String host;
        if (this.parser.buffer[this.parser.offset] == 91) {
            ++this.parser.offset;
            host = this.parser.parseString(']');
            ++this.parser.offset;
        } else {
            host = this.parser.parseString(':', ',', ']');
        }
        if (this.cluster.ipMap != null && (alternativeHost = this.cluster.ipMap.get(host)) != null) {
            host = alternativeHost;
        }
        if (this.parser.offset < this.parser.length) {
            byte b = this.parser.buffer[this.parser.offset];
            if (b == 58) {
                ++this.parser.offset;
                int port = this.parser.parseInt();
                return new Host(host, this.tlsName, port);
            }
            if (b == 44 || b == 93) {
                return new Host(host, this.tlsName, this.portDefault);
            }
        }
        String response = this.parser.getTruncatedResponse();
        throw new AerospikeException.Parse("Unterminated host in response: " + response);
    }
}

