/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.ConnectionRecover;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Command;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.ThreadLocalData;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;

public abstract class SyncCommand
extends Command {
    protected final Cluster cluster;
    protected final Policy policy;
    int iteration = 1;
    int commandSentCounter;
    long deadline;

    public SyncCommand(Cluster cluster, Policy policy) {
        super(policy.socketTimeout, policy.totalTimeout, policy.maxRetries);
        this.cluster = cluster;
        this.policy = policy;
    }

    public SyncCommand(Cluster cluster, Policy policy, int socketTimeout, int totalTimeout) {
        super(socketTimeout, totalTimeout, 0);
        this.cluster = cluster;
        this.policy = policy;
    }

    public void execute() {
        if (this.totalTimeout > 0) {
            this.deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.totalTimeout);
        }
        this.executeCommand();
    }

    public final void executeCommand() {
        Node node;
        boolean isClientTimeout;
        AerospikeException exception;
        block29: {
            exception = null;
            do {
                block28: {
                    try {
                        node = this.getNode();
                    }
                    catch (AerospikeException ae) {
                        if (this.cluster.isActive()) {
                            ae.setPolicy(this.policy);
                            ae.setIteration(this.iteration);
                            ae.setInDoubt(this.isWrite(), this.commandSentCounter);
                            throw ae;
                        }
                        throw new AerospikeException("Cluster has been closed");
                    }
                    try {
                        node.validateErrorCount();
                        Connection conn = node.getConnection(this.policy.connectTimeout, this.socketTimeout, this.policy.timeoutDelay);
                        try {
                            this.writeBuffer();
                            conn.write(this.dataBuffer, this.dataOffset);
                            ++this.commandSentCounter;
                            this.parseResult(conn);
                            node.putConnection(conn);
                            return;
                        }
                        catch (AerospikeException ae) {
                            if (ae.keepConnection()) {
                                node.putConnection(conn);
                            } else {
                                node.closeConnection(conn);
                            }
                            if (ae.getResultCode() == 9) {
                                exception = new AerospikeException.Timeout(this.policy, false);
                                isClientTimeout = false;
                                break block28;
                            }
                            if (ae.getResultCode() == 18) {
                                exception = ae;
                                isClientTimeout = false;
                                node.incrErrorCount();
                                break block28;
                            }
                            throw ae;
                        }
                        catch (Connection.ReadTimeout crt) {
                            if (this.policy.timeoutDelay > 0) {
                                this.cluster.recoverConnection(new ConnectionRecover(conn, node, this.policy.timeoutDelay, crt, this.isSingle()));
                            } else {
                                node.closeConnection(conn);
                            }
                            isClientTimeout = true;
                        }
                        catch (RuntimeException re) {
                            node.closeConnection(conn);
                            throw re;
                        }
                        catch (SocketTimeoutException ste) {
                            node.closeConnection(conn);
                            isClientTimeout = true;
                        }
                        catch (IOException ioe) {
                            node.closeConnection(conn);
                            exception = new AerospikeException.Connection(ioe);
                            isClientTimeout = false;
                        }
                    }
                    catch (Connection.ReadTimeout crt) {
                        isClientTimeout = true;
                    }
                    catch (AerospikeException.Connection ce) {
                        exception = ce;
                        isClientTimeout = false;
                    }
                    catch (AerospikeException.Backoff be) {
                        exception = be;
                        isClientTimeout = false;
                    }
                    catch (AerospikeException ae) {
                        ae.setNode(node);
                        ae.setPolicy(this.policy);
                        ae.setIteration(this.iteration);
                        ae.setInDoubt(this.isWrite(), this.commandSentCounter);
                        if (Log.debugEnabled()) {
                            SyncCommand.LogPolicy(this.policy);
                        }
                        throw ae;
                    }
                }
                if (this.iteration > this.maxRetries) break block29;
                if (this.totalTimeout > 0) {
                    long remaining = this.deadline - System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(this.policy.sleepBetweenRetries);
                    if (remaining <= 0L) break block29;
                    if ((remaining = TimeUnit.NANOSECONDS.toMillis(remaining)) < (long)this.totalTimeout) {
                        this.totalTimeout = (int)remaining;
                        if (this.socketTimeout > this.totalTimeout) {
                            this.socketTimeout = this.totalTimeout;
                        }
                    }
                }
                if (!isClientTimeout && this.policy.sleepBetweenRetries > 0) {
                    Util.sleep(this.policy.sleepBetweenRetries);
                }
                ++this.iteration;
            } while (this.prepareRetry(isClientTimeout || exception.getResultCode() != -8) || !this.retryBatch(this.cluster, this.socketTimeout, this.totalTimeout, this.deadline, this.iteration, this.commandSentCounter));
            return;
        }
        if (isClientTimeout) {
            exception = new AerospikeException.Timeout(this.policy, true);
        }
        exception.setNode(node);
        exception.setPolicy(this.policy);
        exception.setIteration(this.iteration);
        exception.setInDoubt(this.isWrite(), this.commandSentCounter);
        if (Log.debugEnabled()) {
            SyncCommand.LogPolicy(this.policy);
        }
        throw exception;
    }

    @Override
    protected final void sizeBuffer() {
        this.dataBuffer = ThreadLocalData.getBuffer();
        if (this.dataOffset > this.dataBuffer.length) {
            this.dataBuffer = ThreadLocalData.resizeBuffer(this.dataOffset);
        }
    }

    protected final void sizeBuffer(int size) {
        if (size > this.dataBuffer.length) {
            this.dataBuffer = ThreadLocalData.resizeBuffer(size);
        }
    }

    protected boolean retryBatch(Cluster cluster, int socketTimeout, int totalTimeout, long deadline, int iteration, int commandSentCounter) {
        return false;
    }

    protected boolean isSingle() {
        return true;
    }

    protected boolean isWrite() {
        return false;
    }

    protected abstract Node getNode();

    protected abstract void writeBuffer();

    protected abstract void parseResult(Connection var1) throws AerospikeException, IOException;

    protected abstract boolean prepareRetry(boolean var1);
}

