/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.task;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.Task;

public final class ExecuteTask
extends Task {
    private final long taskId;
    private final boolean scan;

    public ExecuteTask(Cluster cluster, Policy policy, Statement statement) {
        super(cluster, policy);
        this.taskId = statement.getTaskId();
        this.scan = statement.isScan();
    }

    public long getTaskId() {
        return this.taskId;
    }

    @Override
    public int queryStatus() throws AerospikeException {
        Node[] nodes = this.cluster.validateNodes();
        String module = this.scan ? "scan" : "query";
        String command = "jobs:module=" + module + ";cmd=get-job;trid=" + this.taskId;
        for (Node node : nodes) {
            int end;
            String response = Info.request(this.policy, node, command);
            if (response.startsWith("ERROR:2")) {
                return 0;
            }
            if (response.startsWith("ERROR:")) {
                throw new AerospikeException(command + " failed: " + response);
            }
            String find = "status=";
            int index2 = response.indexOf(find);
            if (index2 < 0) {
                throw new AerospikeException(command + " failed: " + response);
            }
            int begin = index2 + find.length();
            String status = response.substring(begin, end = response.indexOf(58, begin));
            if (status.startsWith("done") || status.startsWith("DONE")) continue;
            return 1;
        }
        return 2;
    }
}

