/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.util;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.MapOrder;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.util.ThreadLocalData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class Packer {
    private byte[] buffer = ThreadLocalData.getBuffer();
    private int offset;
    private ArrayList<BufferItem> bufferList;

    public static byte[] pack(Value[] val) throws AerospikeException {
        try {
            Packer packer = new Packer();
            packer.packValueArray(val);
            return packer.toByteArray();
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public static byte[] pack(List<?> val) throws AerospikeException {
        try {
            Packer packer = new Packer();
            packer.packList(val);
            return packer.toByteArray();
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public static byte[] pack(Map<?, ?> val) throws AerospikeException {
        try {
            Packer packer = new Packer();
            packer.packMap(val);
            return packer.toByteArray();
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public static byte[] pack(List<? extends Map.Entry<?, ?>> val, MapOrder order) throws AerospikeException {
        try {
            Packer packer = new Packer();
            packer.packMap(val, order);
            return packer.toByteArray();
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public void packValueArray(Value[] values) {
        this.packArrayBegin(values.length);
        for (Value value : values) {
            value.pack(this);
        }
    }

    public void packValueList(List<Value> list) {
        this.packArrayBegin(list.size());
        for (Value value : list) {
            value.pack(this);
        }
    }

    public void packList(List<?> list) {
        this.packArrayBegin(list.size());
        for (Object obj : list) {
            this.packObject(obj);
        }
    }

    public void packArrayBegin(int size) {
        if (size < 16) {
            this.packByte(0x90 | size);
        } else if (size < 65536) {
            this.packShort(220, size);
        } else {
            this.packInt(221, size);
        }
    }

    public void packValueMap(Map<Value, Value> map) {
        this.packMapBegin(map.size());
        for (Map.Entry<Value, Value> entry : map.entrySet()) {
            entry.getKey().pack(this);
            entry.getValue().pack(this);
        }
    }

    public void packMap(Map<?, ?> map) {
        this.packMapBegin(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.packObject(entry.getKey());
            this.packObject(entry.getValue());
        }
    }

    public void packMap(List<? extends Map.Entry<?, ?>> list, MapOrder order) {
        int attr = order.attributes;
        if (attr > 0) {
            this.packMapBegin(list.size() + 1);
            this.packByte(199);
            this.packByte(0);
            this.packByte(attr);
            this.packByte(192);
        } else {
            this.packMapBegin(list.size());
        }
        for (Map.Entry<?, ?> entry : list) {
            this.packObject(entry.getKey());
            this.packObject(entry.getValue());
        }
    }

    public void packMapBegin(int size) {
        if (size < 16) {
            this.packByte(0x80 | size);
        } else if (size < 65536) {
            this.packShort(222, size);
        } else {
            this.packInt(223, size);
        }
    }

    public void packBytes(byte[] b) {
        this.packByteArrayBegin(b.length);
        this.packByteArray(b, 0, b.length);
    }

    public void packParticleBytes(byte[] b) {
        this.packByteArrayBegin(b.length + 1);
        this.packByte(4);
        this.packByteArray(b, 0, b.length);
    }

    public void packParticleBytes(byte[] b, int type) {
        this.packByteArrayBegin(b.length + 1);
        this.packByte(type);
        this.packByteArray(b, 0, b.length);
    }

    public void packParticleBytes(byte[] b, int offset, int length) {
        this.packByteArrayBegin(length + 1);
        this.packByte(4);
        this.packByteArray(b, offset, length);
    }

    public void packBlob(Object val) throws AerospikeException {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream ostream = new ObjectOutputStream(bstream);
            ostream.writeObject(val);
            ostream.close();
        }
        catch (IOException ioe) {
            throw new AerospikeException.Serialize(ioe);
        }
        byte[] bytes = bstream.toByteArray();
        this.packByteArrayBegin(bytes.length + 1);
        this.packByte(7);
        this.packByteArray(bytes, 0, bytes.length);
    }

    public void packGeoJSON(String val) {
        byte[] buffer = Buffer.stringToUtf8(val);
        this.packByteArrayBegin(buffer.length + 1);
        this.packByte(23);
        this.packByteArray(buffer, 0, buffer.length);
    }

    private void packByteArrayBegin(int size) {
        this.packStringBegin(size);
    }

    public void packObject(Object obj) {
        if (obj == null) {
            this.packNil();
            return;
        }
        if (obj instanceof Value) {
            Value value = (Value)obj;
            value.pack(this);
            return;
        }
        if (obj instanceof byte[]) {
            this.packParticleBytes((byte[])obj);
            return;
        }
        if (obj instanceof String) {
            this.packParticleString((String)obj);
            return;
        }
        if (obj instanceof Integer) {
            this.packInt((Integer)obj);
            return;
        }
        if (obj instanceof Long) {
            this.packLong((Long)obj);
            return;
        }
        if (obj instanceof Double) {
            this.packDouble((Double)obj);
            return;
        }
        if (obj instanceof Float) {
            this.packFloat(((Float)obj).floatValue());
            return;
        }
        if (obj instanceof Boolean) {
            this.packBoolean((Boolean)obj);
            return;
        }
        if (obj instanceof List) {
            this.packList((List)obj);
            return;
        }
        if (obj instanceof Map) {
            this.packMap((Map)obj);
            return;
        }
        if (obj instanceof ByteBuffer) {
            this.packByteBuffer((ByteBuffer)obj);
            return;
        }
        this.packBlob(obj);
    }

    public void packByteBuffer(ByteBuffer bb) {
        byte[] b = bb.array();
        this.packParticleBytes(b);
    }

    public void packLong(long val) {
        if (val >= 0L) {
            if (val < 128L) {
                this.packByte((int)val);
                return;
            }
            if (val < 256L) {
                this.packByte(204, (int)val);
                return;
            }
            if (val < 65536L) {
                this.packShort(205, (int)val);
                return;
            }
            if (val < 0x100000000L) {
                this.packInt(206, (int)val);
                return;
            }
            this.packLong(207, val);
        } else {
            if (val >= -32L) {
                this.packByte(0xE0 | (int)val + 32);
                return;
            }
            if (val >= -128L) {
                this.packByte(208, (int)val);
                return;
            }
            if (val >= -32768L) {
                this.packShort(209, (int)val);
                return;
            }
            if (val >= Integer.MIN_VALUE) {
                this.packInt(210, (int)val);
                return;
            }
            this.packLong(211, val);
        }
    }

    public void packInt(int val) {
        if (val >= 0) {
            if (val < 128) {
                this.packByte(val);
                return;
            }
            if (val < 256) {
                this.packByte(204, val);
                return;
            }
            if (val < 65536) {
                this.packShort(205, val);
                return;
            }
            this.packInt(206, val);
        } else {
            if (val >= -32) {
                this.packByte(0xE0 | val + 32);
                return;
            }
            if (val >= -128) {
                this.packByte(208, val);
                return;
            }
            if (val >= Short.MIN_VALUE) {
                this.packShort(209, val);
                return;
            }
            this.packInt(210, val);
        }
    }

    public void packString(String val) {
        int size = Buffer.estimateSizeUtf8(val);
        this.packStringBegin(size);
        if (this.offset + size > this.buffer.length) {
            this.resize(size);
        }
        this.offset += Buffer.stringToUtf8(val, this.buffer, this.offset);
    }

    public void packParticleString(String val) {
        int size = Buffer.estimateSizeUtf8(val) + 1;
        this.packStringBegin(size);
        if (this.offset + size > this.buffer.length) {
            this.resize(size);
        }
        this.buffer[this.offset++] = 3;
        this.offset += Buffer.stringToUtf8(val, this.buffer, this.offset);
    }

    private void packStringBegin(int size) {
        if (size < 32) {
            this.packByte(0xA0 | size);
        } else if (size < 256) {
            this.packByte(217, size);
        } else if (size < 65536) {
            this.packShort(218, size);
        } else {
            this.packInt(219, size);
        }
    }

    public void packByteArray(byte[] src, int srcOffset, int srcLength) {
        if (this.offset + srcLength > this.buffer.length) {
            this.resize(srcLength);
        }
        System.arraycopy(src, srcOffset, this.buffer, this.offset, srcLength);
        this.offset += srcLength;
    }

    public void packDouble(double val) {
        if (this.offset + 9 > this.buffer.length) {
            this.resize(9);
        }
        this.buffer[this.offset++] = -53;
        Buffer.longToBytes(Double.doubleToLongBits(val), this.buffer, this.offset);
        this.offset += 8;
    }

    public void packFloat(float val) {
        if (this.offset + 5 > this.buffer.length) {
            this.resize(5);
        }
        this.buffer[this.offset++] = -54;
        Buffer.intToBytes(Float.floatToIntBits(val), this.buffer, this.offset);
        this.offset += 4;
    }

    private void packLong(int type, long val) {
        if (this.offset + 9 > this.buffer.length) {
            this.resize(9);
        }
        this.buffer[this.offset++] = (byte)type;
        Buffer.longToBytes(val, this.buffer, this.offset);
        this.offset += 8;
    }

    private void packInt(int type, int val) {
        if (this.offset + 5 > this.buffer.length) {
            this.resize(5);
        }
        this.buffer[this.offset++] = (byte)type;
        Buffer.intToBytes(val, this.buffer, this.offset);
        this.offset += 4;
    }

    private void packShort(int type, int val) {
        if (this.offset + 3 > this.buffer.length) {
            this.resize(3);
        }
        this.buffer[this.offset++] = (byte)type;
        Buffer.shortToBytes(val, this.buffer, this.offset);
        this.offset += 2;
    }

    public void packRawShort(int val) {
        if (this.offset + 2 > this.buffer.length) {
            this.resize(2);
        }
        Buffer.shortToBytes(val, this.buffer, this.offset);
        this.offset += 2;
    }

    private void packByte(int type, int val) {
        if (this.offset + 2 > this.buffer.length) {
            this.resize(2);
        }
        this.buffer[this.offset++] = (byte)type;
        this.buffer[this.offset++] = (byte)val;
    }

    public void packBoolean(boolean val) {
        if (this.offset + 1 > this.buffer.length) {
            this.resize(1);
        }
        this.buffer[this.offset++] = val ? -61 : -62;
    }

    public void packNil() {
        if (this.offset >= this.buffer.length) {
            this.resize(1);
        }
        this.buffer[this.offset++] = -64;
    }

    public void packInfinity() {
        if (this.offset + 3 > this.buffer.length) {
            this.resize(3);
        }
        this.buffer[this.offset++] = -44;
        this.buffer[this.offset++] = -1;
        this.buffer[this.offset++] = 1;
    }

    public void packWildcard() {
        if (this.offset + 3 > this.buffer.length) {
            this.resize(3);
        }
        this.buffer[this.offset++] = -44;
        this.buffer[this.offset++] = -1;
        this.buffer[this.offset++] = 0;
    }

    public void packByte(int val) {
        if (this.offset >= this.buffer.length) {
            this.resize(1);
        }
        this.buffer[this.offset++] = (byte)val;
    }

    private void resize(int size) {
        if (this.bufferList == null) {
            this.bufferList = new ArrayList();
        }
        this.bufferList.add(new BufferItem(this.buffer, this.offset));
        if (size < this.buffer.length) {
            size = this.buffer.length;
        }
        this.buffer = new byte[size];
        this.offset = 0;
    }

    public byte[] toByteArray() {
        if (this.bufferList != null) {
            int size = this.offset;
            for (BufferItem item : this.bufferList) {
                size += item.length;
            }
            byte[] target = new byte[size];
            size = 0;
            for (BufferItem item : this.bufferList) {
                System.arraycopy(item.buffer, 0, target, size, item.length);
                size += item.length;
            }
            System.arraycopy(this.buffer, 0, target, size, this.offset);
            return target;
        }
        byte[] target = new byte[this.offset];
        System.arraycopy(this.buffer, 0, target, 0, this.offset);
        return target;
    }

    private static final class BufferItem {
        private byte[] buffer;
        private int length;

        private BufferItem(byte[] buffer, int length) {
            this.buffer = buffer;
            this.length = length;
        }
    }
}

