/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Bin;
import com.aerospike.client.Host;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Info;
import com.aerospike.client.Key;
import com.aerospike.client.Language;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.Value;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.admin.Privilege;
import com.aerospike.client.admin.Role;
import com.aerospike.client.admin.User;
import com.aerospike.client.async.AsyncBatch;
import com.aerospike.client.async.AsyncDelete;
import com.aerospike.client.async.AsyncExecute;
import com.aerospike.client.async.AsyncExists;
import com.aerospike.client.async.AsyncIndexTask;
import com.aerospike.client.async.AsyncInfoCommand;
import com.aerospike.client.async.AsyncOperate;
import com.aerospike.client.async.AsyncQueryExecutor;
import com.aerospike.client.async.AsyncQueryPartitionExecutor;
import com.aerospike.client.async.AsyncRead;
import com.aerospike.client.async.AsyncReadHeader;
import com.aerospike.client.async.AsyncScanPartitionExecutor;
import com.aerospike.client.async.AsyncTouch;
import com.aerospike.client.async.AsyncWrite;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.ClusterStats;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Batch;
import com.aerospike.client.command.BatchExecutor;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.BatchNodeList;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.DeleteCommand;
import com.aerospike.client.command.ExecuteCommand;
import com.aerospike.client.command.Executor;
import com.aerospike.client.command.ExistsCommand;
import com.aerospike.client.command.OperateArgs;
import com.aerospike.client.command.OperateCommand;
import com.aerospike.client.command.ReadCommand;
import com.aerospike.client.command.ReadHeaderCommand;
import com.aerospike.client.command.RegisterCommand;
import com.aerospike.client.command.ScanExecutor;
import com.aerospike.client.command.TouchCommand;
import com.aerospike.client.command.WriteCommand;
import com.aerospike.client.exp.Expression;
import com.aerospike.client.listener.BatchListListener;
import com.aerospike.client.listener.BatchSequenceListener;
import com.aerospike.client.listener.ClusterStatsListener;
import com.aerospike.client.listener.DeleteListener;
import com.aerospike.client.listener.ExecuteListener;
import com.aerospike.client.listener.ExistsArrayListener;
import com.aerospike.client.listener.ExistsListener;
import com.aerospike.client.listener.ExistsSequenceListener;
import com.aerospike.client.listener.IndexListener;
import com.aerospike.client.listener.InfoListener;
import com.aerospike.client.listener.RecordArrayListener;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.AdminPolicy;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.PartitionFilter;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.query.QueryAggregateExecutor;
import com.aerospike.client.query.QueryPartitionExecutor;
import com.aerospike.client.query.QueryRecordExecutor;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.ResultSet;
import com.aerospike.client.query.ServerCommand;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.ExecuteTask;
import com.aerospike.client.task.IndexTask;
import com.aerospike.client.task.RegisterTask;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class AerospikeClient
implements IAerospikeClient,
Closeable {
    protected Cluster cluster;
    public final Policy readPolicyDefault;
    public final WritePolicy writePolicyDefault;
    public final ScanPolicy scanPolicyDefault;
    public final QueryPolicy queryPolicyDefault;
    public final BatchPolicy batchPolicyDefault;
    public final InfoPolicy infoPolicyDefault;
    private final WritePolicy operatePolicyReadDefault;

    public AerospikeClient(String hostname, int port) throws AerospikeException {
        this(new ClientPolicy(), new Host(hostname, port));
    }

    public AerospikeClient(ClientPolicy policy, String hostname, int port) throws AerospikeException {
        this(policy, new Host(hostname, port));
    }

    public AerospikeClient(ClientPolicy policy, Host ... hosts) throws AerospikeException {
        if (policy == null) {
            policy = new ClientPolicy();
        }
        this.readPolicyDefault = policy.readPolicyDefault;
        this.writePolicyDefault = policy.writePolicyDefault;
        this.scanPolicyDefault = policy.scanPolicyDefault;
        this.queryPolicyDefault = policy.queryPolicyDefault;
        this.batchPolicyDefault = policy.batchPolicyDefault;
        this.infoPolicyDefault = policy.infoPolicyDefault;
        this.operatePolicyReadDefault = new WritePolicy(this.readPolicyDefault);
        this.cluster = new Cluster(policy, hosts);
    }

    protected AerospikeClient(ClientPolicy policy) {
        if (policy != null) {
            this.readPolicyDefault = policy.readPolicyDefault;
            this.writePolicyDefault = policy.writePolicyDefault;
            this.scanPolicyDefault = policy.scanPolicyDefault;
            this.queryPolicyDefault = policy.queryPolicyDefault;
            this.batchPolicyDefault = policy.batchPolicyDefault;
            this.infoPolicyDefault = policy.infoPolicyDefault;
            this.operatePolicyReadDefault = new WritePolicy(this.readPolicyDefault);
        } else {
            this.readPolicyDefault = new Policy();
            this.writePolicyDefault = new WritePolicy();
            this.scanPolicyDefault = new ScanPolicy();
            this.queryPolicyDefault = new QueryPolicy();
            this.batchPolicyDefault = new BatchPolicy();
            this.infoPolicyDefault = new InfoPolicy();
            this.operatePolicyReadDefault = new WritePolicy(this.readPolicyDefault);
        }
    }

    @Override
    public final Policy getReadPolicyDefault() {
        return this.readPolicyDefault;
    }

    @Override
    public final WritePolicy getWritePolicyDefault() {
        return this.writePolicyDefault;
    }

    @Override
    public final ScanPolicy getScanPolicyDefault() {
        return this.scanPolicyDefault;
    }

    @Override
    public final QueryPolicy getQueryPolicyDefault() {
        return this.queryPolicyDefault;
    }

    @Override
    public final BatchPolicy getBatchPolicyDefault() {
        return this.batchPolicyDefault;
    }

    @Override
    public final InfoPolicy getInfoPolicyDefault() {
        return this.infoPolicyDefault;
    }

    @Override
    public void close() {
        this.cluster.close();
    }

    @Override
    public final boolean isConnected() {
        return this.cluster.isConnected();
    }

    @Override
    public final Node[] getNodes() {
        return this.cluster.getNodes();
    }

    @Override
    public final List<String> getNodeNames() {
        Node[] nodes = this.cluster.getNodes();
        ArrayList<String> names = new ArrayList<String>(nodes.length);
        for (Node node : nodes) {
            names.add(node.getName());
        }
        return names;
    }

    @Override
    public final Node getNode(String nodeName) throws AerospikeException.InvalidNode {
        return this.cluster.getNode(nodeName);
    }

    @Override
    public final ClusterStats getClusterStats() {
        return this.cluster.getStats();
    }

    public final void getClusterStats(ClusterStatsListener listener) {
        this.cluster.getStats(listener);
    }

    @Override
    public final Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public final void put(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        WriteCommand command = new WriteCommand(this.cluster, policy, key, bins, Operation.Type.WRITE);
        command.execute();
    }

    @Override
    public final void put(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(this.cluster, listener, policy, key, bins, Operation.Type.WRITE);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final void append(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        WriteCommand command = new WriteCommand(this.cluster, policy, key, bins, Operation.Type.APPEND);
        command.execute();
    }

    @Override
    public final void append(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(this.cluster, listener, policy, key, bins, Operation.Type.APPEND);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final void prepend(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        WriteCommand command = new WriteCommand(this.cluster, policy, key, bins, Operation.Type.PREPEND);
        command.execute();
    }

    @Override
    public final void prepend(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(this.cluster, listener, policy, key, bins, Operation.Type.PREPEND);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final void add(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        WriteCommand command = new WriteCommand(this.cluster, policy, key, bins, Operation.Type.ADD);
        command.execute();
    }

    @Override
    public final void add(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(this.cluster, listener, policy, key, bins, Operation.Type.ADD);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final boolean delete(WritePolicy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        DeleteCommand command = new DeleteCommand(this.cluster, policy, key);
        command.execute();
        return command.existed();
    }

    @Override
    public final void delete(EventLoop eventLoop, DeleteListener listener, WritePolicy policy, Key key) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncDelete command = new AsyncDelete(this.cluster, listener, policy, key);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final void truncate(InfoPolicy policy, String ns, String set, Calendar beforeLastUpdate) throws AerospikeException {
        String response;
        if (policy == null) {
            policy = this.infoPolicyDefault;
        }
        Node node = this.cluster.getRandomNode();
        StringBuilder sb = new StringBuilder(200);
        if (set != null) {
            sb.append("truncate:namespace=");
            sb.append(ns);
            sb.append(";set=");
            sb.append(set);
        } else {
            sb.append("truncate-namespace:namespace=");
            sb.append(ns);
        }
        if (beforeLastUpdate != null) {
            sb.append(";lut=");
            sb.append(beforeLastUpdate.getTimeInMillis() * 1000000L);
        }
        if (!(response = Info.request(policy, node, sb.toString())).equalsIgnoreCase("ok")) {
            throw new AerospikeException("Truncate failed: " + response);
        }
    }

    @Override
    public final void touch(WritePolicy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        TouchCommand command = new TouchCommand(this.cluster, policy, key);
        command.execute();
    }

    @Override
    public final void touch(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncTouch command = new AsyncTouch(this.cluster, listener, policy, key);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final boolean exists(Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        ExistsCommand command = new ExistsCommand(this.cluster, policy, key);
        command.execute();
        return command.exists();
    }

    @Override
    public final void exists(EventLoop eventLoop, ExistsListener listener, Policy policy, Key key) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        AsyncExists command = new AsyncExists(this.cluster, listener, policy, key);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final boolean[] exists(BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        boolean[] existsArray = new boolean[keys.length];
        BatchExecutor.execute(this.cluster, policy, keys, existsArray, null, null, null, 33);
        return existsArray;
    }

    @Override
    public final void exists(EventLoop eventLoop, ExistsArrayListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(keys, new boolean[0]);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.ExistsArrayExecutor(eventLoop, this.cluster, policy, keys, listener);
    }

    @Override
    public final void exists(EventLoop eventLoop, ExistsSequenceListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.ExistsSequenceExecutor(eventLoop, this.cluster, policy, keys, listener);
    }

    @Override
    public final Record get(Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        ReadCommand command = new ReadCommand(this.cluster, policy, key);
        command.execute();
        return command.getRecord();
    }

    @Override
    public final void get(EventLoop eventLoop, RecordListener listener, Policy policy, Key key) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        AsyncRead command = new AsyncRead(this.cluster, listener, policy, key, null);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final Record get(Policy policy, Key key, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        ReadCommand command = new ReadCommand(this.cluster, policy, key, binNames);
        command.execute();
        return command.getRecord();
    }

    @Override
    public final void get(EventLoop eventLoop, RecordListener listener, Policy policy, Key key, String ... binNames) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        AsyncRead command = new AsyncRead(this.cluster, listener, policy, key, binNames);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final Record getHeader(Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        ReadHeaderCommand command = new ReadHeaderCommand(this.cluster, policy, key);
        command.execute();
        return command.getRecord();
    }

    @Override
    public final void getHeader(EventLoop eventLoop, RecordListener listener, Policy policy, Key key) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        AsyncReadHeader command = new AsyncReadHeader(this.cluster, listener, policy, key);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final void get(BatchPolicy policy, List<BatchRead> records) throws AerospikeException {
        if (records.size() == 0) {
            return;
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        List<BatchNode> batchNodes = BatchNodeList.generate(this.cluster, policy, records);
        if (policy.maxConcurrentThreads == 1 || batchNodes.size() <= 1) {
            for (BatchNode batchNode : batchNodes) {
                Batch.ReadListCommand command = new Batch.ReadListCommand(this.cluster, null, batchNode, policy, records);
                command.execute();
            }
        } else {
            Executor executor = new Executor(this.cluster, batchNodes.size());
            for (BatchNode batchNode : batchNodes) {
                Batch.ReadListCommand command = new Batch.ReadListCommand(this.cluster, executor, batchNode, policy, records);
                executor.addCommand(command);
            }
            executor.execute(policy.maxConcurrentThreads);
        }
    }

    @Override
    public final void get(EventLoop eventLoop, BatchListListener listener, BatchPolicy policy, List<BatchRead> records) throws AerospikeException {
        if (records.size() == 0) {
            listener.onSuccess(records);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.ReadListExecutor(eventLoop, this.cluster, policy, listener, records);
    }

    @Override
    public final void get(EventLoop eventLoop, BatchSequenceListener listener, BatchPolicy policy, List<BatchRead> records) throws AerospikeException {
        if (records.size() == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.ReadSequenceExecutor(eventLoop, this.cluster, policy, listener, records);
    }

    @Override
    public final Record[] get(BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        Record[] records = new Record[keys.length];
        BatchExecutor.execute(this.cluster, policy, keys, null, records, null, null, 3);
        return records;
    }

    @Override
    public final void get(EventLoop eventLoop, RecordArrayListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(keys, new Record[0]);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.GetArrayExecutor(eventLoop, this.cluster, policy, listener, keys, null, null, 3, false);
    }

    @Override
    public final void get(EventLoop eventLoop, RecordSequenceListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.GetSequenceExecutor(eventLoop, this.cluster, policy, listener, keys, null, null, 3, false);
    }

    @Override
    public final Record[] get(BatchPolicy policy, Key[] keys, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        Record[] records = new Record[keys.length];
        BatchExecutor.execute(this.cluster, policy, keys, null, records, binNames, null, 1);
        return records;
    }

    @Override
    public final void get(EventLoop eventLoop, RecordArrayListener listener, BatchPolicy policy, Key[] keys, String ... binNames) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(keys, new Record[0]);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.GetArrayExecutor(eventLoop, this.cluster, policy, listener, keys, binNames, null, 1, false);
    }

    @Override
    public final void get(EventLoop eventLoop, RecordSequenceListener listener, BatchPolicy policy, Key[] keys, String ... binNames) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.GetSequenceExecutor(eventLoop, this.cluster, policy, listener, keys, binNames, null, 1, false);
    }

    @Override
    public final Record[] get(BatchPolicy policy, Key[] keys, Operation ... operations) throws AerospikeException {
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        Record[] records = new Record[keys.length];
        BatchExecutor.execute(this.cluster, policy, keys, null, records, null, operations, 1);
        return records;
    }

    @Override
    public final void get(EventLoop eventLoop, RecordArrayListener listener, BatchPolicy policy, Key[] keys, Operation ... operations) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(keys, new Record[0]);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.GetArrayExecutor(eventLoop, this.cluster, policy, listener, keys, null, operations, 1, true);
    }

    @Override
    public final void get(EventLoop eventLoop, RecordSequenceListener listener, BatchPolicy policy, Key[] keys, Operation ... operations) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.GetSequenceExecutor(eventLoop, this.cluster, policy, listener, keys, null, operations, 1, true);
    }

    @Override
    public final Record[] getHeader(BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        Record[] records = new Record[keys.length];
        BatchExecutor.execute(this.cluster, policy, keys, null, records, null, null, 33);
        return records;
    }

    @Override
    public final void getHeader(EventLoop eventLoop, RecordArrayListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(keys, new Record[0]);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.GetArrayExecutor(eventLoop, this.cluster, policy, listener, keys, null, null, 33, false);
    }

    @Override
    public final void getHeader(EventLoop eventLoop, RecordSequenceListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.GetSequenceExecutor(eventLoop, this.cluster, policy, listener, keys, null, null, 33, false);
    }

    @Override
    public final Record operate(WritePolicy policy, Key key, Operation ... operations) throws AerospikeException {
        OperateArgs args = new OperateArgs(this.cluster, policy, this.writePolicyDefault, this.operatePolicyReadDefault, key, operations);
        OperateCommand command = new OperateCommand(this.cluster, key, args);
        command.execute();
        return command.getRecord();
    }

    @Override
    public final void operate(EventLoop eventLoop, RecordListener listener, WritePolicy policy, Key key, Operation ... operations) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        OperateArgs args = new OperateArgs(this.cluster, policy, this.writePolicyDefault, this.operatePolicyReadDefault, key, operations);
        AsyncOperate command = new AsyncOperate(listener, key, args);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final void scanAll(ScanPolicy policy, String namespace, String setName, ScanCallback callback, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        PartitionTracker tracker = new PartitionTracker(policy, nodes);
        ScanExecutor.scanPartitions(this.cluster, policy, namespace, setName, binNames, callback, tracker);
    }

    @Override
    public final void scanAll(EventLoop eventLoop, RecordSequenceListener listener, ScanPolicy policy, String namespace, String setName, String ... binNames) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        PartitionTracker tracker = new PartitionTracker(policy, nodes);
        new AsyncScanPartitionExecutor(eventLoop, this.cluster, policy, listener, namespace, setName, binNames, tracker);
    }

    @Override
    public final void scanNode(ScanPolicy policy, String nodeName, String namespace, String setName, ScanCallback callback, String ... binNames) throws AerospikeException {
        Node node = this.cluster.getNode(nodeName);
        this.scanNode(policy, node, namespace, setName, callback, binNames);
    }

    @Override
    public final void scanNode(ScanPolicy policy, Node node, String namespace, String setName, ScanCallback callback, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        PartitionTracker tracker = new PartitionTracker(policy, node);
        ScanExecutor.scanPartitions(this.cluster, policy, namespace, setName, binNames, callback, tracker);
    }

    @Override
    public final void scanPartitions(ScanPolicy policy, PartitionFilter partitionFilter, String namespace, String setName, ScanCallback callback, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        PartitionTracker tracker = new PartitionTracker(policy, nodes, partitionFilter);
        ScanExecutor.scanPartitions(this.cluster, policy, namespace, setName, binNames, callback, tracker);
    }

    @Override
    public final void scanPartitions(EventLoop eventLoop, RecordSequenceListener listener, ScanPolicy policy, PartitionFilter partitionFilter, String namespace, String setName, String ... binNames) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        PartitionTracker tracker = new PartitionTracker(policy, nodes, partitionFilter);
        new AsyncScanPartitionExecutor(eventLoop, this.cluster, policy, listener, namespace, setName, binNames, tracker);
    }

    @Override
    public final RegisterTask register(Policy policy, String clientPath, String serverPath, Language language) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        File file = new File(clientPath);
        byte[] bytes = Util.readFile(file);
        return RegisterCommand.register(this.cluster, policy, bytes, serverPath, language);
    }

    @Override
    public final RegisterTask register(Policy policy, ClassLoader resourceLoader, String resourcePath, String serverPath, Language language) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        byte[] bytes = Util.readResource(resourceLoader, resourcePath);
        return RegisterCommand.register(this.cluster, policy, bytes, serverPath, language);
    }

    @Override
    public final RegisterTask registerUdfString(Policy policy, String code, String serverPath, Language language) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        byte[] bytes = Buffer.stringToUtf8(code);
        return RegisterCommand.register(this.cluster, policy, bytes, serverPath, language);
    }

    @Override
    public final void removeUdf(InfoPolicy policy, String serverPath) throws AerospikeException {
        if (policy == null) {
            policy = this.infoPolicyDefault;
        }
        String command = "udf-remove:filename=" + serverPath;
        Node node = this.cluster.getRandomNode();
        String response = Info.request(policy, node, command);
        if (response.equalsIgnoreCase("ok")) {
            return;
        }
        if (response.startsWith("error=file_not_found")) {
            return;
        }
        throw new AerospikeException("Remove UDF failed: " + response);
    }

    @Override
    public final Object execute(WritePolicy policy, Key key, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        ExecuteCommand command = new ExecuteCommand(this.cluster, policy, key, packageName, functionName, functionArgs);
        command.execute();
        Record record = command.getRecord();
        if (record == null || record.bins == null) {
            return null;
        }
        Map<String, Object> map = record.bins;
        Object obj = map.get("SUCCESS");
        if (obj != null) {
            return obj;
        }
        if (map.containsKey("SUCCESS")) {
            return null;
        }
        obj = map.get("FAILURE");
        if (obj != null) {
            throw new AerospikeException(obj.toString());
        }
        throw new AerospikeException("Invalid UDF return value");
    }

    @Override
    public final void execute(EventLoop eventLoop, ExecuteListener listener, WritePolicy policy, Key key, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncExecute command = new AsyncExecute(this.cluster, listener, policy, key, packageName, functionName, functionArgs);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final ExecuteTask execute(WritePolicy policy, Statement statement, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        statement.setAggregateFunction(packageName, functionName, functionArgs);
        statement.prepare(false);
        Node[] nodes = this.cluster.validateNodes();
        Executor executor = new Executor(this.cluster, nodes.length);
        for (Node node : nodes) {
            ServerCommand command = new ServerCommand(this.cluster, node, policy, statement);
            executor.addCommand(command);
        }
        executor.execute(nodes.length);
        return new ExecuteTask(this.cluster, policy, statement);
    }

    @Override
    public final ExecuteTask execute(WritePolicy policy, Statement statement, Operation ... operations) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        if (operations.length > 0) {
            statement.setOperations(operations);
        }
        statement.prepare(false);
        Node[] nodes = this.cluster.validateNodes();
        Executor executor = new Executor(this.cluster, nodes.length);
        for (Node node : nodes) {
            ServerCommand command = new ServerCommand(this.cluster, node, policy, statement);
            executor.addCommand(command);
        }
        executor.execute(nodes.length);
        return new ExecuteTask(this.cluster, policy, statement);
    }

    @Override
    public final RecordSet query(QueryPolicy policy, Statement statement) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        if (statement.getFilter() == null) {
            PartitionTracker tracker = new PartitionTracker(policy, nodes);
            QueryPartitionExecutor executor = new QueryPartitionExecutor(this.cluster, policy, statement, nodes.length, tracker);
            return executor.getRecordSet();
        }
        QueryRecordExecutor executor = new QueryRecordExecutor(this.cluster, policy, statement, nodes);
        executor.execute();
        return executor.getRecordSet();
    }

    @Override
    public final void query(EventLoop eventLoop, RecordSequenceListener listener, QueryPolicy policy, Statement statement) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        if (statement.getFilter() == null) {
            PartitionTracker tracker = new PartitionTracker(policy, nodes);
            new AsyncQueryPartitionExecutor(eventLoop, listener, this.cluster, policy, statement, tracker);
        } else {
            new AsyncQueryExecutor(eventLoop, listener, this.cluster, policy, statement, nodes);
        }
    }

    @Override
    public final RecordSet queryNode(QueryPolicy policy, Statement statement, Node node) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        if (statement.getFilter() == null) {
            PartitionTracker tracker = new PartitionTracker(policy, node);
            QueryPartitionExecutor executor = new QueryPartitionExecutor(this.cluster, policy, statement, 1, tracker);
            return executor.getRecordSet();
        }
        QueryRecordExecutor executor = new QueryRecordExecutor(this.cluster, policy, statement, new Node[]{node});
        executor.execute();
        return executor.getRecordSet();
    }

    @Override
    public final RecordSet queryPartitions(QueryPolicy policy, Statement statement, PartitionFilter partitionFilter) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        if (statement.getFilter() == null) {
            PartitionTracker tracker = new PartitionTracker(policy, nodes, partitionFilter);
            QueryPartitionExecutor executor = new QueryPartitionExecutor(this.cluster, policy, statement, nodes.length, tracker);
            return executor.getRecordSet();
        }
        throw new AerospikeException(4, "queryPartitions() not supported");
    }

    @Override
    public final void queryPartitions(EventLoop eventLoop, RecordSequenceListener listener, QueryPolicy policy, Statement statement, PartitionFilter partitionFilter) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        if (statement.getFilter() != null) {
            throw new AerospikeException(4, "queryPartitions() not supported");
        }
        PartitionTracker tracker = new PartitionTracker(policy, nodes, partitionFilter);
        new AsyncQueryPartitionExecutor(eventLoop, listener, this.cluster, policy, statement, tracker);
    }

    @Override
    public final ResultSet queryAggregate(QueryPolicy policy, Statement statement, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        statement.setAggregateFunction(packageName, functionName, functionArgs);
        return this.queryAggregate(policy, statement);
    }

    @Override
    public final ResultSet queryAggregate(QueryPolicy policy, Statement statement) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        statement.prepare(true);
        QueryAggregateExecutor executor = new QueryAggregateExecutor(this.cluster, policy, statement, nodes);
        return executor.getResultSet();
    }

    @Override
    public final ResultSet queryAggregateNode(QueryPolicy policy, Statement statement, Node node) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        statement.prepare(true);
        QueryAggregateExecutor executor = new QueryAggregateExecutor(this.cluster, policy, statement, new Node[]{node});
        return executor.getResultSet();
    }

    @Override
    public final IndexTask createIndex(Policy policy, String namespace, String setName, String indexName, String binName, IndexType indexType) throws AerospikeException {
        return this.createIndex(policy, namespace, setName, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public final IndexTask createIndex(Policy policy, String namespace, String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) throws AerospikeException {
        String command;
        String response;
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        if ((response = this.sendInfoCommand(policy, command = AerospikeClient.buildCreateIndexInfoCommand(namespace, setName, indexName, binName, indexType, indexCollectionType))).equalsIgnoreCase("OK")) {
            return new IndexTask(this.cluster, policy, namespace, indexName, true);
        }
        int code = AerospikeClient.parseIndexErrorCode(response);
        throw new AerospikeException(code, "Create index failed: " + response);
    }

    @Override
    public final void createIndex(EventLoop eventLoop, IndexListener listener, Policy policy, String namespace, String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        String command = AerospikeClient.buildCreateIndexInfoCommand(namespace, setName, indexName, binName, indexType, indexCollectionType);
        this.sendIndexInfoCommand(eventLoop, listener, policy, namespace, indexName, command, true);
    }

    @Override
    public final IndexTask dropIndex(Policy policy, String namespace, String setName, String indexName) throws AerospikeException {
        String command;
        String response;
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        if ((response = this.sendInfoCommand(policy, command = AerospikeClient.buildDropIndexInfoCommand(namespace, setName, indexName))).equalsIgnoreCase("OK")) {
            return new IndexTask(this.cluster, policy, namespace, indexName, false);
        }
        int code = AerospikeClient.parseIndexErrorCode(response);
        throw new AerospikeException(code, "Drop index failed: " + response);
    }

    @Override
    public final void dropIndex(EventLoop eventLoop, IndexListener listener, Policy policy, String namespace, String setName, String indexName) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        String command = AerospikeClient.buildDropIndexInfoCommand(namespace, setName, indexName);
        this.sendIndexInfoCommand(eventLoop, listener, policy, namespace, indexName, command, false);
    }

    @Override
    public final void info(EventLoop eventLoop, InfoListener listener, InfoPolicy policy, Node node, String ... commands) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.infoPolicyDefault;
        }
        if (node == null) {
            node = this.cluster.getRandomNode();
        }
        AsyncInfoCommand command = new AsyncInfoCommand(listener, policy, node, commands);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final void setXDRFilter(InfoPolicy policy, String datacenter, String namespace, Expression filter) throws AerospikeException {
        if (policy == null) {
            policy = this.infoPolicyDefault;
        }
        String filterString = filter != null ? filter.getBase64() : "null";
        String command = "xdr-set-filter:dc=" + datacenter + ";namespace=" + namespace + ";exp=" + filterString;
        Node node = this.cluster.getRandomNode();
        String response = Info.request(policy, node, command);
        if (response.equalsIgnoreCase("ok")) {
            return;
        }
        int code = AerospikeClient.parseIndexErrorCode(response);
        throw new AerospikeException(code, "xdr-set-filter failed: " + response);
    }

    @Override
    public final void createUser(AdminPolicy policy, String user, String password, List<String> roles) throws AerospikeException {
        String hash = AdminCommand.hashPassword(password);
        AdminCommand command = new AdminCommand();
        command.createUser(this.cluster, policy, user, hash, roles);
    }

    @Override
    public final void dropUser(AdminPolicy policy, String user) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.dropUser(this.cluster, policy, user);
    }

    @Override
    public final void changePassword(AdminPolicy policy, String user, String password) throws AerospikeException {
        if (this.cluster.getUser() == null) {
            throw new AerospikeException("Invalid user");
        }
        byte[] userBytes = Buffer.stringToUtf8(user);
        byte[] passwordBytes = Buffer.stringToUtf8(password);
        String hash = AdminCommand.hashPassword(password);
        byte[] hashBytes = Buffer.stringToUtf8(hash);
        AdminCommand command = new AdminCommand();
        if (Arrays.equals(userBytes, this.cluster.getUser())) {
            command.changePassword(this.cluster, policy, userBytes, hash);
        } else {
            command.setPassword(this.cluster, policy, userBytes, hash);
        }
        this.cluster.changePassword(userBytes, passwordBytes, hashBytes);
    }

    @Override
    public final void grantRoles(AdminPolicy policy, String user, List<String> roles) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.grantRoles(this.cluster, policy, user, roles);
    }

    @Override
    public final void revokeRoles(AdminPolicy policy, String user, List<String> roles) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.revokeRoles(this.cluster, policy, user, roles);
    }

    @Override
    public final void createRole(AdminPolicy policy, String roleName, List<Privilege> privileges) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.createRole(this.cluster, policy, roleName, privileges);
    }

    @Override
    public final void createRole(AdminPolicy policy, String roleName, List<Privilege> privileges, List<String> whitelist) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.createRole(this.cluster, policy, roleName, privileges, whitelist, 0, 0);
    }

    @Override
    public final void createRole(AdminPolicy policy, String roleName, List<Privilege> privileges, List<String> whitelist, int readQuota, int writeQuota) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.createRole(this.cluster, policy, roleName, privileges, whitelist, readQuota, writeQuota);
    }

    @Override
    public final void dropRole(AdminPolicy policy, String roleName) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.dropRole(this.cluster, policy, roleName);
    }

    @Override
    public final void grantPrivileges(AdminPolicy policy, String roleName, List<Privilege> privileges) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.grantPrivileges(this.cluster, policy, roleName, privileges);
    }

    @Override
    public final void revokePrivileges(AdminPolicy policy, String roleName, List<Privilege> privileges) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.revokePrivileges(this.cluster, policy, roleName, privileges);
    }

    @Override
    public final void setWhitelist(AdminPolicy policy, String roleName, List<String> whitelist) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.setWhitelist(this.cluster, policy, roleName, whitelist);
    }

    @Override
    public final void setQuotas(AdminPolicy policy, String roleName, int readQuota, int writeQuota) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.setQuotas(this.cluster, policy, roleName, readQuota, writeQuota);
    }

    @Override
    public final User queryUser(AdminPolicy policy, String user) throws AerospikeException {
        AdminCommand.UserCommand command = new AdminCommand.UserCommand(1);
        return command.queryUser(this.cluster, policy, user);
    }

    @Override
    public final List<User> queryUsers(AdminPolicy policy) throws AerospikeException {
        AdminCommand.UserCommand command = new AdminCommand.UserCommand(100);
        return command.queryUsers(this.cluster, policy);
    }

    @Override
    public final Role queryRole(AdminPolicy policy, String roleName) throws AerospikeException {
        AdminCommand.RoleCommand command = new AdminCommand.RoleCommand(1);
        return command.queryRole(this.cluster, policy, roleName);
    }

    @Override
    public final List<Role> queryRoles(AdminPolicy policy) throws AerospikeException {
        AdminCommand.RoleCommand command = new AdminCommand.RoleCommand(100);
        return command.queryRoles(this.cluster, policy);
    }

    private static String buildCreateIndexInfoCommand(String namespace, String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        StringBuilder sb = new StringBuilder(500);
        sb.append("sindex-create:ns=");
        sb.append(namespace);
        if (setName != null && setName.length() > 0) {
            sb.append(";set=");
            sb.append(setName);
        }
        sb.append(";indexname=");
        sb.append(indexName);
        sb.append(";numbins=1");
        if (indexCollectionType != IndexCollectionType.DEFAULT) {
            sb.append(";indextype=");
            sb.append((Object)indexCollectionType);
        }
        sb.append(";indexdata=");
        sb.append(binName);
        sb.append(",");
        sb.append((Object)indexType);
        sb.append(";priority=normal");
        return sb.toString();
    }

    private static String buildDropIndexInfoCommand(String namespace, String setName, String indexName) {
        StringBuilder sb = new StringBuilder(500);
        sb.append("sindex-delete:ns=");
        sb.append(namespace);
        if (setName != null && setName.length() > 0) {
            sb.append(";set=");
            sb.append(setName);
        }
        sb.append(";indexname=");
        sb.append(indexName);
        return sb.toString();
    }

    private String sendInfoCommand(Policy policy, String command) {
        Info info;
        Node node = this.cluster.getRandomNode();
        Connection conn = node.getConnection(policy.connectTimeout, policy.socketTimeout);
        try {
            info = new Info(conn, command);
            node.putConnection(conn);
        }
        catch (RuntimeException re) {
            node.closeConnection(conn);
            throw re;
        }
        return info.getValue();
    }

    private void sendIndexInfoCommand(EventLoop eventLoop, final IndexListener listener, Policy policy, final String namespace, final String indexName, String command, final boolean isCreate) {
        this.info(eventLoop, new InfoListener(){

            @Override
            public void onSuccess(Map<String, String> map) {
                String response = map.values().iterator().next();
                if (response.equalsIgnoreCase("OK")) {
                    listener.onSuccess(new AsyncIndexTask(AerospikeClient.this, namespace, indexName, isCreate));
                } else {
                    int code = AerospikeClient.parseIndexErrorCode(response);
                    String type = isCreate ? "Create" : "Drop";
                    listener.onFailure(new AerospikeException(code, type + " index failed: " + response));
                }
            }

            @Override
            public void onFailure(AerospikeException ae) {
                listener.onFailure(ae);
            }
        }, new InfoPolicy(policy), this.cluster.getRandomNode(), command);
    }

    private static int parseIndexErrorCode(String response) {
        int code = 0;
        try {
            String[] list = response.split(":");
            if (list.length >= 2 && list[0].equals("FAIL")) {
                code = Integer.parseInt(list[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (code == 0) {
            code = 1;
        }
        return code;
    }
}

