/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.query.Statement;

public final class AsyncQueryPartition
extends AsyncMultiCommand {
    private final RecordSequenceListener listener;
    private final Statement statement;
    private final PartitionTracker tracker;
    private final PartitionTracker.NodePartitions nodePartitions;

    public AsyncQueryPartition(AsyncMultiExecutor parent, QueryPolicy policy, RecordSequenceListener listener, Statement statement, PartitionTracker tracker, PartitionTracker.NodePartitions nodePartitions) {
        super(parent, nodePartitions.node, policy, tracker.socketTimeout, tracker.totalTimeout);
        this.listener = listener;
        this.statement = statement;
        this.tracker = tracker;
        this.nodePartitions = nodePartitions;
    }

    @Override
    protected void writeBuffer() {
        this.setQuery(this.policy, this.statement, false, this.nodePartitions);
    }

    @Override
    protected void parseRow(Key key) {
        if ((this.info3 & 4) != 0) {
            if (this.resultCode == 0) {
                this.tracker.partitionDone(this.nodePartitions, this.generation);
            }
            return;
        }
        if (this.resultCode != 0) {
            throw new AerospikeException(this.resultCode);
        }
        Record record = this.parseRecord();
        this.listener.onRecord(key, record);
        this.tracker.setDigest(this.nodePartitions, key);
    }

    @Override
    protected void onFailure(AerospikeException ae) {
        if (this.tracker.shouldRetry(ae)) {
            this.parent.childSuccess(this.node);
            return;
        }
        this.parent.childFailure(ae);
    }
}

