/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.cluster.Partitions;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.query.PartitionFilter;
import com.aerospike.client.query.PartitionStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class PartitionTracker {
    private final PartitionStatus[] partitions;
    private final int partitionsCapacity;
    private final int partitionBegin;
    private final int nodeCapacity;
    private final Node nodeFilter;
    private final PartitionFilter partitionFilter;
    private List<NodePartitions> nodePartitionsList;
    private List<AerospikeException> exceptions;
    private long maxRecords;
    private int sleepBetweenRetries;
    public int socketTimeout;
    public int totalTimeout;
    public int iteration = 1;
    private long deadline;

    public PartitionTracker(ScanPolicy policy, Node[] nodes) {
        this((Policy)policy, nodes);
        this.maxRecords = policy.maxRecords;
    }

    public PartitionTracker(QueryPolicy policy, Node[] nodes) {
        this((Policy)policy, nodes);
        this.maxRecords = policy.maxRecords;
    }

    public PartitionTracker(Policy policy, Node[] nodes) {
        this.partitionBegin = 0;
        this.nodeCapacity = nodes.length;
        this.nodeFilter = null;
        this.partitionFilter = null;
        int ppn = 4096 / nodes.length;
        ppn += ppn >>> 2;
        this.partitionsCapacity = ppn;
        this.partitions = this.initPartitions(4096, null);
        this.initTimeout(policy);
    }

    public PartitionTracker(ScanPolicy policy, Node nodeFilter) {
        this((Policy)policy, nodeFilter);
        this.maxRecords = policy.maxRecords;
    }

    public PartitionTracker(QueryPolicy policy, Node nodeFilter) {
        this((Policy)policy, nodeFilter);
        this.maxRecords = policy.maxRecords;
    }

    public PartitionTracker(Policy policy, Node nodeFilter) {
        this.partitionBegin = 0;
        this.nodeCapacity = 1;
        this.nodeFilter = nodeFilter;
        this.partitionFilter = null;
        this.partitionsCapacity = 4096;
        this.partitions = this.initPartitions(4096, null);
        this.initTimeout(policy);
    }

    public PartitionTracker(ScanPolicy policy, Node[] nodes, PartitionFilter filter) {
        this((Policy)policy, nodes, filter);
        this.maxRecords = policy.maxRecords;
    }

    public PartitionTracker(QueryPolicy policy, Node[] nodes, PartitionFilter filter) {
        this((Policy)policy, nodes, filter);
        this.maxRecords = policy.maxRecords;
    }

    public PartitionTracker(Policy policy, Node[] nodes, PartitionFilter filter) {
        if (filter.begin < 0 || filter.begin >= 4096) {
            throw new AerospikeException(4, "Invalid partition begin " + filter.begin + ". Valid range: 0-" + 4095);
        }
        if (filter.count <= 0) {
            throw new AerospikeException(4, "Invalid partition count " + filter.count);
        }
        if (filter.begin + filter.count > 4096) {
            throw new AerospikeException(4, "Invalid partition range (" + filter.begin + ',' + filter.count + ')');
        }
        this.partitionBegin = filter.begin;
        this.nodeCapacity = nodes.length;
        this.nodeFilter = null;
        this.partitionsCapacity = filter.count;
        if (filter.partitions == null) {
            filter.partitions = this.initPartitions(filter.count, filter.digest);
        } else {
            for (PartitionStatus part : filter.partitions) {
                part.done = false;
            }
        }
        this.partitions = filter.partitions;
        this.partitionFilter = filter;
        this.initTimeout(policy);
    }

    private PartitionStatus[] initPartitions(int partitionCount, byte[] digest) {
        PartitionStatus[] partsAll = new PartitionStatus[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            partsAll[i] = new PartitionStatus(this.partitionBegin + i);
        }
        if (digest != null) {
            partsAll[0].digest = digest;
        }
        return partsAll;
    }

    private void initTimeout(Policy policy) {
        this.sleepBetweenRetries = policy.sleepBetweenRetries;
        this.socketTimeout = policy.socketTimeout;
        this.totalTimeout = policy.totalTimeout;
        if (this.totalTimeout > 0) {
            this.deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.totalTimeout);
            if (this.socketTimeout == 0 || this.socketTimeout > this.totalTimeout) {
                this.socketTimeout = this.totalTimeout;
            }
        }
    }

    public void setSleepBetweenRetries(int sleepBetweenRetries) {
        this.sleepBetweenRetries = sleepBetweenRetries;
    }

    public List<NodePartitions> assignPartitionsToNodes(Cluster cluster, String namespace) {
        NodePartitions np;
        List<NodePartitions> list = new ArrayList<NodePartitions>(this.nodeCapacity);
        HashMap<String, Partitions> map = cluster.partitionMap;
        Partitions parts = map.get(namespace);
        if (parts == null) {
            throw new AerospikeException.InvalidNamespace(namespace, map.size());
        }
        AtomicReferenceArray<Node> master = parts.replicas[0];
        for (PartitionStatus part : this.partitions) {
            if (part.done) continue;
            Node node = master.get(part.id);
            if (node == null) {
                throw new AerospikeException.InvalidNode(part.id);
            }
            if (this.nodeFilter != null && !this.nodeFilter.getName().equals(node.getName())) continue;
            np = this.findNode(list, node);
            if (np == null) {
                np = new NodePartitions(node, this.partitionsCapacity);
                list.add(np);
            }
            np.addPartition(part);
        }
        if (this.maxRecords > 0L) {
            int nodeSize = list.size();
            if (this.maxRecords < (long)nodeSize) {
                nodeSize = (int)this.maxRecords;
                list = list.subList(0, nodeSize);
            }
            long max = this.maxRecords / (long)nodeSize;
            int rem = (int)(this.maxRecords - max * (long)nodeSize);
            for (int i = 0; i < nodeSize; ++i) {
                np = list.get(i);
                np.recordMax = i < rem ? max + 1L : max;
            }
        }
        this.nodePartitionsList = list;
        return list;
    }

    private NodePartitions findNode(List<NodePartitions> list, Node node) {
        for (NodePartitions nodePartition : list) {
            if (nodePartition.node != node) continue;
            return nodePartition;
        }
        return null;
    }

    public void partitionDone(NodePartitions nodePartitions, int partitionId) {
        this.partitions[partitionId - this.partitionBegin].done = true;
        ++nodePartitions.partsReceived;
    }

    public void setDigest(NodePartitions nodePartitions, Key key) {
        int partitionId = Partition.getPartitionId(key.digest);
        this.partitions[partitionId - this.partitionBegin].digest = key.digest;
        ++nodePartitions.recordCount;
    }

    public boolean isComplete(Policy policy) {
        long recordCount = 0L;
        int partsRequested = 0;
        int partsReceived = 0;
        for (NodePartitions nodePartitions : this.nodePartitionsList) {
            recordCount += nodePartitions.recordCount;
            partsRequested += nodePartitions.partsRequested;
            partsReceived += nodePartitions.partsReceived;
        }
        if (partsReceived >= partsRequested) {
            if (this.partitionFilter != null && recordCount == 0L) {
                this.partitionFilter.done = true;
            }
            return true;
        }
        if (this.maxRecords > 0L && recordCount >= this.maxRecords) {
            return true;
        }
        if (this.iteration > policy.maxRetries) {
            StringBuilder sb = new StringBuilder(2048);
            sb.append("Max retries exceeded: ");
            sb.append(policy.maxRetries);
            sb.append(System.lineSeparator());
            if (this.exceptions != null) {
                sb.append("sub-exceptions:");
                sb.append(System.lineSeparator());
                for (AerospikeException ae : this.exceptions) {
                    sb.append(ae.getMessage());
                    sb.append(System.lineSeparator());
                }
            }
            AerospikeException aerospikeException = new AerospikeException(-11, sb.toString());
            aerospikeException.setPolicy(policy);
            aerospikeException.setIteration(this.iteration);
            throw aerospikeException;
        }
        if (policy.totalTimeout > 0) {
            long remaining = this.deadline - System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(this.sleepBetweenRetries);
            if (remaining <= 0L) {
                throw new AerospikeException.Timeout(policy, this.iteration);
            }
            if ((remaining = TimeUnit.NANOSECONDS.toMillis(remaining)) < (long)this.totalTimeout) {
                this.totalTimeout = (int)remaining;
                if (this.socketTimeout > this.totalTimeout) {
                    this.socketTimeout = this.totalTimeout;
                }
            }
        }
        if (this.maxRecords > 0L) {
            this.maxRecords -= recordCount;
        }
        ++this.iteration;
        return false;
    }

    public boolean shouldRetry(AerospikeException ae) {
        switch (ae.getResultCode()) {
            case -8: 
            case 9: 
            case 11: {
                if (this.exceptions == null) {
                    this.exceptions = new ArrayList<AerospikeException>();
                }
                this.exceptions.add(ae);
                return true;
            }
        }
        return false;
    }

    public static final class NodePartitions {
        public final Node node;
        public final List<PartitionStatus> partsFull;
        public final List<PartitionStatus> partsPartial;
        public long recordCount;
        public long recordMax;
        public int partsRequested;
        public int partsReceived;

        public NodePartitions(Node node, int capacity) {
            this.node = node;
            this.partsFull = new ArrayList<PartitionStatus>(capacity);
            this.partsPartial = new ArrayList<PartitionStatus>(capacity);
        }

        public void addPartition(PartitionStatus part) {
            if (part.digest == null) {
                this.partsFull.add(part);
            } else {
                this.partsPartial.add(part);
            }
            ++this.partsRequested;
        }
    }
}

