/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.ResultCode;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.policy.Policy;

public class AerospikeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected transient Node node;
    protected transient Policy policy;
    protected int resultCode = -1;
    protected int iteration = -1;
    protected boolean inDoubt;

    public AerospikeException(int resultCode, String message) {
        super(message);
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode, Throwable e) {
        super(e);
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode) {
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode, boolean inDoubt) {
        this.resultCode = resultCode;
        this.inDoubt = inDoubt;
    }

    public AerospikeException(int resultCode, String message, Throwable e) {
        super(message, e);
        this.resultCode = resultCode;
    }

    public AerospikeException(String message, Throwable e) {
        super(message, e);
    }

    public AerospikeException(String message) {
        super(message);
    }

    public AerospikeException(Throwable e) {
        super(e);
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(512);
        String message = super.getMessage();
        sb.append("Error ");
        sb.append(this.resultCode);
        if (this.iteration >= 0) {
            sb.append(',');
            sb.append(this.iteration);
        }
        if (this.policy != null) {
            sb.append(',');
            sb.append(this.policy.connectTimeout);
            sb.append(',');
            sb.append(this.policy.socketTimeout);
            sb.append(',');
            sb.append(this.policy.totalTimeout);
            sb.append(',');
            sb.append(this.policy.maxRetries);
        }
        if (this.inDoubt) {
            sb.append(",inDoubt");
        }
        if (this.node != null) {
            sb.append(',');
            sb.append(this.node.toString());
        }
        sb.append(": ");
        if (message != null) {
            sb.append(message);
        } else {
            sb.append(ResultCode.getResultString(this.resultCode));
        }
        return sb.toString();
    }

    public final boolean keepConnection() {
        return ResultCode.keepConnection(this.resultCode);
    }

    public final Node getNode() {
        return this.node;
    }

    public final void setNode(Node node) {
        this.node = node;
    }

    public final Policy getPolicy() {
        return this.policy;
    }

    public final void setPolicy(Policy policy) {
        this.policy = policy;
    }

    public final int getResultCode() {
        return this.resultCode;
    }

    public final int getIteration() {
        return this.iteration;
    }

    public final void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public final boolean getInDoubt() {
        return this.inDoubt;
    }

    public final void setInDoubt(boolean isWrite, int commandSentCounter) {
        if (isWrite && (commandSentCounter > 1 || commandSentCounter == 1 && (this.resultCode == 9 || this.resultCode <= 0))) {
            this.inDoubt = true;
        }
    }

    public static class Backoff
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Backoff(int resultCode) {
            super(resultCode);
        }
    }

    public static final class AsyncQueueFull
    extends Backoff {
        private static final long serialVersionUID = 1L;

        public AsyncQueueFull() {
            super(-9);
        }
    }

    public static final class QueryTerminated
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public QueryTerminated() {
            super(-5);
        }

        public QueryTerminated(Exception e) {
            super(-5, (Throwable)e);
        }
    }

    public static final class ScanTerminated
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public ScanTerminated() {
            super(-4);
        }

        public ScanTerminated(Exception e) {
            super(-4, (Throwable)e);
        }
    }

    public static final class InvalidNamespace
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public InvalidNamespace(String ns, int mapSize) {
            super(20, mapSize == 0 ? "Partition map empty" : "Namespace not found in partition map: " + ns);
        }
    }

    public static final class InvalidNode
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public InvalidNode(int clusterSize, Partition partition) {
            super(-3, clusterSize == 0 ? "Cluster is empty" : "Node not found for partition " + partition);
        }

        public InvalidNode(int partitionId) {
            super(-3, "Node not found for partition " + partitionId);
        }

        public InvalidNode(String message) {
            super(-3, message);
        }
    }

    public static final class Connection
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Connection(String message) {
            super(-8, message);
        }

        public Connection(Exception e) {
            super(-8, (Throwable)e);
        }

        public Connection(String message, Exception e) {
            super(-8, message, e);
        }

        public Connection(int resultCode, String message) {
            super(resultCode, message);
        }
    }

    public static final class Parse
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Parse(String message) {
            super(-2, message);
        }
    }

    public static final class Serialize
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Serialize(Exception e) {
            super(-10, (Throwable)e);
        }
    }

    public static final class Timeout
    extends AerospikeException {
        private static final long serialVersionUID = 1L;
        public int connectTimeout;
        public int socketTimeout;
        public int timeout;
        public boolean client;

        public Timeout(int totalTimeout, boolean inDoubt) {
            super(9, inDoubt);
            this.connectTimeout = 0;
            this.socketTimeout = 0;
            this.timeout = totalTimeout;
            this.client = true;
        }

        public Timeout(Policy policy, boolean client) {
            super(9);
            this.connectTimeout = policy.connectTimeout;
            this.socketTimeout = policy.socketTimeout;
            this.timeout = policy.totalTimeout;
            this.client = client;
        }

        public Timeout(Policy policy, int iteration) {
            super(9);
            this.iteration = iteration;
            this.connectTimeout = policy.connectTimeout;
            this.socketTimeout = policy.socketTimeout;
            this.timeout = policy.totalTimeout;
            this.client = true;
        }

        public Timeout(Node node, int connectTimeout, int socketTimeout, int totalTimeout) {
            super(9);
            this.node = node;
            this.iteration = 1;
            this.connectTimeout = connectTimeout;
            this.socketTimeout = socketTimeout;
            this.timeout = totalTimeout;
            this.client = true;
        }

        @Override
        public String getMessage() {
            if (this.iteration == -1) {
                return "Client timeout: " + this.timeout;
            }
            StringBuilder sb = new StringBuilder(512);
            if (this.client) {
                sb.append("Client");
            } else {
                sb.append("Server");
            }
            sb.append(" timeout:");
            sb.append(" iteration=");
            sb.append(this.iteration);
            sb.append(" connect=");
            sb.append(this.connectTimeout);
            sb.append(" socket=");
            sb.append(this.socketTimeout);
            sb.append(" total=");
            sb.append(this.timeout);
            if (this.policy != null) {
                sb.append(" maxRetries=");
                sb.append(this.policy.maxRetries);
            }
            sb.append(" node=");
            sb.append(this.node);
            sb.append(" inDoubt=");
            sb.append(this.inDoubt);
            return sb.toString();
        }
    }
}

