/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.admin;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.admin.Privilege;
import com.aerospike.client.admin.PrivilegeCode;
import com.aerospike.client.admin.Role;
import com.aerospike.client.admin.User;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.AdminPolicy;
import com.aerospike.client.policy.AuthMode;
import com.aerospike.client.util.ThreadLocalData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mindrot.jbcrypt.BCrypt;

public class AdminCommand {
    private static final byte AUTHENTICATE = 0;
    private static final byte CREATE_USER = 1;
    private static final byte DROP_USER = 2;
    private static final byte SET_PASSWORD = 3;
    private static final byte CHANGE_PASSWORD = 4;
    private static final byte GRANT_ROLES = 5;
    private static final byte REVOKE_ROLES = 6;
    private static final byte QUERY_USERS = 9;
    private static final byte CREATE_ROLE = 10;
    private static final byte DROP_ROLE = 11;
    private static final byte GRANT_PRIVILEGES = 12;
    private static final byte REVOKE_PRIVILEGES = 13;
    private static final byte SET_WHITELIST = 14;
    private static final byte SET_QUOTAS = 15;
    private static final byte QUERY_ROLES = 16;
    private static final byte LOGIN = 20;
    private static final byte USER = 0;
    private static final byte PASSWORD = 1;
    private static final byte OLD_PASSWORD = 2;
    private static final byte CREDENTIAL = 3;
    private static final byte CLEAR_PASSWORD = 4;
    private static final byte SESSION_TOKEN = 5;
    private static final byte SESSION_TTL = 6;
    private static final byte ROLES = 10;
    private static final byte ROLE = 11;
    private static final byte PRIVILEGES = 12;
    private static final byte WHITELIST = 13;
    private static final byte READ_QUOTA = 14;
    private static final byte WRITE_QUOTA = 15;
    private static final byte READ_INFO = 16;
    private static final byte WRITE_INFO = 17;
    private static final byte CONNECTIONS = 18;
    private static final long MSG_VERSION = 2L;
    private static final long MSG_TYPE = 2L;
    private static final int FIELD_HEADER_SIZE = 5;
    private static final int HEADER_SIZE = 24;
    private static final int HEADER_REMAINING = 16;
    private static final int RESULT_CODE = 9;
    private static final int QUERY_END = 50;
    byte[] dataBuffer;
    int dataOffset;

    public AdminCommand() {
        this.dataBuffer = new byte[8192];
        this.dataOffset = 8;
    }

    public AdminCommand(byte[] dataBuffer) {
        this.dataBuffer = dataBuffer;
        this.dataOffset = 8;
    }

    public boolean authenticate(Cluster cluster, Connection conn, byte[] sessionToken) throws IOException {
        this.dataOffset = 8;
        this.setAuthenticate(cluster, sessionToken);
        conn.write(this.dataBuffer, this.dataOffset);
        conn.readFully(this.dataBuffer, 24, (byte)1);
        int result = this.dataBuffer[9] & 0xFF;
        return result == 0 || result == 52;
    }

    public int setAuthenticate(Cluster cluster, byte[] sessionToken) {
        if (cluster.authMode != AuthMode.PKI) {
            this.writeHeader((byte)0, 2);
            this.writeField((byte)0, cluster.getUser());
        } else {
            this.writeHeader((byte)0, 1);
        }
        this.writeField((byte)5, sessionToken);
        this.writeSize();
        return this.dataOffset;
    }

    public void createUser(Cluster cluster, AdminPolicy policy, String user, String password, List<String> roles) {
        this.writeHeader((byte)1, 3);
        this.writeField((byte)0, user);
        this.writeField((byte)1, password);
        this.writeRoles(roles);
        this.executeCommand(cluster, policy);
    }

    public void dropUser(Cluster cluster, AdminPolicy policy, String user) {
        this.writeHeader((byte)2, 1);
        this.writeField((byte)0, user);
        this.executeCommand(cluster, policy);
    }

    public void setPassword(Cluster cluster, AdminPolicy policy, byte[] user, String password) {
        this.writeHeader((byte)3, 2);
        this.writeField((byte)0, user);
        this.writeField((byte)1, password);
        this.executeCommand(cluster, policy);
    }

    public void changePassword(Cluster cluster, AdminPolicy policy, byte[] user, String password) {
        this.writeHeader((byte)4, 3);
        this.writeField((byte)0, user);
        this.writeField((byte)2, cluster.getPasswordHash());
        this.writeField((byte)1, password);
        this.executeCommand(cluster, policy);
    }

    public void grantRoles(Cluster cluster, AdminPolicy policy, String user, List<String> roles) {
        this.writeHeader((byte)5, 2);
        this.writeField((byte)0, user);
        this.writeRoles(roles);
        this.executeCommand(cluster, policy);
    }

    public void revokeRoles(Cluster cluster, AdminPolicy policy, String user, List<String> roles) {
        this.writeHeader((byte)6, 2);
        this.writeField((byte)0, user);
        this.writeRoles(roles);
        this.executeCommand(cluster, policy);
    }

    public void createRole(Cluster cluster, AdminPolicy policy, String roleName, List<Privilege> privileges) {
        this.writeHeader((byte)10, 2);
        this.writeField((byte)11, roleName);
        this.writePrivileges(privileges);
        this.executeCommand(cluster, policy);
    }

    public void createRole(Cluster cluster, AdminPolicy policy, String roleName, List<Privilege> privileges, List<String> whitelist, int readQuota, int writeQuota) {
        int fieldCount = 1;
        if (privileges != null && privileges.size() > 0) {
            ++fieldCount;
        }
        if (whitelist != null && whitelist.size() > 0) {
            ++fieldCount;
        }
        if (readQuota > 0) {
            ++fieldCount;
        }
        if (writeQuota > 0) {
            ++fieldCount;
        }
        this.writeHeader((byte)10, fieldCount);
        this.writeField((byte)11, roleName);
        if (privileges != null && privileges.size() > 0) {
            this.writePrivileges(privileges);
        }
        if (whitelist != null && whitelist.size() > 0) {
            this.writeWhitelist(whitelist);
        }
        if (readQuota > 0) {
            this.writeField((byte)14, readQuota);
        }
        if (writeQuota > 0) {
            this.writeField((byte)15, writeQuota);
        }
        this.executeCommand(cluster, policy);
    }

    public void dropRole(Cluster cluster, AdminPolicy policy, String roleName) {
        this.writeHeader((byte)11, 1);
        this.writeField((byte)11, roleName);
        this.executeCommand(cluster, policy);
    }

    public void grantPrivileges(Cluster cluster, AdminPolicy policy, String roleName, List<Privilege> privileges) {
        this.writeHeader((byte)12, 2);
        this.writeField((byte)11, roleName);
        this.writePrivileges(privileges);
        this.executeCommand(cluster, policy);
    }

    public void revokePrivileges(Cluster cluster, AdminPolicy policy, String roleName, List<Privilege> privileges) {
        this.writeHeader((byte)13, 2);
        this.writeField((byte)11, roleName);
        this.writePrivileges(privileges);
        this.executeCommand(cluster, policy);
    }

    public void setWhitelist(Cluster cluster, AdminPolicy policy, String roleName, List<String> whitelist) {
        int fieldCount = whitelist != null && whitelist.size() > 0 ? 2 : 1;
        this.writeHeader((byte)14, fieldCount);
        this.writeField((byte)11, roleName);
        if (whitelist != null && whitelist.size() > 0) {
            this.writeWhitelist(whitelist);
        }
        this.executeCommand(cluster, policy);
    }

    public void setQuotas(Cluster cluster, AdminPolicy policy, String roleName, int readQuota, int writeQuota) {
        this.writeHeader((byte)15, 3);
        this.writeField((byte)11, roleName);
        this.writeField((byte)14, readQuota);
        this.writeField((byte)15, writeQuota);
        this.executeCommand(cluster, policy);
    }

    private void writeRoles(List<String> roles) {
        int offset = this.dataOffset + 5;
        this.dataBuffer[offset++] = (byte)roles.size();
        for (String role : roles) {
            int len = Buffer.stringToUtf8(role, this.dataBuffer, offset + 1);
            this.dataBuffer[offset] = (byte)len;
            offset += len + 1;
        }
        int size = offset - this.dataOffset - 5;
        this.writeFieldHeader((byte)10, size);
        this.dataOffset = offset;
    }

    private void writePrivileges(List<Privilege> privileges) {
        int offset = this.dataOffset + 5;
        this.dataBuffer[offset++] = (byte)privileges.size();
        for (Privilege privilege : privileges) {
            this.dataBuffer[offset++] = (byte)privilege.code.id;
            if (privilege.code.canScope()) {
                if (privilege.setName != null && privilege.setName.length() != 0 && (privilege.namespace == null || privilege.namespace.length() == 0)) {
                    throw new AerospikeException(72, "Admin privilege '" + (Object)((Object)privilege.code) + "' has a set scope with an empty namespace.");
                }
                int len = Buffer.stringToUtf8(privilege.namespace, this.dataBuffer, offset + 1);
                this.dataBuffer[offset] = (byte)len;
                offset += len + 1;
                len = Buffer.stringToUtf8(privilege.setName, this.dataBuffer, offset + 1);
                this.dataBuffer[offset] = (byte)len;
                offset += len + 1;
                continue;
            }
            if ((privilege.namespace == null || privilege.namespace.length() == 0) && (privilege.setName == null || privilege.setName.length() == 0)) continue;
            throw new AerospikeException(72, "Admin global privilege '" + (Object)((Object)privilege.code) + "' has namespace/set scope which is invalid.");
        }
        int size = offset - this.dataOffset - 5;
        this.writeFieldHeader((byte)12, size);
        this.dataOffset = offset;
    }

    private void writeWhitelist(List<String> whitelist) {
        int offset = this.dataOffset + 5;
        boolean comma = false;
        for (String address : whitelist) {
            if (comma) {
                this.dataBuffer[offset++] = 44;
            } else {
                comma = true;
            }
            offset += Buffer.stringToUtf8(address, this.dataBuffer, offset);
        }
        int size = offset - this.dataOffset - 5;
        this.writeFieldHeader((byte)13, size);
        this.dataOffset = offset;
    }

    final void writeSize() {
        long size = (long)this.dataOffset - 8L | 0x200000000000000L | 0x2000000000000L;
        Buffer.longToBytes(size, this.dataBuffer, 0);
    }

    final void writeHeader(byte command, int fieldCount) {
        Arrays.fill(this.dataBuffer, this.dataOffset, this.dataOffset + 16, (byte)0);
        this.dataBuffer[this.dataOffset + 2] = command;
        this.dataBuffer[this.dataOffset + 3] = (byte)fieldCount;
        this.dataOffset += 16;
    }

    private void writeField(byte id, String str) {
        int len = Buffer.stringToUtf8(str, this.dataBuffer, this.dataOffset + 5);
        this.writeFieldHeader(id, len);
        this.dataOffset += len;
    }

    final void writeField(byte id, byte[] bytes) {
        System.arraycopy(bytes, 0, this.dataBuffer, this.dataOffset + 5, bytes.length);
        this.writeFieldHeader(id, bytes.length);
        this.dataOffset += bytes.length;
    }

    private void writeField(byte id, int val) {
        this.writeFieldHeader(id, 4);
        Buffer.intToBytes(val, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
    }

    private void writeFieldHeader(byte id, int size) {
        Buffer.intToBytes(size + 1, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = id;
    }

    private void executeCommand(Cluster cluster, AdminPolicy policy) {
        this.writeSize();
        Node node = cluster.getRandomNode();
        int timeout = policy == null ? 1000 : policy.timeout;
        Connection conn = node.getConnection(timeout);
        try {
            conn.write(this.dataBuffer, this.dataOffset);
            conn.readFully(this.dataBuffer, 24);
            conn.updateLastUsed();
            node.putConnection(conn);
        }
        catch (Exception e) {
            node.closeConnection(conn);
            throw new AerospikeException(e);
        }
        int result = this.dataBuffer[9] & 0xFF;
        if (result != 0) {
            throw new AerospikeException(result);
        }
    }

    private void executeQuery(Cluster cluster, AdminPolicy policy) {
        this.writeSize();
        Node node = cluster.getRandomNode();
        int timeout = policy == null ? 1000 : policy.timeout;
        int status = 0;
        Connection conn = node.getConnection(timeout);
        try {
            conn.write(this.dataBuffer, this.dataOffset);
            status = this.readBlocks(conn);
            node.putConnection(conn);
        }
        catch (Exception e) {
            node.closeConnection(conn);
            throw new AerospikeException(e);
        }
        if (status != 50 && status > 0) {
            throw new AerospikeException(status, "Query failed.");
        }
    }

    private int readBlocks(Connection conn) throws IOException {
        int status = 0;
        while (status == 0) {
            conn.readFully(this.dataBuffer, 8);
            long size = Buffer.bytesToLong(this.dataBuffer, 0);
            int receiveSize = (int)(size & 0xFFFFFFFFFFFFL);
            if (receiveSize <= 0) continue;
            if (receiveSize > this.dataBuffer.length) {
                this.dataBuffer = ThreadLocalData.resizeBuffer(receiveSize);
            }
            conn.readFully(this.dataBuffer, receiveSize);
            conn.updateLastUsed();
            status = this.parseBlock(receiveSize);
        }
        return status;
    }

    public static String hashPassword(String password) {
        return BCrypt.hashpw((String)password, (String)"$2a$10$7EqJtq98hPqEX7fNZaFWoO");
    }

    int parseBlock(int receiveSize) {
        return 50;
    }

    public static final class RoleCommand
    extends AdminCommand {
        private final List<Role> list;

        public RoleCommand(int capacity) {
            this.list = new ArrayList<Role>(capacity);
        }

        public Role queryRole(Cluster cluster, AdminPolicy policy, String roleName) {
            super.writeHeader((byte)16, 1);
            ((AdminCommand)this).writeField((byte)11, roleName);
            ((AdminCommand)this).executeQuery(cluster, policy);
            return this.list.size() > 0 ? this.list.get(0) : null;
        }

        public List<Role> queryRoles(Cluster cluster, AdminPolicy policy) {
            super.writeHeader((byte)16, 0);
            ((AdminCommand)this).executeQuery(cluster, policy);
            return this.list;
        }

        @Override
        int parseBlock(int receiveSize) {
            this.dataOffset = 0;
            while (this.dataOffset < receiveSize) {
                int resultCode = this.dataBuffer[this.dataOffset + 1] & 0xFF;
                if (resultCode != 0) {
                    return resultCode;
                }
                Role role = new Role();
                int fieldCount = this.dataBuffer[this.dataOffset + 3] & 0xFF;
                this.dataOffset += 16;
                block8: for (int i = 0; i < fieldCount; ++i) {
                    int len = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
                    this.dataOffset += 4;
                    int id = this.dataBuffer[this.dataOffset++] & 0xFF;
                    --len;
                    switch (id) {
                        case 11: {
                            role.name = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, len);
                            this.dataOffset += len;
                            continue block8;
                        }
                        case 12: {
                            this.parsePrivileges(role);
                            continue block8;
                        }
                        case 13: {
                            role.whitelist = this.parseWhitelist(len);
                            continue block8;
                        }
                        case 14: {
                            role.readQuota = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
                            this.dataOffset += len;
                            continue block8;
                        }
                        case 15: {
                            role.writeQuota = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
                            this.dataOffset += len;
                            continue block8;
                        }
                        default: {
                            this.dataOffset += len;
                        }
                    }
                }
                if (role.name == null) {
                    throw new AerospikeException(70);
                }
                if (role.privileges == null) {
                    role.privileges = new ArrayList<Privilege>(0);
                }
                if (role.whitelist == null) {
                    role.whitelist = new ArrayList<String>(0);
                }
                this.list.add(role);
            }
            return 0;
        }

        private void parsePrivileges(Role role) {
            int size = this.dataBuffer[this.dataOffset++] & 0xFF;
            role.privileges = new ArrayList<Privilege>(size);
            for (int i = 0; i < size; ++i) {
                Privilege priv = new Privilege();
                priv.code = PrivilegeCode.fromId(this.dataBuffer[this.dataOffset++] & 0xFF);
                if (priv.code.canScope()) {
                    int len = this.dataBuffer[this.dataOffset++] & 0xFF;
                    priv.namespace = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, len);
                    this.dataOffset += len;
                    len = this.dataBuffer[this.dataOffset++] & 0xFF;
                    priv.setName = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, len);
                    this.dataOffset += len;
                }
                role.privileges.add(priv);
            }
        }

        private List<String> parseWhitelist(int len) {
            String s;
            int l;
            ArrayList<String> list = new ArrayList<String>();
            StringBuilder sb = new StringBuilder(256);
            int begin = this.dataOffset;
            int max = this.dataOffset + len;
            while (this.dataOffset < max) {
                if (this.dataBuffer[this.dataOffset] == 44) {
                    l = this.dataOffset - begin;
                    if (l > 0) {
                        s = Buffer.utf8ToString(this.dataBuffer, begin, l, sb);
                        list.add(s);
                    }
                    begin = ++this.dataOffset;
                    continue;
                }
                ++this.dataOffset;
            }
            l = this.dataOffset - begin;
            if (l > 0) {
                s = Buffer.utf8ToString(this.dataBuffer, begin, l, sb);
                list.add(s);
            }
            return list;
        }
    }

    public static final class UserCommand
    extends AdminCommand {
        private final List<User> list;

        public UserCommand(int capacity) {
            this.list = new ArrayList<User>(capacity);
        }

        public User queryUser(Cluster cluster, AdminPolicy policy, String user) {
            super.writeHeader((byte)9, 1);
            ((AdminCommand)this).writeField((byte)0, user);
            ((AdminCommand)this).executeQuery(cluster, policy);
            return this.list.size() > 0 ? this.list.get(0) : null;
        }

        public List<User> queryUsers(Cluster cluster, AdminPolicy policy) {
            super.writeHeader((byte)9, 0);
            ((AdminCommand)this).executeQuery(cluster, policy);
            return this.list;
        }

        @Override
        int parseBlock(int receiveSize) {
            this.dataOffset = 0;
            while (this.dataOffset < receiveSize) {
                int resultCode = this.dataBuffer[this.dataOffset + 1] & 0xFF;
                if (resultCode != 0) {
                    return resultCode;
                }
                User user = new User();
                int fieldCount = this.dataBuffer[this.dataOffset + 3] & 0xFF;
                this.dataOffset += 16;
                block8: for (int i = 0; i < fieldCount; ++i) {
                    int len = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
                    this.dataOffset += 4;
                    int id = this.dataBuffer[this.dataOffset++] & 0xFF;
                    --len;
                    switch (id) {
                        case 0: {
                            user.name = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, len);
                            this.dataOffset += len;
                            continue block8;
                        }
                        case 10: {
                            this.parseRoles(user);
                            continue block8;
                        }
                        case 16: {
                            user.readInfo = this.parseInfo();
                            continue block8;
                        }
                        case 17: {
                            user.writeInfo = this.parseInfo();
                            continue block8;
                        }
                        case 18: {
                            user.connsInUse = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
                            this.dataOffset += len;
                            continue block8;
                        }
                        default: {
                            this.dataOffset += len;
                        }
                    }
                }
                if (user.name == null && user.roles == null) continue;
                if (user.roles == null) {
                    user.roles = new ArrayList<String>(0);
                }
                this.list.add(user);
            }
            return 0;
        }

        private void parseRoles(User user) {
            int size = this.dataBuffer[this.dataOffset++] & 0xFF;
            user.roles = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                int len = this.dataBuffer[this.dataOffset++] & 0xFF;
                String role = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, len);
                this.dataOffset += len;
                user.roles.add(role);
            }
        }

        private List<Integer> parseInfo() {
            int size = this.dataBuffer[this.dataOffset++] & 0xFF;
            ArrayList<Integer> list = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                int val = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
                this.dataOffset += 4;
                list.add(val);
            }
            return list;
        }
    }

    public static class LoginCommand
    extends AdminCommand {
        public byte[] sessionToken = null;
        public long sessionExpiration = 0L;

        public LoginCommand(Cluster cluster, Connection conn) throws IOException {
            super(ThreadLocalData.getBuffer());
            conn.setTimeout(cluster.loginTimeout);
            try {
                this.login(cluster, conn);
            }
            finally {
                conn.setTimeout(cluster.connectTimeout);
            }
        }

        private void login(Cluster cluster, Connection conn) throws IOException {
            if (cluster.authMode == AuthMode.INTERNAL) {
                this.writeHeader((byte)20, 2);
                this.writeField((byte)0, cluster.getUser());
                this.writeField((byte)3, cluster.getPasswordHash());
            } else if (cluster.authMode == AuthMode.PKI) {
                this.writeHeader((byte)20, 0);
            } else {
                this.writeHeader((byte)20, 3);
                this.writeField((byte)0, cluster.getUser());
                this.writeField((byte)3, cluster.getPasswordHash());
                this.writeField((byte)4, cluster.getPassword());
            }
            this.writeSize();
            conn.write(this.dataBuffer, this.dataOffset);
            conn.readFully(this.dataBuffer, 24);
            int result = this.dataBuffer[9] & 0xFF;
            if (result != 0) {
                if (result == 52) {
                    return;
                }
                throw new AerospikeException(result, "Login failed");
            }
            long size = Buffer.bytesToLong(this.dataBuffer, 0);
            int receiveSize = (int)(size & 0xFFFFFFFFFFFFL) - 16;
            int fieldCount = this.dataBuffer[11] & 0xFF;
            if (receiveSize <= 0 || receiveSize > this.dataBuffer.length || fieldCount <= 0) {
                throw new AerospikeException(result, "Failed to retrieve session token");
            }
            conn.readFully(this.dataBuffer, receiveSize);
            this.dataOffset = 0;
            for (int i = 0; i < fieldCount; ++i) {
                int len = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
                this.dataOffset += 4;
                int id = this.dataBuffer[this.dataOffset++] & 0xFF;
                --len;
                if (id == 5) {
                    this.sessionToken = Arrays.copyOfRange(this.dataBuffer, this.dataOffset, this.dataOffset + len);
                } else if (id == 6) {
                    long seconds = Buffer.bigUnsigned32ToLong(this.dataBuffer, this.dataOffset) - 60L;
                    if (seconds > 0L) {
                        this.sessionExpiration = System.nanoTime() + TimeUnit.SECONDS.toNanos(seconds);
                    } else {
                        Log.warn("Invalid session TTL: " + seconds);
                    }
                }
                this.dataOffset += len;
            }
            if (this.sessionToken == null) {
                throw new AerospikeException(result, "Failed to retrieve session token");
            }
        }
    }
}

