/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.Policy;

public abstract class AsyncMultiCommand
extends AsyncCommand {
    final AsyncMultiExecutor parent;
    final Node node;
    int groups;
    int info3;
    int resultCode;
    int generation;
    int expiration;
    int batchIndex;
    int fieldCount;
    int opCount;
    private final boolean isBatch;
    protected final boolean isOperation;

    public AsyncMultiCommand(AsyncMultiExecutor parent, Node node, Policy policy, boolean isOperation) {
        super(policy, false);
        this.parent = parent;
        this.node = node;
        this.isBatch = true;
        this.isOperation = isOperation;
    }

    public AsyncMultiCommand(AsyncMultiExecutor parent, Node node, Policy policy, int socketTimeout, int totalTimeout) {
        super(policy, socketTimeout, totalTimeout);
        this.parent = parent;
        this.node = node;
        this.isBatch = false;
        this.isOperation = false;
    }

    @Override
    protected Node getNode(Cluster cluster) {
        return this.node;
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        return true;
    }

    @Override
    final boolean parseResult() {
        while (this.dataOffset < this.receiveSize) {
            this.dataOffset += 3;
            this.info3 = this.dataBuffer[this.dataOffset] & 0xFF;
            this.dataOffset += 2;
            this.resultCode = this.dataBuffer[this.dataOffset] & 0xFF;
            if (this.resultCode != 0) {
                if (this.resultCode == 2 || this.resultCode == 27) {
                    if (!this.isBatch) {
                        return true;
                    }
                } else {
                    throw new AerospikeException(this.resultCode);
                }
            }
            if ((this.info3 & 1) != 0) {
                return true;
            }
            ++this.dataOffset;
            this.generation = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.expiration = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.batchIndex = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.fieldCount = Buffer.bytesToShort(this.dataBuffer, this.dataOffset);
            this.dataOffset += 2;
            this.opCount = Buffer.bytesToShort(this.dataBuffer, this.dataOffset);
            this.dataOffset += 2;
            if (this.isBatch) {
                this.skipKey(this.fieldCount);
                this.parseRow(null);
                continue;
            }
            Key key = this.parseKey(this.fieldCount);
            this.parseRow(key);
        }
        return false;
    }

    protected final Record parseRecord() {
        if (this.opCount <= 0) {
            return new Record(null, this.generation, this.expiration);
        }
        return this.parseRecord(this.opCount, this.generation, this.expiration, this.isOperation);
    }

    @Override
    protected final void onSuccess() {
        this.parent.childSuccess(this.node);
    }

    @Override
    protected void onFailure(AerospikeException e) {
        this.parent.childFailure(e);
    }

    protected abstract void parseRow(Key var1);
}

