/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.HashedWheelTimer;
import com.aerospike.client.async.NettyCommand;
import com.aerospike.client.async.NettyConnection;
import com.aerospike.client.async.NettyEventLoop;
import com.aerospike.client.async.TimerTask;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.TlsPolicy;
import com.aerospike.client.util.Util;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;

public final class NettyRecover
implements TimerTask {
    private final Cluster cluster;
    private final NettyEventLoop eventLoop;
    private final Node node;
    private final EventState eventState;
    private final NettyConnection conn;
    private final HashedWheelTimer.HashedWheelTimeout timeoutTask;
    private byte[] dataBuffer;
    private int offset;
    private int length;
    private int state;
    private final boolean isSingle;
    private final boolean saveBuffer;
    private boolean isLastGroup;

    public NettyRecover(NettyCommand cmd) {
        this.cluster = cmd.cluster;
        this.eventLoop = cmd.eventLoop;
        this.node = cmd.node;
        this.eventState = cmd.eventState;
        this.conn = cmd.conn;
        this.state = cmd.state;
        AsyncCommand a = cmd.command;
        this.dataBuffer = a.dataBuffer;
        this.saveBuffer = this.dataBuffer != null ? this.dataBuffer.length <= 131072 : false;
        this.offset = a.dataOffset;
        this.length = a.receiveSize;
        this.isSingle = a.isSingle;
        if (cmd.state == 8 && this.offset >= 2 && this.dataBuffer[1] != 0) {
            this.timeoutTask = null;
            this.abort(false);
            return;
        }
        ChannelPipeline p = this.conn.channel.pipeline();
        if (p.last() != null) {
            p.removeLast();
        }
        p.addLast(new ChannelHandler[]{new InboundHandler(this)});
        this.timeoutTask = new HashedWheelTimer.HashedWheelTimeout(this);
        this.eventLoop.timer.addTimeout(this.timeoutTask, System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(a.policy.timeoutDelay));
    }

    @Override
    public final void timeout() {
        this.abort(false);
    }

    private void channelActive() {
        byte[] token = this.node.getSessionToken();
        if (token != null) {
            this.writeAuth(token);
        } else {
            this.recover();
        }
    }

    private void writeAuth(byte[] token) {
        this.state = 6;
        this.dataBuffer = new byte[512];
        AdminCommand admin = new AdminCommand(this.dataBuffer);
        int len = admin.setAuthenticate(this.cluster, token);
        ByteBuf byteBuffer = PooledByteBufAllocator.DEFAULT.directBuffer(len);
        byteBuffer.clear();
        byteBuffer.writeBytes(this.dataBuffer, 0, len);
        ChannelFuture cf = this.conn.channel.writeAndFlush((Object)byteBuffer);
        cf.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (NettyRecover.this.state == 6) {
                    NettyRecover.this.state = 7;
                    ((NettyRecover)NettyRecover.this).conn.channel.config().setAutoRead(true);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drain(ByteBuf byteBuffer) {
        try {
            switch (this.state) {
                case 7: {
                    this.drainSingleHeader(byteBuffer, 8);
                    return;
                }
                case 8: {
                    this.drainSingleBody(byteBuffer);
                    return;
                }
                case 10: {
                    if (this.isSingle) {
                        this.drainSingleHeader(byteBuffer, 11);
                        return;
                    }
                    this.drainMultiHeader(byteBuffer);
                    return;
                }
                case 11: {
                    if (this.isSingle) {
                        this.drainSingleBody(byteBuffer);
                        return;
                    }
                    if (!this.drainMultiBody(byteBuffer)) {
                        return;
                    }
                    this.drainMultiHeader(byteBuffer);
                    return;
                }
            }
            return;
        }
        finally {
            byteBuffer.release();
        }
    }

    private final void drainSingleHeader(ByteBuf byteBuffer, int nextState) {
        int readableBytes = byteBuffer.readableBytes();
        int dataSize = this.offset + readableBytes;
        if (dataSize < 8) {
            byteBuffer.readBytes(this.dataBuffer, this.offset, readableBytes);
            this.offset = dataSize;
            return;
        }
        dataSize = 8 - this.offset;
        byteBuffer.readBytes(this.dataBuffer, this.offset, dataSize);
        readableBytes -= dataSize;
        this.length = (int)(Buffer.bytesToLong(this.dataBuffer, 0) & 0xFFFFFFFFFFFFL);
        this.state = nextState;
        this.offset = 0;
        this.drainSingleBody(byteBuffer);
    }

    private final void drainSingleBody(ByteBuf byteBuffer) {
        int readableBytes = byteBuffer.readableBytes();
        if (this.state == 8 && this.offset < 2 && this.offset + readableBytes >= 2) {
            int len = 2 - this.offset;
            byteBuffer.readBytes(this.dataBuffer, 0, len);
            readableBytes -= len;
            this.offset += len;
            byte resultCode = this.dataBuffer[len - 1];
            if (resultCode != 0) {
                this.abort(false);
                return;
            }
            if (readableBytes <= 0) {
                return;
            }
        }
        byteBuffer.skipBytes(readableBytes);
        this.offset += readableBytes;
        if (this.offset >= this.length) {
            this.recover();
        }
    }

    private final void drainMultiHeader(ByteBuf byteBuffer) {
        int readableBytes = byteBuffer.readableBytes();
        while (true) {
            boolean compressed;
            int dataSize;
            if ((dataSize = this.offset + readableBytes) < 8) {
                byteBuffer.readBytes(this.dataBuffer, this.offset, readableBytes);
                this.offset = dataSize;
                return;
            }
            dataSize = 8 - this.offset;
            byteBuffer.readBytes(this.dataBuffer, this.offset, dataSize);
            readableBytes -= dataSize;
            long proto = Buffer.bytesToLong(this.dataBuffer, 0);
            this.length = (int)(proto & 0xFFFFFFFFFFFFL);
            if (this.length == 0) {
                this.offset = 0;
                continue;
            }
            boolean bl = compressed = (proto >> 48 & 0xFFL) == 4L;
            if (compressed) {
                throw new AerospikeException("Recovering connections with compressed multi-record data is not supported");
            }
            this.state = 11;
            this.offset = 0;
            if (readableBytes <= 0) {
                return;
            }
            if (!this.drainMultiBody(byteBuffer)) {
                return;
            }
            readableBytes = byteBuffer.readableBytes();
        }
    }

    private final boolean drainMultiBody(ByteBuf byteBuffer) {
        int needBytes;
        int readableBytes = byteBuffer.readableBytes();
        if (this.offset < 4 && this.offset + readableBytes >= 4) {
            int len = 4 - this.offset;
            byteBuffer.readBytes(this.dataBuffer, 0, len);
            readableBytes -= len;
            this.offset += len;
            byte info3 = this.dataBuffer[len - 1];
            if ((info3 & 1) != 0) {
                this.isLastGroup = true;
            }
            if (readableBytes <= 0) {
                return false;
            }
        }
        int dataSize = readableBytes >= (needBytes = this.length - this.offset) ? needBytes : readableBytes;
        byteBuffer.skipBytes(dataSize);
        this.offset += dataSize;
        if (this.offset < this.length) {
            return false;
        }
        if (this.isLastGroup) {
            this.recover();
            return false;
        }
        this.state = 10;
        this.offset = 0;
        return true;
    }

    private final void recover() {
        block5: {
            if (this.state == 12) {
                return;
            }
            this.state = 12;
            try {
                SocketChannel channel = this.conn.channel;
                channel.config().setAutoRead(false);
                ChannelPipeline p = channel.pipeline();
                p.removeLast();
                if (this.cluster.keepAlive == null) {
                    p.addLast(new ChannelHandler[]{new NettyCommand.InboundHandler()});
                } else {
                    Node.AsyncPool pool = this.node.getAsyncPool(this.eventState.index);
                    p.addLast(new ChannelHandler[]{new NettyCommand.InboundHandler(pool)});
                }
                this.conn.updateLastUsed();
                this.node.putAsyncConnection(this.conn, this.eventLoop.index);
                this.close(true);
            }
            catch (Throwable e) {
                if (this.eventState.closed) break block5;
                Log.error("NettyRecover recover failed: " + Util.getStackTrace(e));
            }
        }
    }

    private final void abort(boolean cancelTimeout) {
        block3: {
            if (this.state == 12) {
                return;
            }
            this.state = 12;
            try {
                this.node.closeAsyncConnection(this.conn, this.eventLoop.index);
                this.close(cancelTimeout);
            }
            catch (Throwable e) {
                if (this.eventState.closed) break block3;
                Log.error("NettyRecover abort failed: " + Util.getStackTrace(e));
            }
        }
    }

    private final void close(boolean cancelTimeout) {
        if (cancelTimeout) {
            this.timeoutTask.cancel();
        }
        if (this.saveBuffer) {
            this.eventLoop.bufferQueue.addLast(this.dataBuffer);
        }
    }

    private static final class InboundHandler
    extends ChannelInboundHandlerAdapter {
        private final NettyRecover command;

        public InboundHandler(NettyRecover command) {
            this.command = command;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            if (this.command.state == 4) {
                this.command.channelActive();
            }
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.command.drain((ByteBuf)msg);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (!(evt instanceof SslHandshakeCompletionEvent)) {
                return;
            }
            Throwable cause = ((SslHandshakeCompletionEvent)evt).cause();
            if (cause != null) {
                throw new AerospikeException("TLS connect failed: " + cause.getMessage(), cause);
            }
            TlsPolicy tlsPolicy = ((NettyRecover)this.command).eventLoop.parent.tlsPolicy;
            String tlsName = ((NettyRecover)this.command).node.getHost().tlsName;
            SSLSession session = ((SslHandler)ctx.pipeline().first()).engine().getSession();
            X509Certificate cert = (X509Certificate)session.getPeerCertificates()[0];
            Connection.validateServerCertificate(tlsPolicy, tlsName, cert);
            if (this.command.state == 5) {
                this.command.channelActive();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.command.abort(true);
        }
    }
}

