/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.policy;

import com.aerospike.client.exp.Expression;
import com.aerospike.client.policy.ReadModeAP;
import com.aerospike.client.policy.ReadModeSC;
import com.aerospike.client.policy.Replica;
import com.aerospike.client.query.PredExp;

public class Policy {
    public ReadModeAP readModeAP = ReadModeAP.ONE;
    public ReadModeSC readModeSC = ReadModeSC.SESSION;
    public Replica replica = Replica.SEQUENCE;
    @Deprecated
    public PredExp[] predExp;
    public Expression filterExp;
    public int connectTimeout;
    public int socketTimeout = 30000;
    public int totalTimeout;
    public int timeoutDelay;
    public int maxRetries = 2;
    public int sleepBetweenRetries;
    public boolean sendKey;
    public boolean compress;
    public boolean failOnFilteredOut;

    public Policy(Policy other) {
        this.readModeAP = other.readModeAP;
        this.readModeSC = other.readModeSC;
        this.replica = other.replica;
        this.predExp = other.predExp;
        this.filterExp = other.filterExp;
        this.connectTimeout = other.connectTimeout;
        this.socketTimeout = other.socketTimeout;
        this.totalTimeout = other.totalTimeout;
        this.timeoutDelay = other.timeoutDelay;
        this.maxRetries = other.maxRetries;
        this.sleepBetweenRetries = other.sleepBetweenRetries;
        this.sendKey = other.sendKey;
        this.compress = other.compress;
        this.failOnFilteredOut = other.failOnFilteredOut;
    }

    public Policy() {
    }

    public final void setTimeout(int timeout) {
        this.socketTimeout = timeout;
        this.totalTimeout = timeout;
    }

    public final void setTimeouts(int socketTimeout, int totalTimeout) {
        this.socketTimeout = socketTimeout;
        this.totalTimeout = totalTimeout;
        if (totalTimeout > 0 && (socketTimeout == 0 || socketTimeout > totalTimeout)) {
            this.socketTimeout = totalTimeout;
        }
    }

    @Deprecated
    public final void setPredExp(PredExp ... predExp) {
        this.predExp = predExp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.compress ? 1231 : 1237);
        result = 31 * result + this.connectTimeout;
        result = 31 * result + (this.failOnFilteredOut ? 1231 : 1237);
        result = 31 * result + (this.filterExp == null ? 0 : this.filterExp.hashCode());
        result = 31 * result + this.maxRetries;
        result = 31 * result + (this.readModeAP == null ? 0 : this.readModeAP.hashCode());
        result = 31 * result + (this.readModeSC == null ? 0 : this.readModeSC.hashCode());
        result = 31 * result + (this.replica == null ? 0 : this.replica.hashCode());
        result = 31 * result + (this.sendKey ? 1231 : 1237);
        result = 31 * result + this.sleepBetweenRetries;
        result = 31 * result + this.socketTimeout;
        result = 31 * result + this.timeoutDelay;
        result = 31 * result + this.totalTimeout;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Policy other = (Policy)obj;
        if (this.compress != other.compress) {
            return false;
        }
        if (this.connectTimeout != other.connectTimeout) {
            return false;
        }
        if (this.failOnFilteredOut != other.failOnFilteredOut) {
            return false;
        }
        if (this.filterExp == null ? other.filterExp != null : !this.filterExp.equals(other.filterExp)) {
            return false;
        }
        if (this.maxRetries != other.maxRetries) {
            return false;
        }
        if (this.readModeAP != other.readModeAP) {
            return false;
        }
        if (this.readModeSC != other.readModeSC) {
            return false;
        }
        if (this.replica != other.replica) {
            return false;
        }
        if (this.sendKey != other.sendKey) {
            return false;
        }
        if (this.sleepBetweenRetries != other.sleepBetweenRetries) {
            return false;
        }
        if (this.socketTimeout != other.socketTimeout) {
            return false;
        }
        if (this.timeoutDelay != other.timeoutDelay) {
            return false;
        }
        return this.totalTimeout == other.totalTimeout;
    }
}

