/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.util;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.command.Buffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class Unpacker<T> {
    private final byte[] buffer;
    private int offset;
    private final int length;

    public Unpacker(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public final T unpackList() throws AerospikeException {
        if (this.length <= 0) {
            return (T)this.getList(new ArrayList(0));
        }
        try {
            int count;
            int type = this.buffer[this.offset++] & 0xFF;
            if ((type & 0xF0) == 144) {
                count = type & 0xF;
            } else if (type == 220) {
                count = Buffer.bytesToShort(this.buffer, this.offset);
                this.offset += 2;
            } else if (type == 221) {
                count = Buffer.bytesToInt(this.buffer, this.offset);
                this.offset += 4;
            } else {
                return (T)this.getList(new ArrayList(0));
            }
            return this.unpackList(count);
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    private T unpackList(int count) throws IOException, ClassNotFoundException {
        int type;
        if (count <= 0) {
            return (T)this.getList(new ArrayList(0));
        }
        int mark = this.offset;
        int size = count;
        T val = this.unpackObject();
        if (val == null && (type = this.buffer[mark] & 0xFF) != 192) {
            --size;
        }
        ArrayList<T> out = new ArrayList<T>(size);
        if (size == count) {
            out.add(val);
        }
        for (int i = 1; i < count; ++i) {
            out.add(this.unpackObject());
        }
        return (T)this.getList(out);
    }

    public final T unpackMap() throws AerospikeException {
        if (this.length <= 0) {
            return (T)this.getMap(new HashMap(0));
        }
        try {
            int count;
            int type = this.buffer[this.offset++] & 0xFF;
            if ((type & 0xF0) == 128) {
                count = type & 0xF;
            } else if (type == 222) {
                count = Buffer.bytesToShort(this.buffer, this.offset);
                this.offset += 2;
            } else if (type == 223) {
                count = Buffer.bytesToInt(this.buffer, this.offset);
                this.offset += 4;
            } else {
                return (T)this.getMap(new HashMap(0));
            }
            return this.unpackMap(count);
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    private T unpackMap(int count) throws IOException, ClassNotFoundException {
        int extensionType;
        if (count <= 0) {
            return (T)this.getMap(new HashMap(0));
        }
        int type = this.buffer[this.offset] & 0xFF;
        if (type == 199 && (extensionType = this.buffer[this.offset + 1] & 0xFF) == 0) {
            int mapBits = this.buffer[this.offset + 2] & 0xFF;
            if ((mapBits & 0xC) != 0) {
                return this.unpackMapAsList(count);
            }
            if ((mapBits & 1) != 0) {
                return this.unpackTreeMap(count);
            }
        }
        return this.unpackHashMap(count);
    }

    private T unpackHashMap(int count) throws IOException, ClassNotFoundException {
        HashMap<T, T> map = new HashMap<T, T>(count);
        for (int i = 0; i < count; ++i) {
            T key = this.unpackObject();
            T val = this.unpackObject();
            if (key == null) continue;
            map.put(key, val);
        }
        return (T)this.getMap(map);
    }

    private T unpackTreeMap(int count) throws IOException, ClassNotFoundException {
        TreeMap<T, T> map = new TreeMap<T, T>();
        for (int i = 0; i < count; ++i) {
            Object key = this.unpackObject();
            T val = this.unpackObject();
            if (key == null) continue;
            if (key instanceof byte[]) {
                key = ByteBuffer.wrap((byte[])key);
            }
            map.put(key, val);
        }
        return (T)this.getMap(map);
    }

    private T unpackMapAsList(int count) throws IOException, ClassNotFoundException {
        ArrayList<AbstractMap.SimpleEntry<T, T>> list = new ArrayList<AbstractMap.SimpleEntry<T, T>>(count - 1);
        for (int i = 0; i < count; ++i) {
            T key = this.unpackObject();
            T val = this.unpackObject();
            if (key == null) continue;
            list.add(new AbstractMap.SimpleEntry<T, T>(key, val));
        }
        return (T)this.getList(list);
    }

    private T unpackBlob(int count) throws IOException, ClassNotFoundException {
        T val;
        int type = this.buffer[this.offset++] & 0xFF;
        --count;
        switch (type) {
            case 3: {
                val = this.getString(Buffer.utf8ToString(this.buffer, this.offset, count));
                break;
            }
            case 7: {
                throw new AerospikeException(-10, "Object deserializer has been disabled");
            }
            case 23: {
                val = this.getGeoJSON(Buffer.utf8ToString(this.buffer, this.offset, count));
                break;
            }
            default: {
                val = this.getBlob(Arrays.copyOfRange(this.buffer, this.offset, this.offset + count));
            }
        }
        this.offset += count;
        return val;
    }

    public T unpackObject() throws IOException, ClassNotFoundException {
        int type = this.buffer[this.offset++] & 0xFF;
        switch (type) {
            case 192: {
                return null;
            }
            case 195: {
                return this.getBoolean(true);
            }
            case 194: {
                return this.getBoolean(false);
            }
            case 202: {
                float val = Float.intBitsToFloat(Buffer.bytesToInt(this.buffer, this.offset));
                this.offset += 4;
                return this.getDouble(val);
            }
            case 203: {
                double val = Double.longBitsToDouble(Buffer.bytesToLong(this.buffer, this.offset));
                this.offset += 8;
                return this.getDouble(val);
            }
            case 208: {
                return this.getLong(this.buffer[this.offset++]);
            }
            case 204: {
                return this.getLong(this.buffer[this.offset++] & 0xFF);
            }
            case 209: {
                short val = Buffer.bigSigned16ToShort(this.buffer, this.offset);
                this.offset += 2;
                return this.getLong(val);
            }
            case 205: {
                int val = Buffer.bytesToShort(this.buffer, this.offset);
                this.offset += 2;
                return this.getLong(val);
            }
            case 210: {
                int val = Buffer.bytesToInt(this.buffer, this.offset);
                this.offset += 4;
                return this.getLong(val);
            }
            case 206: {
                long val = Buffer.bigUnsigned32ToLong(this.buffer, this.offset);
                this.offset += 4;
                return this.getLong(val);
            }
            case 211: {
                long val = Buffer.bytesToLong(this.buffer, this.offset);
                this.offset += 8;
                return this.getLong(val);
            }
            case 207: {
                long val = Buffer.bytesToLong(this.buffer, this.offset);
                this.offset += 8;
                return this.getLong(val);
            }
            case 196: 
            case 217: {
                int count = this.buffer[this.offset++] & 0xFF;
                return this.unpackBlob(count);
            }
            case 197: 
            case 218: {
                int count = Buffer.bytesToShort(this.buffer, this.offset);
                this.offset += 2;
                return this.unpackBlob(count);
            }
            case 198: 
            case 219: {
                int count = Buffer.bytesToInt(this.buffer, this.offset);
                this.offset += 4;
                return this.unpackBlob(count);
            }
            case 220: {
                int count = Buffer.bytesToShort(this.buffer, this.offset);
                this.offset += 2;
                return this.unpackList(count);
            }
            case 221: {
                int count = Buffer.bytesToInt(this.buffer, this.offset);
                this.offset += 4;
                return this.unpackList(count);
            }
            case 222: {
                int count = Buffer.bytesToShort(this.buffer, this.offset);
                this.offset += 2;
                return this.unpackMap(count);
            }
            case 223: {
                int count = Buffer.bytesToInt(this.buffer, this.offset);
                this.offset += 4;
                return this.unpackMap(count);
            }
            case 212: {
                this.offset += 2;
                return null;
            }
            case 213: {
                this.offset += 3;
                return null;
            }
            case 214: {
                this.offset += 5;
                return null;
            }
            case 215: {
                this.offset += 9;
                return null;
            }
            case 216: {
                this.offset += 17;
                return null;
            }
            case 199: {
                int count = this.buffer[this.offset] & 0xFF;
                this.offset += count + 1 + 1;
                return null;
            }
            case 200: {
                int count = Buffer.bytesToShort(this.buffer, this.offset);
                this.offset += count + 1 + 2;
                return null;
            }
            case 201: {
                int count = Buffer.bytesToInt(this.buffer, this.offset);
                this.offset += count + 1 + 4;
                return null;
            }
        }
        if ((type & 0xE0) == 160) {
            return this.unpackBlob(type & 0x1F);
        }
        if ((type & 0xF0) == 128) {
            return this.unpackMap(type & 0xF);
        }
        if ((type & 0xF0) == 144) {
            return this.unpackList(type & 0xF);
        }
        if (type < 128) {
            return this.getLong(type);
        }
        if (type >= 224) {
            return this.getLong(type - 224 - 32);
        }
        throw new IOException("Unknown unpack type: " + type);
    }

    protected abstract T getMap(Map<T, T> var1);

    protected abstract T getList(List<T> var1);

    protected abstract T getJavaBlob(Object var1);

    protected abstract T getBlob(byte[] var1);

    protected abstract T getString(String var1);

    protected abstract T getLong(long var1);

    protected abstract T getDouble(double var1);

    protected abstract T getBoolean(boolean var1);

    protected abstract T getGeoJSON(String var1);

    public static Object unpackObjectList(byte[] buffer, int offset, int length) throws AerospikeException {
        ObjectUnpacker unpacker = new ObjectUnpacker(buffer, offset, length);
        return unpacker.unpackList();
    }

    public static Object unpackObjectMap(byte[] buffer, int offset, int length) throws AerospikeException {
        ObjectUnpacker unpacker = new ObjectUnpacker(buffer, offset, length);
        return unpacker.unpackMap();
    }

    public static Object unpackObject(byte[] buffer, int offset, int length) throws AerospikeException {
        try {
            if (length <= 0) {
                return null;
            }
            ObjectUnpacker unpacker = new ObjectUnpacker(buffer, offset, length);
            return unpacker.unpackObject();
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public static final class ObjectUnpacker
    extends Unpacker<Object> {
        public ObjectUnpacker(byte[] buffer, int offset, int length) {
            super(buffer, offset, length);
        }

        @Override
        protected Object getMap(Map<Object, Object> value) {
            return value;
        }

        @Override
        protected Object getList(List<Object> value) {
            return value;
        }

        @Override
        protected Object getJavaBlob(Object value) {
            return value;
        }

        @Override
        protected Object getBlob(byte[] value) {
            return value;
        }

        @Override
        protected Object getString(String value) {
            return value;
        }

        @Override
        protected Object getLong(long value) {
            return value;
        }

        @Override
        protected Object getDouble(double value) {
            return value;
        }

        @Override
        protected Object getBoolean(boolean value) {
            return value;
        }

        @Override
        protected Object getGeoJSON(String value) {
            return Value.getAsGeoJSON(value);
        }
    }
}

