/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.policy.Policy;

public final class AsyncReadHeader
extends AsyncCommand {
    private final RecordListener listener;
    private final Key key;
    private final Partition partition;
    private Record record;

    public AsyncReadHeader(Cluster cluster, RecordListener listener, Policy policy, Key key) {
        super(policy, true);
        this.listener = listener;
        this.key = key;
        this.partition = Partition.read(cluster, policy, key);
    }

    @Override
    Node getNode(Cluster cluster) {
        return this.partition.getNodeRead(cluster);
    }

    @Override
    protected void writeBuffer() {
        this.setReadHeader(this.policy, this.key);
    }

    @Override
    protected boolean parseResult() {
        this.validateHeaderSize();
        int resultCode = this.dataBuffer[5] & 0xFF;
        if (resultCode == 0) {
            int generation = Buffer.bytesToInt(this.dataBuffer, 6);
            int expiration = Buffer.bytesToInt(this.dataBuffer, 10);
            this.record = new Record(null, generation, expiration);
            return true;
        }
        if (resultCode == 2) {
            return true;
        }
        if (resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            return true;
        }
        throw new AerospikeException(resultCode);
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryRead(timeout);
        return true;
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.record);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

