/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.query.IndexCollectionType;

public final class Filter {
    private final String name;
    private final IndexCollectionType colType;
    private final int valType;
    private final Value begin;
    private final Value end;

    public static Filter equal(String name, long value) {
        Value val = Value.get(value);
        return new Filter(name, IndexCollectionType.DEFAULT, val.getType(), val, val);
    }

    public static Filter equal(String name, String value) {
        Value val = Value.get(value);
        return new Filter(name, IndexCollectionType.DEFAULT, val.getType(), val, val);
    }

    public static Filter contains(String name, IndexCollectionType type, long value) {
        Value val = Value.get(value);
        return new Filter(name, type, val.getType(), val, val);
    }

    public static Filter contains(String name, IndexCollectionType type, String value) {
        Value val = Value.get(value);
        return new Filter(name, type, val.getType(), val, val);
    }

    public static Filter range(String name, long begin, long end) {
        return new Filter(name, IndexCollectionType.DEFAULT, 1, Value.get(begin), Value.get(end));
    }

    public static Filter range(String name, IndexCollectionType type, long begin, long end) {
        return new Filter(name, type, 1, Value.get(begin), Value.get(end));
    }

    public static Filter geoWithinRegion(String name, String region) {
        return new Filter(name, IndexCollectionType.DEFAULT, 23, Value.get(region), Value.get(region));
    }

    public static Filter geoWithinRegion(String name, IndexCollectionType type, String region) {
        return new Filter(name, type, 23, Value.get(region), Value.get(region));
    }

    public static Filter geoWithinRadius(String name, double lng, double lat, double radius) {
        String rgnstr = String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", lng, lat, radius);
        return new Filter(name, IndexCollectionType.DEFAULT, 23, Value.get(rgnstr), Value.get(rgnstr));
    }

    public static Filter geoWithinRadius(String name, IndexCollectionType type, double lng, double lat, double radius) {
        String rgnstr = String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", lng, lat, radius);
        return new Filter(name, type, 23, Value.get(rgnstr), Value.get(rgnstr));
    }

    public static Filter geoContains(String name, String point) {
        return new Filter(name, IndexCollectionType.DEFAULT, 23, Value.get(point), Value.get(point));
    }

    public static Filter geoContains(String name, IndexCollectionType type, String point) {
        return new Filter(name, type, 23, Value.get(point), Value.get(point));
    }

    private Filter(String name, IndexCollectionType colType, int valType, Value begin, Value end) {
        this.name = name;
        this.valType = valType;
        this.colType = colType;
        this.begin = begin;
        this.end = end;
    }

    public int estimateSize() throws AerospikeException {
        return Buffer.estimateSizeUtf8(this.name) + this.begin.estimateSize() + this.end.estimateSize() + 10;
    }

    public int write(byte[] buf, int offset) throws AerospikeException {
        int len = Buffer.stringToUtf8(this.name, buf, offset + 1);
        buf[offset] = (byte)len;
        offset += len + 1;
        buf[offset++] = (byte)this.valType;
        len = this.begin.write(buf, offset + 4);
        Buffer.intToBytes(len, buf, offset);
        offset += len + 4;
        len = this.end.write(buf, offset + 4);
        Buffer.intToBytes(len, buf, offset);
        return offset += len + 4;
    }

    public IndexCollectionType getCollectionType() {
        return this.colType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Filter other = (Filter)obj;
        if (this.begin == null ? other.begin != null : !this.begin.equals(other.begin)) {
            return false;
        }
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.colType != other.colType) {
            return false;
        }
        return this.valType == other.valType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.begin == null ? 0 : this.begin.hashCode());
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.colType == null ? 0 : this.colType.hashCode());
        result = 31 * result + this.valType;
        return result;
    }
}

