/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.Key;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.query.PartitionStatus;
import java.io.Serializable;

public final class PartitionFilter
implements Serializable {
    private static final long serialVersionUID = 4L;
    final int begin;
    final int count;
    final byte[] digest;
    PartitionStatus[] partitions;
    boolean done;
    boolean retry;

    public static PartitionFilter all() {
        return new PartitionFilter(0, 4096);
    }

    public static PartitionFilter id(int id) {
        return new PartitionFilter(id, 1);
    }

    public static PartitionFilter after(Key key) {
        return new PartitionFilter(key.digest);
    }

    public static PartitionFilter range(int begin, int count) {
        return new PartitionFilter(begin, count);
    }

    private PartitionFilter(int begin, int count) {
        this.begin = begin;
        this.count = count;
        this.digest = null;
    }

    private PartitionFilter(byte[] digest) {
        this.begin = Partition.getPartitionId(digest);
        this.count = 1;
        this.digest = digest;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public PartitionStatus[] getPartitions() {
        return this.partitions;
    }

    public void setPartitions(PartitionStatus[] partitions) {
        this.partitions = partitions;
    }

    public boolean isDone() {
        return this.done;
    }
}

