/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncInfoCommand;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.listener.InfoListener;
import java.util.Map;

public final class AsyncQueryValidate {
    public static void validateBegin(Cluster cluster, EventLoop eventLoop, BeginListener listener, Node node, String namespace) {
        String command = "cluster-stable:namespace=" + namespace;
        AsyncInfoCommand aic = new AsyncInfoCommand(new BeginHandler(listener, command), null, node, command);
        eventLoop.execute(cluster, aic);
    }

    public static void validate(Cluster cluster, EventLoop eventLoop, Listener listener, Node node, String namespace, long expectedKey) {
        String command = "cluster-stable:namespace=" + namespace;
        AsyncInfoCommand aic = new AsyncInfoCommand(new Handler(listener, command, expectedKey), null, node, command);
        eventLoop.execute(cluster, aic);
    }

    private static class Handler
    implements InfoListener {
        private final Listener listener;
        private final String command;
        private final long expectedKey;

        private Handler(Listener listener, String command, long expectedKey) {
            this.listener = listener;
            this.command = command;
            this.expectedKey = expectedKey;
        }

        @Override
        public void onSuccess(Map<String, String> map) {
            String result = map.get(this.command);
            long clusterKey = 0L;
            try {
                clusterKey = Long.parseLong(result, 16);
            }
            catch (Exception e) {
                this.listener.onFailure(new AerospikeException(210, "Cluster is in migration: " + result));
                return;
            }
            if (clusterKey != this.expectedKey) {
                this.listener.onFailure(new AerospikeException(210, "Cluster is in migration: " + this.expectedKey + ' ' + clusterKey));
                return;
            }
            this.listener.onSuccess();
        }

        @Override
        public void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    public static interface Listener {
        public void onSuccess();

        public void onFailure(AerospikeException var1);
    }

    private static class BeginHandler
    implements InfoListener {
        private final BeginListener listener;
        private final String command;

        private BeginHandler(BeginListener listener, String command) {
            this.listener = listener;
            this.command = command;
        }

        @Override
        public void onSuccess(Map<String, String> map) {
            String result = map.get(this.command);
            long clusterKey = 0L;
            try {
                clusterKey = Long.parseLong(result, 16);
            }
            catch (Exception e) {
                this.listener.onFailure(new AerospikeException(210, "Cluster is in migration: " + result));
                return;
            }
            this.listener.onSuccess(clusterKey);
        }

        @Override
        public void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    public static interface BeginListener {
        public void onSuccess(long var1);

        public void onFailure(AerospikeException var1);
    }
}

