/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import java.util.HashMap;

public final class RackParser {
    static final String RebalanceGeneration = "rebalance-generation";
    static final String RackIds = "rack-ids";
    private final HashMap<String, Integer> racks = new HashMap();
    private final StringBuilder sb;
    private final byte[] buffer;
    private final int generation;
    private int length;
    private int offset;

    public RackParser(Connection conn, Node node) {
        Info info = new Info(conn, RebalanceGeneration, RackIds);
        this.length = info.length;
        if (this.length == 0) {
            throw new AerospikeException.Parse("rack-ids response is empty");
        }
        this.buffer = info.buffer;
        this.sb = new StringBuilder(32);
        this.generation = this.parseGeneration();
        this.parseRacks(node);
    }

    public int getGeneration() {
        return this.generation;
    }

    public HashMap<String, Integer> getRacks() {
        return this.racks;
    }

    private int parseGeneration() {
        this.expectName(RebalanceGeneration);
        int begin = this.offset;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 10) {
                String s = Buffer.utf8ToString(this.buffer, begin, this.offset - begin, this.sb).trim();
                ++this.offset;
                return Integer.parseInt(s);
            }
            ++this.offset;
        }
        throw new AerospikeException.Parse("Failed to find rebalance-generation");
    }

    private void parseRacks(Node node) {
        this.expectName(RackIds);
        int begin = this.offset;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 58) {
                byte b;
                String namespace = Buffer.utf8ToString(this.buffer, begin, this.offset - begin, this.sb).trim();
                if (namespace.length() <= 0 || namespace.length() >= 32) {
                    String response = this.getTruncatedResponse();
                    throw new AerospikeException.Parse("Invalid racks namespace " + namespace + ". Response=" + response);
                }
                begin = ++this.offset;
                while (this.offset < this.length && (b = this.buffer[this.offset]) != 59 && b != 10) {
                    ++this.offset;
                }
                int rack = Integer.parseInt(new String(this.buffer, begin, this.offset - begin));
                this.racks.put(namespace, rack);
                begin = ++this.offset;
                continue;
            }
            ++this.offset;
        }
    }

    private void expectName(String name) throws AerospikeException {
        int begin = this.offset;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 9) {
                String s = Buffer.utf8ToString(this.buffer, begin, this.offset - begin, this.sb).trim();
                if (!name.equals(s)) break;
                ++this.offset;
                return;
            }
            ++this.offset;
        }
        throw new AerospikeException.Parse("Failed to find " + name);
    }

    private String getTruncatedResponse() {
        int max = this.length > 200 ? 200 : this.length;
        return Buffer.utf8ToString(this.buffer, 0, max);
    }
}

