/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;

public final class QueryRecordCommand
extends MultiCommand {
    private final Statement statement;
    private final RecordSet recordSet;
    private final long taskId;

    public QueryRecordCommand(Cluster cluster, Node node, QueryPolicy policy, Statement statement, long taskId, RecordSet recordSet, long clusterKey, boolean first) {
        super(cluster, (Policy)policy, node, statement.namespace, clusterKey, first);
        this.statement = statement;
        this.taskId = taskId;
        this.recordSet = recordSet;
    }

    @Override
    protected final void writeBuffer() {
        this.setQuery(this.cluster, this.policy, this.statement, this.taskId, false, null);
    }

    @Override
    protected void parseRow() {
        Key key = this.parseKey(this.fieldCount, null);
        if (this.resultCode != 0) {
            throw new AerospikeException(this.resultCode);
        }
        Record record = this.parseRecord();
        if (!this.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        if (!this.recordSet.put(new KeyRecord(key, record))) {
            this.stop();
            throw new AerospikeException.QueryTerminated();
        }
    }
}

