/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.policy.TlsPolicy;
import com.aerospike.client.util.Util;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;

public final class NettyTlsContext
implements CipherSuiteFilter {
    private final TlsPolicy policy;
    private final SslContext context;

    public NettyTlsContext(TlsPolicy policy) {
        this.policy = policy;
        if (policy.context != null) {
            NettyTlsContext csf = policy.ciphers != null ? this : IdentityCipherSuiteFilter.INSTANCE;
            this.context = new JdkSslContext(policy.context, true, null, (CipherSuiteFilter)csf, null, ClientAuth.NONE, null, false);
            return;
        }
        try {
            String keyStoreLocation;
            SslContextBuilder builder = SslContextBuilder.forClient();
            if (policy.protocols != null) {
                builder.protocols(policy.protocols);
            }
            if (policy.ciphers != null) {
                builder.ciphers(Arrays.asList(policy.ciphers));
            }
            if ((keyStoreLocation = System.getProperty("javax.net.ssl.keyStore")) != null) {
                String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
                char[] pass = keyStorePassword != null ? keyStorePassword.toCharArray() : null;
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                try (FileInputStream is = new FileInputStream(keyStoreLocation);){
                    ks.load(is, pass);
                }
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, pass);
                builder.keyManager(kmf);
            }
            this.context = builder.build();
        }
        catch (Exception e) {
            throw new AerospikeException("Failed to init netty TLS: " + Util.getErrorMessage(e));
        }
    }

    public SslHandler createHandler(SocketChannel ch) {
        return this.context.newHandler(ch.alloc());
    }

    public String[] filterCipherSuites(Iterable<String> ciphers, List<String> defaultCiphers, Set<String> supportedCiphers) {
        if (this.policy.ciphers != null) {
            return this.policy.ciphers;
        }
        return this.policy.context.getSupportedSSLParameters().getCipherSuites();
    }
}

