/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.policy.Policy;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class ReadCommand
extends SyncCommand {
    protected final Key key;
    protected final Partition partition;
    private final String[] binNames;
    private final boolean isOperation;
    private Record record;

    public ReadCommand(Cluster cluster, Policy policy, Key key) {
        super(cluster, policy);
        this.key = key;
        this.binNames = null;
        this.partition = Partition.read(cluster, policy, key);
        this.isOperation = false;
    }

    public ReadCommand(Cluster cluster, Policy policy, Key key, String[] binNames) {
        super(cluster, policy);
        this.key = key;
        this.binNames = binNames;
        this.partition = Partition.read(cluster, policy, key);
        this.isOperation = false;
    }

    public ReadCommand(Cluster cluster, Policy policy, Key key, Partition partition, boolean isOperation) {
        super(cluster, policy);
        this.key = key;
        this.binNames = null;
        this.partition = partition;
        this.isOperation = isOperation;
    }

    @Override
    protected Node getNode() {
        return this.partition.getNodeRead(this.cluster);
    }

    @Override
    protected void writeBuffer() {
        this.setRead(this.policy, this.key, this.binNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parseResult(Connection conn) throws IOException {
        conn.readFully(this.dataBuffer, 8, (byte)2);
        long sz = Buffer.bytesToLong(this.dataBuffer, 0);
        int receiveSize = (int)(sz & 0xFFFFFFFFFFFFL);
        if (receiveSize <= 0) {
            throw new AerospikeException("Invalid receive size: " + receiveSize);
        }
        this.sizeBuffer(receiveSize);
        conn.readFully(this.dataBuffer, receiveSize, (byte)3);
        conn.updateLastUsed();
        long type = sz >> 48 & 0xFFL;
        if (type == 3L) {
            this.dataOffset = 5;
        } else {
            if (type == 4L) {
                int usize = (int)Buffer.bytesToLong(this.dataBuffer, 0);
                byte[] buf = new byte[usize];
                Inflater inf = new Inflater();
                try {
                    int rsize;
                    inf.setInput(this.dataBuffer, 8, receiveSize - 8);
                    try {
                        rsize = inf.inflate(buf);
                    }
                    catch (DataFormatException dfe) {
                        throw new AerospikeException.Serialize(dfe);
                    }
                    if (rsize != usize) {
                        throw new AerospikeException("Decompressed size " + rsize + " is not expected " + usize);
                    }
                    this.dataBuffer = buf;
                    this.dataOffset = 13;
                }
                finally {
                    inf.end();
                }
            }
            throw new AerospikeException("Invalid proto type: " + type + " Expected: " + 3L);
        }
        int resultCode = this.dataBuffer[this.dataOffset] & 0xFF;
        ++this.dataOffset;
        int generation = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        int expiration = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
        this.dataOffset += 8;
        int fieldCount = Buffer.bytesToShort(this.dataBuffer, this.dataOffset);
        this.dataOffset += 2;
        int opCount = Buffer.bytesToShort(this.dataBuffer, this.dataOffset);
        this.dataOffset += 2;
        if (resultCode == 0) {
            if (opCount == 0) {
                this.record = new Record(null, generation, expiration);
                return;
            }
            this.skipKey(fieldCount);
            this.record = this.parseRecord(opCount, generation, expiration, this.isOperation);
            return;
        }
        if (resultCode == 2) {
            this.handleNotFound(resultCode);
            return;
        }
        if (resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            return;
        }
        if (resultCode == 100) {
            this.skipKey(fieldCount);
            this.record = this.parseRecord(opCount, generation, expiration, this.isOperation);
            this.handleUdfError(resultCode);
            return;
        }
        throw new AerospikeException(resultCode);
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryRead(timeout);
        return true;
    }

    protected void handleNotFound(int resultCode) {
    }

    private void handleUdfError(int resultCode) {
        String message;
        int code;
        String ret = (String)this.record.bins.get("FAILURE");
        if (ret == null) {
            throw new AerospikeException(resultCode);
        }
        try {
            String[] list = ret.split(":");
            code = Integer.parseInt(list[2].trim());
            message = list[0] + ':' + list[1] + ' ' + list[3];
        }
        catch (Exception e) {
            throw new AerospikeException(resultCode, ret);
        }
        throw new AerospikeException(code, message);
    }

    public Record getRecord() {
        return this.record;
    }
}

