/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchAttr;
import com.aerospike.client.command.BatchExecutor;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.BatchNodeList;
import com.aerospike.client.command.BatchStatus;
import com.aerospike.client.command.Command;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.ReadModeSC;
import com.aerospike.client.policy.Replica;
import java.util.List;

public final class Batch {

    public static abstract class BatchCommand
    extends MultiCommand
    implements Runnable {
        final BatchNode batch;
        final BatchPolicy batchPolicy;
        final BatchStatus status;
        BatchExecutor parent;
        int sequenceAP;
        int sequenceSC;
        boolean splitRetry;

        public BatchCommand(Cluster cluster, BatchNode batch, BatchPolicy batchPolicy, BatchStatus status, boolean isOperation) {
            super(cluster, (Policy)batchPolicy, batch.node, isOperation);
            this.batch = batch;
            this.batchPolicy = batchPolicy;
            this.status = status;
        }

        @Override
        public void run() {
            try {
                this.execute();
            }
            catch (AerospikeException ae) {
                if (!this.splitRetry) {
                    this.setInDoubt(ae.getInDoubt());
                }
                this.status.setException(ae);
            }
            catch (RuntimeException re) {
                if (!this.splitRetry) {
                    this.setInDoubt(true);
                }
                this.status.setException(re);
            }
            finally {
                this.parent.onComplete();
            }
        }

        @Override
        protected boolean prepareRetry(boolean timeout) {
            if (this.batchPolicy.replica != Replica.SEQUENCE && this.batchPolicy.replica != Replica.PREFER_RACK || this.parent != null && this.parent.isDone()) {
                return true;
            }
            ++this.sequenceAP;
            if (!timeout || this.batchPolicy.readModeSC != ReadModeSC.LINEARIZE) {
                ++this.sequenceSC;
            }
            return false;
        }

        @Override
        protected boolean retryBatch(Cluster cluster, int socketTimeout, int totalTimeout, long deadline, int iteration, int commandSentCounter) {
            List<BatchNode> batchNodes = this.generateBatchNodes();
            if (batchNodes.size() == 1 && batchNodes.get((int)0).node == this.batch.node) {
                return false;
            }
            this.splitRetry = true;
            for (BatchNode batchNode : batchNodes) {
                BatchCommand command = this.createCommand(batchNode);
                command.parent = this.parent;
                command.sequenceAP = this.sequenceAP;
                command.sequenceSC = this.sequenceSC;
                command.socketTimeout = socketTimeout;
                command.totalTimeout = totalTimeout;
                command.iteration = iteration;
                command.commandSentCounter = commandSentCounter;
                command.deadline = deadline;
                try {
                    command.executeCommand();
                }
                catch (AerospikeException ae) {
                    if (!command.splitRetry) {
                        command.setInDoubt(ae.getInDoubt());
                    }
                    this.status.setException(ae);
                    if (this.batchPolicy.respondAllKeys) continue;
                    throw ae;
                }
                catch (RuntimeException re) {
                    if (!command.splitRetry) {
                        command.setInDoubt(true);
                    }
                    this.status.setException(re);
                    if (this.batchPolicy.respondAllKeys) continue;
                    throw re;
                }
            }
            return true;
        }

        protected void setInDoubt(boolean inDoubt) {
        }

        abstract BatchCommand createCommand(BatchNode var1);

        abstract List<BatchNode> generateBatchNodes();
    }

    public static final class UDFCommand
    extends BatchCommand {
        private final Key[] keys;
        private final String packageName;
        private final String functionName;
        private final byte[] argBytes;
        private final BatchRecord[] records;
        private final BatchAttr attr;

        public UDFCommand(Cluster cluster, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, String packageName, String functionName, byte[] argBytes, BatchRecord[] records, BatchAttr attr, BatchStatus status) {
            super(cluster, batch, batchPolicy, status, false);
            this.keys = keys;
            this.packageName = packageName;
            this.functionName = functionName;
            this.argBytes = argBytes;
            this.records = records;
            this.attr = attr;
        }

        @Override
        protected boolean isWrite() {
            return this.attr.hasWrite;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchUDF(this.batchPolicy, this.keys, this.batch, this.packageName, this.functionName, this.argBytes, this.attr);
        }

        @Override
        protected boolean parseRow() {
            Record r;
            String m;
            this.skipKey(this.fieldCount);
            BatchRecord record = this.records[this.batchIndex];
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
                return true;
            }
            if (this.resultCode == 100 && (m = (r = this.parseRecord()).getString("FAILURE")) != null) {
                record.record = r;
                record.resultCode = this.resultCode;
                record.inDoubt = Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter);
                this.status.setRowError();
                return true;
            }
            record.setError(this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter));
            this.status.setRowError();
            return true;
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            if (!inDoubt || !this.attr.hasWrite) {
                return;
            }
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records[index2];
                if (record.resultCode != -15) continue;
                record.inDoubt = inDoubt;
            }
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new UDFCommand(this.cluster, batchNode, this.batchPolicy, this.keys, this.packageName, this.functionName, this.argBytes, this.records, this.attr, this.status);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.cluster, this.batchPolicy, this.keys, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.attr.hasWrite, (BatchNodeList.IBatchStatus)this.status);
        }
    }

    public static final class OperateArrayCommand
    extends BatchCommand {
        private final Key[] keys;
        private final Operation[] ops;
        private final BatchRecord[] records;
        private final BatchAttr attr;

        public OperateArrayCommand(Cluster cluster, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, Operation[] ops, BatchRecord[] records, BatchAttr attr, BatchStatus status) {
            super(cluster, batch, batchPolicy, status, ops != null);
            this.keys = keys;
            this.ops = ops;
            this.records = records;
            this.attr = attr;
        }

        @Override
        protected boolean isWrite() {
            return this.attr.hasWrite;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchOperate(this.batchPolicy, this.keys, this.batch, null, this.ops, this.attr);
        }

        @Override
        protected boolean parseRow() {
            this.skipKey(this.fieldCount);
            BatchRecord record = this.records[this.batchIndex];
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
            } else {
                record.setError(this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter));
                this.status.setRowError();
            }
            return true;
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            if (!inDoubt || !this.attr.hasWrite) {
                return;
            }
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records[index2];
                if (record.resultCode != -15) continue;
                record.inDoubt = inDoubt;
            }
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new OperateArrayCommand(this.cluster, batchNode, this.batchPolicy, this.keys, this.ops, this.records, this.attr, this.status);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.cluster, this.batchPolicy, this.keys, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.attr.hasWrite, (BatchNodeList.IBatchStatus)this.status);
        }
    }

    public static final class OperateListCommand
    extends BatchCommand {
        private final List<BatchRecord> records;

        public OperateListCommand(Cluster cluster, BatchNode batch, BatchPolicy policy, List<BatchRecord> records, BatchStatus status) {
            super(cluster, batch, policy, status, true);
            this.records = records;
        }

        @Override
        protected boolean isWrite() {
            return true;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchOperate(this.batchPolicy, this.records, this.batch);
        }

        @Override
        protected boolean parseRow() {
            Record r;
            String m;
            this.skipKey(this.fieldCount);
            BatchRecord record = this.records.get(this.batchIndex);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
                return true;
            }
            if (this.resultCode == 100 && (m = (r = this.parseRecord()).getString("FAILURE")) != null) {
                record.record = r;
                record.resultCode = this.resultCode;
                record.inDoubt = Command.batchInDoubt(record.hasWrite, this.commandSentCounter);
                this.status.setRowError();
                return true;
            }
            record.setError(this.resultCode, Command.batchInDoubt(record.hasWrite, this.commandSentCounter));
            this.status.setRowError();
            return true;
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            if (!inDoubt) {
                return;
            }
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records.get(index2);
                if (record.resultCode != -15) continue;
                record.inDoubt = record.hasWrite;
            }
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new OperateListCommand(this.cluster, batchNode, this.batchPolicy, this.records, this.status);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.status);
        }
    }

    public static final class ExistsArrayCommand
    extends BatchCommand {
        private final Key[] keys;
        private final boolean[] existsArray;

        public ExistsArrayCommand(Cluster cluster, BatchNode batch, BatchPolicy policy, Key[] keys, boolean[] existsArray, BatchStatus status) {
            super(cluster, batch, policy, status, false);
            this.keys = keys;
            this.existsArray = existsArray;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                BatchAttr attr = new BatchAttr(this.policy, 33);
                this.setBatchOperate(this.batchPolicy, this.keys, this.batch, null, null, attr);
            } else {
                this.setBatchRead(this.batchPolicy, this.keys, this.batch, null, null, 33);
            }
        }

        @Override
        protected boolean parseRow() {
            this.skipKey(this.fieldCount);
            if (this.opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            this.existsArray[this.batchIndex] = this.resultCode == 0;
            return true;
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new ExistsArrayCommand(this.cluster, batchNode, this.batchPolicy, this.keys, this.existsArray, this.status);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false, this.status);
        }
    }

    public static final class GetArrayCommand
    extends BatchCommand {
        private final Key[] keys;
        private final String[] binNames;
        private final Operation[] ops;
        private final Record[] records;
        private final int readAttr;

        public GetArrayCommand(Cluster cluster, BatchNode batch, BatchPolicy policy, Key[] keys, String[] binNames, Operation[] ops, Record[] records, int readAttr, boolean isOperation, BatchStatus status) {
            super(cluster, batch, policy, status, isOperation);
            this.keys = keys;
            this.binNames = binNames;
            this.ops = ops;
            this.records = records;
            this.readAttr = readAttr;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                BatchAttr attr = new BatchAttr(this.policy, this.readAttr, this.ops);
                this.setBatchOperate(this.batchPolicy, this.keys, this.batch, this.binNames, this.ops, attr);
            } else {
                this.setBatchRead(this.batchPolicy, this.keys, this.batch, this.binNames, this.ops, this.readAttr);
            }
        }

        @Override
        protected boolean parseRow() {
            this.skipKey(this.fieldCount);
            if (this.resultCode == 0) {
                this.records[this.batchIndex] = this.parseRecord();
            }
            return true;
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new GetArrayCommand(this.cluster, batchNode, this.batchPolicy, this.keys, this.binNames, this.ops, this.records, this.readAttr, this.isOperation, this.status);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false, this.status);
        }
    }

    public static final class ReadListCommand
    extends BatchCommand {
        private final List<BatchRead> records;

        public ReadListCommand(Cluster cluster, BatchNode batch, BatchPolicy policy, List<BatchRead> records, BatchStatus status) {
            super(cluster, batch, policy, status, true);
            this.records = records;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                this.setBatchOperate(this.batchPolicy, this.records, this.batch);
            } else {
                this.setBatchRead(this.batchPolicy, this.records, this.batch);
            }
        }

        @Override
        protected boolean parseRow() {
            this.skipKey(this.fieldCount);
            BatchRead record = this.records.get(this.batchIndex);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
            } else {
                record.setError(this.resultCode, false);
                this.status.setRowError();
            }
            return true;
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new ReadListCommand(this.cluster, batchNode, this.batchPolicy, this.records, this.status);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.status);
        }
    }
}

