/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.admin;

import com.aerospike.client.AerospikeException;

public enum PrivilegeCode {
    USER_ADMIN(0, "user-admin"),
    SYS_ADMIN(1, "sys-admin"),
    DATA_ADMIN(2, "data-admin"),
    UDF_ADMIN(3, "udf-admin"),
    SINDEX_ADMIN(4, "sindex-admin"),
    READ(10, "read"),
    READ_WRITE(11, "read-write"),
    READ_WRITE_UDF(12, "read-write-udf"),
    WRITE(13, "write"),
    TRUNCATE(14, "truncate");

    public final int id;
    private final String value;

    private PrivilegeCode(int id, String value) {
        this.id = id;
        this.value = value;
    }

    public boolean canScope() {
        return this.id >= 10;
    }

    public static PrivilegeCode fromId(int id) {
        switch (id) {
            case 0: {
                return USER_ADMIN;
            }
            case 1: {
                return SYS_ADMIN;
            }
            case 2: {
                return DATA_ADMIN;
            }
            case 3: {
                return UDF_ADMIN;
            }
            case 4: {
                return SINDEX_ADMIN;
            }
            case 10: {
                return READ;
            }
            case 11: {
                return READ_WRITE;
            }
            case 12: {
                return READ_WRITE_UDF;
            }
            case 13: {
                return WRITE;
            }
            case 14: {
                return TRUNCATE;
            }
        }
        throw new AerospikeException("Invalid privilege code: " + id);
    }

    public String toString() {
        return this.value;
    }
}

