/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cdt;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CDT;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cdt.ListOrder;
import com.aerospike.client.cdt.ListPolicy;
import com.aerospike.client.util.Pack;
import com.aerospike.client.util.Packer;
import java.util.List;

public class ListOperation {
    private static final int SET_TYPE = 0;
    private static final int APPEND = 1;
    private static final int APPEND_ITEMS = 2;
    private static final int INSERT = 3;
    private static final int INSERT_ITEMS = 4;
    private static final int POP = 5;
    private static final int POP_RANGE = 6;
    private static final int REMOVE = 7;
    private static final int REMOVE_RANGE = 8;
    private static final int SET = 9;
    private static final int TRIM = 10;
    private static final int CLEAR = 11;
    private static final int INCREMENT = 12;
    private static final int SORT = 13;
    private static final int SIZE = 16;
    private static final int GET = 17;
    private static final int GET_RANGE = 18;
    private static final int GET_BY_INDEX = 19;
    private static final int GET_BY_RANK = 21;
    private static final int GET_BY_VALUE = 22;
    private static final int GET_BY_VALUE_LIST = 23;
    private static final int GET_BY_INDEX_RANGE = 24;
    private static final int GET_BY_VALUE_INTERVAL = 25;
    private static final int GET_BY_RANK_RANGE = 26;
    private static final int GET_BY_VALUE_REL_RANK_RANGE = 27;
    private static final int REMOVE_BY_INDEX = 32;
    private static final int REMOVE_BY_RANK = 34;
    private static final int REMOVE_BY_VALUE = 35;
    private static final int REMOVE_BY_VALUE_LIST = 36;
    private static final int REMOVE_BY_INDEX_RANGE = 37;
    private static final int REMOVE_BY_VALUE_INTERVAL = 38;
    private static final int REMOVE_BY_RANK_RANGE = 39;
    private static final int REMOVE_BY_VALUE_REL_RANK_RANGE = 40;

    public static Operation create(String binName, ListOrder order, boolean pad, CTX ... ctx) {
        if (ctx == null || ctx.length == 0) {
            return ListOperation.setOrder(binName, order, new CTX[0]);
        }
        Packer packer = new Packer();
        CDT.init(packer, ctx, 0, 1, order.getFlag(pad));
        packer.packInt(order.attributes);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation setOrder(String binName, ListOrder order, CTX ... ctx) {
        byte[] bytes = Pack.pack(0, order.attributes, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation append(String binName, Value value, CTX ... ctx) {
        byte[] bytes = Pack.pack(1, value, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation append(ListPolicy policy, String binName, Value value, CTX ... ctx) {
        byte[] bytes = Pack.pack(1, value, policy.attributes, policy.flags, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation appendItems(String binName, List<Value> list, CTX ... ctx) {
        byte[] bytes = Pack.pack(2, list, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation appendItems(ListPolicy policy, String binName, List<Value> list, CTX ... ctx) {
        byte[] bytes = Pack.pack(2, list, policy.attributes, policy.flags, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation insert(String binName, int index2, Value value, CTX ... ctx) {
        byte[] bytes = Pack.pack(3, index2, value, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation insert(ListPolicy policy, String binName, int index2, Value value, CTX ... ctx) {
        byte[] bytes = Pack.pack(3, index2, value, policy.flags, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation insertItems(String binName, int index2, List<Value> list, CTX ... ctx) {
        byte[] bytes = Pack.pack(4, index2, list, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation insertItems(ListPolicy policy, String binName, int index2, List<Value> list, CTX ... ctx) {
        byte[] bytes = Pack.pack(4, index2, list, policy.flags, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation increment(String binName, int index2, CTX ... ctx) {
        byte[] bytes = Pack.pack(12, index2, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation increment(ListPolicy policy, String binName, int index2, CTX ... ctx) {
        byte[] bytes = Pack.pack(12, index2, Value.get(1), policy.attributes, policy.flags, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation increment(String binName, int index2, Value value, CTX ... ctx) {
        byte[] bytes = Pack.pack(12, index2, value, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation increment(ListPolicy policy, String binName, int index2, Value value, CTX ... ctx) {
        byte[] bytes = Pack.pack(12, index2, value, policy.attributes, policy.flags, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation pop(String binName, int index2, CTX ... ctx) {
        byte[] bytes = Pack.pack(5, index2, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation popRange(String binName, int index2, int count, CTX ... ctx) {
        byte[] bytes = Pack.pack(6, index2, count, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation popRange(String binName, int index2, CTX ... ctx) {
        byte[] bytes = Pack.pack(6, index2, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation remove(String binName, int index2, CTX ... ctx) {
        byte[] bytes = Pack.pack(7, index2, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeRange(String binName, int index2, int count, CTX ... ctx) {
        byte[] bytes = Pack.pack(8, index2, count, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeRange(String binName, int index2, CTX ... ctx) {
        byte[] bytes = Pack.pack(8, index2, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation set(String binName, int index2, Value value, CTX ... ctx) {
        byte[] bytes = Pack.pack(9, index2, value, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation set(ListPolicy policy, String binName, int index2, Value value, CTX ... ctx) {
        byte[] bytes = Pack.pack(9, index2, value, policy.flags, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation trim(String binName, int index2, int count, CTX ... ctx) {
        byte[] bytes = Pack.pack(10, index2, count, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation clear(String binName, CTX ... ctx) {
        byte[] bytes = Pack.pack(11, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation sort(String binName, int sortFlags, CTX ... ctx) {
        byte[] bytes = Pack.pack(13, sortFlags, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByValue(String binName, Value value, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(35, returnType, value, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByValueList(String binName, List<Value> values, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(36, returnType, values, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByValueRange(String binName, Value valueBegin, Value valueEnd, int returnType, CTX ... ctx) {
        byte[] bytes = CDT.packRangeOperation(38, returnType, valueBegin, valueEnd, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByValueRelativeRankRange(String binName, Value value, int rank, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(40, returnType, value, rank, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByValueRelativeRankRange(String binName, Value value, int rank, int count, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(40, returnType, value, rank, count, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByIndex(String binName, int index2, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(32, returnType, index2, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByIndexRange(String binName, int index2, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(37, returnType, index2, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByIndexRange(String binName, int index2, int count, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(37, returnType, index2, count, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByRank(String binName, int rank, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(34, returnType, rank, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByRankRange(String binName, int rank, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(39, returnType, rank, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeByRankRange(String binName, int rank, int count, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(39, returnType, rank, count, ctx);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation size(String binName, CTX ... ctx) {
        byte[] bytes = Pack.pack(16, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation get(String binName, int index2, CTX ... ctx) {
        byte[] bytes = Pack.pack(17, index2, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getRange(String binName, int index2, int count, CTX ... ctx) {
        byte[] bytes = Pack.pack(18, index2, count, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getRange(String binName, int index2, CTX ... ctx) {
        byte[] bytes = Pack.pack(18, index2, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getByValue(String binName, Value value, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(22, returnType, value, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getByValueRange(String binName, Value valueBegin, Value valueEnd, int returnType, CTX ... ctx) {
        byte[] bytes = CDT.packRangeOperation(25, returnType, valueBegin, valueEnd, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getByValueList(String binName, List<Value> values, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(23, returnType, values, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getByValueRelativeRankRange(String binName, Value value, int rank, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(27, returnType, value, rank, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getByValueRelativeRankRange(String binName, Value value, int rank, int count, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(27, returnType, value, rank, count, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getByIndex(String binName, int index2, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(19, returnType, index2, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getByIndexRange(String binName, int index2, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(24, returnType, index2, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getByIndexRange(String binName, int index2, int count, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(24, returnType, index2, count, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getByRank(String binName, int rank, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(21, returnType, rank, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getByRankRange(String binName, int rank, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(26, returnType, rank, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getByRankRange(String binName, int rank, int count, int returnType, CTX ... ctx) {
        byte[] bytes = Pack.pack(26, returnType, rank, count, ctx);
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }
}

