/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.query.BVal;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.query.QueryListener;
import com.aerospike.client.query.Statement;

public final class QueryListenerCommand
extends MultiCommand {
    private final Statement statement;
    private final long taskId;
    private final QueryListener listener;
    private final PartitionTracker tracker;
    private final PartitionTracker.NodePartitions nodePartitions;

    public QueryListenerCommand(Cluster cluster, Node node, Policy policy, Statement statement, long taskId, QueryListener listener, PartitionTracker tracker, PartitionTracker.NodePartitions nodePartitions) {
        super(cluster, policy, nodePartitions.node, statement.namespace, tracker.socketTimeout, tracker.totalTimeout);
        this.statement = statement;
        this.taskId = taskId;
        this.listener = listener;
        this.tracker = tracker;
        this.nodePartitions = nodePartitions;
    }

    @Override
    public void execute() {
        block2: {
            try {
                this.executeCommand();
            }
            catch (AerospikeException ae) {
                if (this.tracker.shouldRetry(this.nodePartitions, ae)) break block2;
                throw ae;
            }
        }
    }

    @Override
    protected final void writeBuffer() {
        this.setQuery(this.cluster, this.policy, this.statement, this.taskId, false, this.nodePartitions);
    }

    @Override
    protected boolean parseRow() {
        BVal bval = new BVal();
        Key key = this.parseKey(this.fieldCount, bval);
        if ((this.info3 & 4) != 0) {
            if (this.resultCode != 0) {
                this.tracker.partitionUnavailable(this.nodePartitions, this.generation);
            }
            return true;
        }
        if (this.resultCode != 0) {
            throw new AerospikeException(this.resultCode);
        }
        Record record = this.parseRecord();
        if (!this.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        this.listener.onRecord(key, record);
        this.tracker.setLast(this.nodePartitions, key, bval.val);
        return true;
    }
}

