/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.HashedWheelTimer;
import com.aerospike.client.async.NettyConnection;
import com.aerospike.client.async.NettyEventLoop;
import com.aerospike.client.async.NettyRecover;
import com.aerospike.client.async.TimeoutState;
import com.aerospike.client.async.TimerTask;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.TCPKeepAlive;
import com.aerospike.client.policy.TlsPolicy;
import com.aerospike.client.util.Util;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.incubator.channel.uring.IOUringSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;

public final class NettyCommand
implements Runnable,
TimerTask {
    private static final long MinHandshakeTimeout = TimeUnit.MILLISECONDS.toNanos(1L);
    final NettyEventLoop eventLoop;
    final Cluster cluster;
    final AsyncCommand command;
    final EventState eventState;
    final HashedWheelTimer.HashedWheelTimeout timeoutTask;
    TimeoutState timeoutState;
    Node node;
    NettyConnection conn;
    long totalDeadline;
    int state;
    int iteration;
    final boolean hasTotalTimeout;
    boolean usingSocketTimeout;
    boolean eventReceived;
    boolean connectInProgress;

    public NettyCommand(NettyEventLoop loop, Cluster cluster, AsyncCommand command) {
        this.eventLoop = loop;
        this.cluster = cluster;
        this.command = command;
        this.eventState = cluster.eventState[loop.index];
        this.timeoutTask = new HashedWheelTimer.HashedWheelTimeout(this);
        command.bufferQueue = loop.bufferQueue;
        boolean bl = this.hasTotalTimeout = command.totalTimeout > 0;
        if (this.eventLoop.eventLoop.inEventLoop() && this.eventState.errors < 5) {
            this.run();
        } else {
            if (this.hasTotalTimeout) {
                this.totalDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(command.totalTimeout);
            }
            this.state = 1;
            this.eventLoop.execute(this);
        }
    }

    public NettyCommand(NettyCommand other, AsyncCommand command, long deadline) {
        this.eventLoop = other.eventLoop;
        this.cluster = other.cluster;
        this.command = command;
        this.eventState = other.eventState;
        this.timeoutTask = new HashedWheelTimer.HashedWheelTimeout(this);
        this.totalDeadline = other.totalDeadline;
        this.iteration = other.iteration;
        this.hasTotalTimeout = other.hasTotalTimeout;
        this.usingSocketTimeout = other.usingSocketTimeout;
        command.bufferQueue = this.eventLoop.bufferQueue;
        if (this.eventState.closed) {
            this.queueError(new AerospikeException("Cluster has been closed"));
            return;
        }
        if (this.eventLoop.maxCommandsInProcess > 0) {
            this.eventLoop.executeFromDelayQueue();
            if (this.eventLoop.pending >= this.eventLoop.maxCommandsInProcess) {
                if (this.eventLoop.maxCommandsInQueue > 0 && this.eventLoop.delayQueue.size() >= this.eventLoop.maxCommandsInQueue) {
                    this.queueError(new AerospikeException.AsyncQueueFull());
                    return;
                }
                this.eventLoop.delayQueue.addLast(this);
                if (deadline > 0L) {
                    this.eventLoop.timer.addTimeout(this.timeoutTask, deadline);
                }
                this.state = 2;
                return;
            }
        }
        ++this.eventState.pending;
        ++this.eventLoop.pending;
        this.executeCommand(deadline, 3);
    }

    @Override
    public void run() {
        if (this.eventState.closed) {
            this.queueError(new AerospikeException("Cluster has been closed"));
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout) {
            currentTime = System.nanoTime();
            if (this.state == 1) {
                if (currentTime >= this.totalDeadline) {
                    this.queueError(new AerospikeException.Timeout(this.command.policy, true));
                    return;
                }
            } else {
                this.totalDeadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.totalTimeout);
            }
        }
        if (this.eventLoop.maxCommandsInProcess > 0) {
            this.eventLoop.executeFromDelayQueue();
            if (this.eventLoop.pending >= this.eventLoop.maxCommandsInProcess) {
                if (this.eventLoop.maxCommandsInQueue > 0 && this.eventLoop.delayQueue.size() >= this.eventLoop.maxCommandsInQueue) {
                    this.queueError(new AerospikeException.AsyncQueueFull());
                    return;
                }
                this.eventLoop.delayQueue.addLast(this);
                if (this.hasTotalTimeout) {
                    this.eventLoop.timer.addTimeout(this.timeoutTask, this.totalDeadline);
                }
                this.state = 2;
                return;
            }
        }
        long deadline = this.totalDeadline;
        if (this.hasTotalTimeout) {
            long socketDeadline;
            if (this.command.socketTimeout > 0 && (socketDeadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout)) < this.totalDeadline) {
                this.usingSocketTimeout = true;
                deadline = socketDeadline;
            }
        } else if (this.command.socketTimeout > 0) {
            this.usingSocketTimeout = true;
            deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
        }
        ++this.eventState.pending;
        ++this.eventLoop.pending;
        this.executeCommand(deadline, 0);
    }

    private void queueError(AerospikeException ae) {
        ++this.eventState.errors;
        this.state = 12;
        this.notifyFailure(ae);
    }

    final void executeCommandFromDelayQueue() {
        long deadline = this.totalDeadline;
        if (this.command.socketTimeout > 0) {
            long socketDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
            if (this.hasTotalTimeout) {
                if (socketDeadline < this.totalDeadline) {
                    this.timeoutTask.cancel();
                    this.usingSocketTimeout = true;
                    deadline = socketDeadline;
                }
            } else {
                this.usingSocketTimeout = true;
                deadline = socketDeadline;
            }
        }
        ++this.eventState.pending;
        ++this.eventLoop.pending;
        this.executeCommand(deadline, 1);
    }

    private void executeCommand(long deadline, int tstate) {
        this.state = 3;
        ++this.iteration;
        try {
            this.node = this.command.getNode(this.cluster);
            this.node.validateErrorCount();
            this.conn = (NettyConnection)this.node.getAsyncConnection(this.eventState.index, null);
            if (this.conn != null) {
                this.setTimeoutTask(deadline, tstate);
                InboundHandler handler = (InboundHandler)this.conn.channel.pipeline().last();
                handler.setCommand(this);
                this.writeCommand();
                return;
            }
            this.connectInProgress = true;
            if (this.command.policy.connectTimeout > 0) {
                this.timeoutState = new TimeoutState(deadline, tstate);
                deadline = this.timeoutState.start + TimeUnit.MILLISECONDS.toNanos(this.command.policy.connectTimeout);
                this.timeoutTask.cancel();
                this.eventLoop.timer.addTimeout(this.timeoutTask, deadline);
            } else {
                this.setTimeoutTask(deadline, tstate);
            }
            final long handshakeDeadline = deadline;
            final InboundHandler handler = new InboundHandler(this);
            Bootstrap b = new Bootstrap();
            NettyCommand.initBootstrap(b, this.cluster, this.eventLoop);
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    if (NettyCommand.this.state != 3) {
                        try {
                            ch.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        NettyCommand.this.connectInProgress = false;
                        return;
                    }
                    NettyCommand.this.state = 4;
                    NettyCommand.this.conn = new NettyConnection(ch);
                    NettyCommand.this.node.connectionOpened(NettyCommand.this.eventLoop.index);
                    NettyCommand.this.connectInProgress = false;
                    ChannelPipeline p = ch.pipeline();
                    if (NettyCommand.this.cluster.tlsPolicy != null && !NettyCommand.this.cluster.tlsPolicy.forLoginOnly) {
                        NettyCommand.this.state = 5;
                        SslHandler hdl = NettyCommand.this.cluster.nettyTlsContext.createHandler(ch);
                        if (handshakeDeadline > 0L) {
                            long timeoutNanos = handshakeDeadline - System.nanoTime();
                            if (timeoutNanos < MinHandshakeTimeout) {
                                timeoutNanos = MinHandshakeTimeout;
                            }
                            hdl.setHandshakeTimeout(timeoutNanos, TimeUnit.NANOSECONDS);
                        }
                        p.addLast(new ChannelHandler[]{hdl});
                    }
                    p.addLast(new ChannelHandler[]{handler});
                }
            });
            b.connect((SocketAddress)this.node.getAddress());
            this.eventState.errors = 0;
        }
        catch (AerospikeException.Connection ac) {
            ++this.eventState.errors;
            this.onNetworkError(ac);
        }
        catch (AerospikeException.Backoff ab) {
            ++this.eventState.errors;
            this.onBackoffError(ab);
        }
        catch (AerospikeException ae) {
            ++this.eventState.errors;
            this.onFatalError(ae);
        }
        catch (Throwable e) {
            ++this.eventState.errors;
            this.onFatalError(new AerospikeException(e));
        }
    }

    static final void initBootstrap(Bootstrap b, Cluster cluster, NettyEventLoop eventLoop) {
        b.group((EventLoopGroup)eventLoop.eventLoop);
        switch (eventLoop.parent.eventLoopType) {
            default: {
                b.channel(NioSocketChannel.class);
                break;
            }
            case NETTY_EPOLL: {
                b.channel(EpollSocketChannel.class);
                TCPKeepAlive keepAlive = cluster.keepAlive;
                if (keepAlive == null) break;
                b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
                b.option(EpollChannelOption.TCP_KEEPIDLE, (Object)keepAlive.idle);
                b.option(EpollChannelOption.TCP_KEEPINTVL, (Object)keepAlive.intvl);
                b.option(EpollChannelOption.TCP_KEEPCNT, (Object)keepAlive.probes);
                break;
            }
            case NETTY_KQUEUE: {
                b.channel(KQueueSocketChannel.class);
                break;
            }
            case NETTY_IOURING: {
                b.channel(IOUringSocketChannel.class);
            }
        }
        b.option(ChannelOption.TCP_NODELAY, (Object)true);
        b.option(ChannelOption.AUTO_READ, (Object)false);
    }

    private void setTimeoutTask(long deadline, int tstate) {
        if (deadline <= 0L) {
            return;
        }
        switch (tstate) {
            case 0: 
            case 3: 
            case 4: {
                this.eventLoop.timer.addTimeout(this.timeoutTask, deadline);
                break;
            }
            case 1: 
            case 2: {
                if (this.timeoutTask.active()) break;
                this.eventLoop.timer.addTimeout(this.timeoutTask, deadline);
                break;
            }
        }
    }

    private void channelActive() {
        byte[] token;
        if (this.cluster.authEnabled && (token = this.node.getSessionToken()) != null) {
            this.writeAuth(token);
            return;
        }
        if (this.timeoutState != null) {
            this.restoreTimeout();
        }
        this.writeCommand();
    }

    private void restoreTimeout() {
        this.timeoutTask.cancel();
        long elapsed = System.nanoTime() - this.timeoutState.start;
        if (this.timeoutState.deadline > 0L) {
            this.timeoutState.deadline += elapsed;
        }
        if (this.totalDeadline > 0L) {
            this.totalDeadline += elapsed;
        }
        this.setTimeoutTask(this.timeoutState.deadline, this.timeoutState.state);
        this.timeoutState = null;
    }

    private void writeAuth(byte[] token) {
        this.state = 6;
        this.command.initBuffer();
        AdminCommand admin = new AdminCommand(this.command.dataBuffer);
        this.command.dataOffset = admin.setAuthenticate(this.cluster, token);
        this.writeByteBuffer();
    }

    private void writeCommand() {
        this.state = 9;
        this.command.writeBuffer();
        this.writeByteBuffer();
    }

    private void writeByteBuffer() {
        ByteBuf byteBuffer = PooledByteBufAllocator.DEFAULT.directBuffer(this.command.dataOffset);
        byteBuffer.clear();
        byteBuffer.writeBytes(this.command.dataBuffer, 0, this.command.dataOffset);
        ChannelFuture cf = this.conn.channel.writeAndFlush((Object)byteBuffer);
        cf.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                switch (NettyCommand.this.state) {
                    case 9: {
                        NettyCommand.this.state = 10;
                        ++NettyCommand.this.command.commandSentCounter;
                        break;
                    }
                    case 6: {
                        NettyCommand.this.state = 7;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                NettyCommand.this.command.dataOffset = 0;
                NettyCommand.this.eventReceived = false;
                NettyCommand.this.conn.channel.config().setAutoRead(true);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void read(ByteBuf byteBuffer) {
        this.eventReceived = true;
        try {
            switch (this.state) {
                case 7: {
                    this.readAuthHeader(byteBuffer);
                    return;
                }
                case 8: {
                    this.readAuthBody(byteBuffer);
                    return;
                }
                case 10: {
                    if (this.command.isSingle) {
                        this.readSingleHeader(byteBuffer);
                        return;
                    }
                    this.readMultiHeader(byteBuffer);
                    return;
                }
                case 11: {
                    if (this.command.isSingle) {
                        this.readSingleBody(byteBuffer);
                        return;
                    }
                    this.readMultiBody(byteBuffer);
                    return;
                }
            }
            return;
        }
        finally {
            byteBuffer.release();
        }
    }

    private void readAuthHeader(ByteBuf byteBuffer) {
        int avail = byteBuffer.readableBytes();
        int offset = this.command.dataOffset + avail;
        if (offset < 8) {
            byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, avail);
            this.command.dataOffset = offset;
            return;
        }
        byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, 8 - this.command.dataOffset);
        this.command.receiveSize = (int)(Buffer.bytesToLong(this.command.dataBuffer, 0) & 0xFFFFFFFFFFFFL);
        if (this.command.receiveSize < 2 || this.command.receiveSize > this.command.dataBuffer.length) {
            throw new AerospikeException.Parse("Invalid auth receive size: " + this.command.receiveSize);
        }
        this.state = 8;
        this.command.dataOffset = offset -= 8;
        if (offset > 0) {
            byteBuffer.readBytes(this.command.dataBuffer, 0, offset);
            if (offset >= this.command.receiveSize) {
                this.parseAuthBody();
            }
        }
    }

    private void readAuthBody(ByteBuf byteBuffer) {
        int avail = byteBuffer.readableBytes();
        int offset = this.command.dataOffset + avail;
        if (offset < this.command.receiveSize) {
            byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, avail);
            this.command.dataOffset = offset;
            return;
        }
        this.parseAuthBody();
    }

    private void parseAuthBody() {
        int resultCode = this.command.dataBuffer[1] & 0xFF;
        if (resultCode != 0 && resultCode != 52) {
            this.node.signalLogin();
            throw new AerospikeException(resultCode);
        }
        if (this.timeoutState != null) {
            this.restoreTimeout();
        }
        this.writeCommand();
    }

    private void readSingleHeader(ByteBuf byteBuffer) {
        int readableBytes = byteBuffer.readableBytes();
        int dataSize = this.command.dataOffset + readableBytes;
        if (dataSize < 8) {
            byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, readableBytes);
            this.command.dataOffset = dataSize;
            return;
        }
        dataSize = 8 - this.command.dataOffset;
        byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, dataSize);
        int receiveSize = this.command.parseProto(Buffer.bytesToLong(this.command.dataBuffer, 0));
        this.command.sizeBuffer(receiveSize);
        this.state = 11;
        dataSize = (readableBytes -= dataSize) >= receiveSize ? receiveSize : readableBytes;
        byteBuffer.readBytes(this.command.dataBuffer, 0, dataSize);
        this.command.dataOffset = dataSize;
        if (this.command.dataOffset >= receiveSize) {
            this.parseSingleBody();
        }
    }

    private void readSingleBody(ByteBuf byteBuffer) {
        int needBytes;
        int readableBytes = byteBuffer.readableBytes();
        int dataSize = readableBytes >= (needBytes = this.command.receiveSize - this.command.dataOffset) ? needBytes : readableBytes;
        byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, dataSize);
        this.command.dataOffset += dataSize;
        if (this.command.dataOffset >= this.command.receiveSize) {
            this.parseSingleBody();
        }
    }

    private void parseSingleBody() {
        this.conn.updateLastUsed();
        this.command.parseCommandResult();
        this.finish();
    }

    private void readMultiHeader(ByteBuf byteBuffer) {
        if (!this.command.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        int readableBytes = byteBuffer.readableBytes();
        while (true) {
            int dataSize;
            if ((dataSize = this.command.dataOffset + readableBytes) < 8) {
                byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, readableBytes);
                this.command.dataOffset = dataSize;
                return;
            }
            dataSize = 8 - this.command.dataOffset;
            byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, dataSize);
            readableBytes -= dataSize;
            int receiveSize = this.command.parseProto(Buffer.bytesToLong(this.command.dataBuffer, 0));
            if (receiveSize == 0) {
                this.command.dataOffset = 0;
                continue;
            }
            this.command.sizeBuffer(receiveSize);
            this.state = 11;
            if (readableBytes <= 0) {
                return;
            }
            dataSize = readableBytes >= receiveSize ? receiveSize : readableBytes;
            byteBuffer.readBytes(this.command.dataBuffer, 0, dataSize);
            readableBytes -= dataSize;
            this.command.dataOffset = dataSize;
            if (this.command.dataOffset < receiveSize) {
                return;
            }
            this.conn.updateLastUsed();
            if (this.command.parseCommandResult()) {
                this.finish();
                return;
            }
            this.state = 10;
            this.command.dataOffset = 0;
        }
    }

    private void readMultiBody(ByteBuf byteBuffer) {
        int needBytes;
        if (!this.command.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        int readableBytes = byteBuffer.readableBytes();
        int dataSize = readableBytes >= (needBytes = this.command.receiveSize - this.command.dataOffset) ? needBytes : readableBytes;
        byteBuffer.readBytes(this.command.dataBuffer, this.command.dataOffset, dataSize);
        this.command.dataOffset += dataSize;
        if (this.command.dataOffset < this.command.receiveSize) {
            return;
        }
        this.conn.updateLastUsed();
        if (this.command.parseCommandResult()) {
            this.finish();
            return;
        }
        this.state = 10;
        this.command.dataOffset = 0;
        this.readMultiHeader(byteBuffer);
    }

    @Override
    public final void timeout() {
        if (this.state == 12) {
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout) {
            currentTime = System.nanoTime();
            if (currentTime >= this.totalDeadline) {
                this.totalTimeout();
                return;
            }
            if (this.usingSocketTimeout && this.eventReceived) {
                this.eventReceived = false;
                long deadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
                if (deadline >= this.totalDeadline) {
                    deadline = this.totalDeadline;
                    this.usingSocketTimeout = false;
                }
                this.eventLoop.timer.addTimeout(this.timeoutTask, deadline);
                return;
            }
        } else if (this.eventReceived) {
            this.eventReceived = false;
            long socketDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
            this.eventLoop.timer.addTimeout(this.timeoutTask, socketDeadline);
            return;
        }
        if (this.iteration > this.command.maxRetries) {
            this.totalTimeout();
            return;
        }
        this.recoverConnection();
        long timeout = TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
        if (this.hasTotalTimeout) {
            long remaining = this.totalDeadline - currentTime;
            if (remaining <= timeout) {
                timeout = remaining;
                this.usingSocketTimeout = false;
            }
        } else {
            currentTime = System.nanoTime();
        }
        long deadline = currentTime + timeout;
        if (!this.command.prepareRetry(true) && this.command.retryBatch(this, deadline)) {
            this.close();
            return;
        }
        this.executeCommand(deadline, 4);
    }

    private void totalTimeout() {
        AerospikeException.Timeout ae = new AerospikeException.Timeout(this.command.policy, true);
        if (this.state == 2) {
            this.closeFromDelayQueue();
            this.notifyFailure(ae);
            return;
        }
        this.recoverConnection();
        this.close();
        this.notifyFailure(ae);
        this.eventLoop.tryDelayQueue();
    }

    private void recoverConnection() {
        if (this.command.policy.timeoutDelay > 0) {
            switch (this.state) {
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    try {
                        new NettyRecover(this);
                        this.conn = null;
                        this.connectInProgress = false;
                        this.command.dataBuffer = null;
                        return;
                    }
                    catch (Throwable e) {
                        if (!Log.warnEnabled()) break;
                        Log.warn("NettyRecover failed: " + Util.getErrorMessage(e));
                        break;
                    }
                }
            }
        }
        this.closeConnection();
    }

    private void finish() {
        this.closeKeepConnection();
        try {
            this.command.onSuccess();
        }
        catch (Throwable e) {
            this.logError("onSuccess() error", e);
        }
        this.eventLoop.tryDelayQueue();
    }

    private void onNetworkError(AerospikeException ae) {
        if (this.state == 12) {
            return;
        }
        try {
            this.closeConnection();
            this.retry(ae, true);
        }
        catch (Throwable e) {
            this.logError(e);
        }
    }

    private void onBackoffError(AerospikeException.Backoff ab) {
        try {
            this.retry((AerospikeException)ab, true);
        }
        catch (Throwable e) {
            this.logError(e);
        }
    }

    private void onServerTimeout() {
        this.retryServerError(new AerospikeException.Timeout(this.command.policy, false));
    }

    private void retryServerError(AerospikeException ae) {
        if (this.state == 12) {
            return;
        }
        try {
            this.putConnection();
            this.node.incrErrorCount();
            this.retry(ae, false);
        }
        catch (Throwable e) {
            this.logError(e);
        }
    }

    private void retry(final AerospikeException ae, boolean queueCommand) {
        if (this.iteration > this.command.maxRetries) {
            this.close();
            this.notifyFailure(ae);
            this.eventLoop.tryDelayQueue();
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout && (currentTime = System.nanoTime()) >= this.totalDeadline) {
            this.close();
            this.notifyFailure(ae);
            this.eventLoop.tryDelayQueue();
            return;
        }
        long deadline = this.totalDeadline;
        if (this.usingSocketTimeout) {
            this.timeoutTask.cancel();
            long timeout = TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
            if (this.hasTotalTimeout) {
                long remaining = this.totalDeadline - currentTime;
                if (remaining <= timeout) {
                    timeout = remaining;
                    this.usingSocketTimeout = false;
                }
            } else {
                currentTime = System.nanoTime();
            }
            deadline = currentTime + timeout;
        }
        if (queueCommand) {
            final long d = deadline;
            this.eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    if (NettyCommand.this.state == 12) {
                        return;
                    }
                    try {
                        NettyCommand.this.retry(ae, d);
                    }
                    catch (Throwable e) {
                        NettyCommand.this.logError(e);
                    }
                }
            });
        } else {
            this.retry(ae, deadline);
        }
    }

    private void retry(AerospikeException ae, long deadline) {
        if (!this.command.prepareRetry(ae.getResultCode() != -8) && this.command.retryBatch(this, deadline)) {
            this.close();
            return;
        }
        this.executeCommand(deadline, 2);
    }

    private void onApplicationError(AerospikeException ae) {
        if (this.state == 12) {
            return;
        }
        if (ae.keepConnection()) {
            this.closeKeepConnection();
        } else {
            this.closeDropConnection();
        }
        this.notifyFailure(ae);
        this.eventLoop.tryDelayQueue();
    }

    private void onFatalError(AerospikeException ae) {
        try {
            this.closeDropConnection();
            this.notifyFailure(ae);
            this.eventLoop.tryDelayQueue();
        }
        catch (Throwable e) {
            this.logError(e);
        }
    }

    private void notifyFailure(AerospikeException ae) {
        try {
            ae.setNode(this.node);
            ae.setPolicy(this.command.policy);
            ae.setIteration(this.iteration);
            ae.setInDoubt(this.command.isWrite(), this.command.commandSentCounter);
            this.command.onFailure(ae);
        }
        catch (Throwable e) {
            this.logError("onFailure() error", e);
        }
    }

    private void closeKeepConnection() {
        this.close();
        this.putConnection();
    }

    private void putConnection() {
        try {
            SocketChannel channel = this.conn.channel;
            channel.config().setAutoRead(false);
            InboundHandler handler = (InboundHandler)channel.pipeline().last();
            if (this.cluster.keepAlive == null) {
                handler.clear();
            } else {
                Node.AsyncPool pool = this.node.getAsyncPool(this.eventState.index);
                handler.setPool(pool);
            }
            this.node.putAsyncConnection(this.conn, this.eventState.index);
        }
        catch (Throwable e) {
            this.logError(e);
        }
    }

    private void closeDropConnection() {
        this.close();
        this.closeConnection();
    }

    private void closeConnection() {
        if (this.conn != null) {
            this.node.closeAsyncConnection(this.conn, this.eventState.index);
            this.conn = null;
        } else if (this.connectInProgress) {
            this.node.decrAsyncConnection(this.eventState.index);
            this.connectInProgress = false;
        }
    }

    private void closeFromDelayQueue() {
        this.command.putBuffer();
        this.state = 12;
    }

    private void close() {
        this.timeoutTask.cancel();
        this.command.putBuffer();
        this.state = 12;
        --this.eventState.pending;
        --this.eventLoop.pending;
    }

    private void logError(Throwable e) {
        Log.error("NettyCommand fatal error: " + Util.getStackTrace(e));
    }

    private void logError(String msg, Throwable e) {
        Log.error(msg + ": " + Util.getStackTrace(e));
    }

    static final class InboundHandler
    extends ChannelInboundHandlerAdapter {
        private NettyCommand command;
        private Node.AsyncPool pool;

        public InboundHandler(NettyCommand command) {
            this.command = command;
        }

        public InboundHandler(Node.AsyncPool pool) {
            this.pool = pool;
        }

        public InboundHandler() {
        }

        public void setCommand(NettyCommand command) {
            this.command = command;
            this.pool = null;
        }

        public void setPool(Node.AsyncPool pool) {
            this.command = null;
            this.pool = pool;
        }

        public void clear() {
            this.command = null;
            this.pool = null;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            if (this.command.state == 4) {
                this.command.channelActive();
            }
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.command.read((ByteBuf)msg);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (!(evt instanceof SslHandshakeCompletionEvent)) {
                return;
            }
            Throwable cause = ((SslHandshakeCompletionEvent)evt).cause();
            if (cause != null) {
                throw new AerospikeException.Connection("TLS connect failed: " + cause.getMessage(), cause);
            }
            TlsPolicy tlsPolicy = this.command.cluster.tlsPolicy;
            String tlsName = this.command.node.getHost().tlsName;
            SSLSession session = ((SslHandler)ctx.pipeline().first()).engine().getSession();
            X509Certificate cert = (X509Certificate)session.getPeerCertificates()[0];
            Connection.validateServerCertificate(tlsPolicy, tlsName, cert);
            if (this.command.state == 5) {
                this.command.channelActive();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (this.command == null) {
                block16: {
                    if (this.pool != null) {
                        try {
                            Channel ch = ctx.channel();
                            if (ch.isOpen()) {
                                ch.close();
                                this.pool.signalRemove();
                            }
                            break block16;
                        }
                        catch (Throwable e) {
                            if (Log.warnEnabled()) {
                                Log.warn("Netty pool connect error: " + Util.getErrorMessage(e));
                            }
                            break block16;
                        }
                    }
                    Log.error("Unexpected netty connection exception: " + Util.getStackTrace(cause));
                }
                return;
            }
            if (cause instanceof AerospikeException.Connection) {
                this.command.onNetworkError((AerospikeException.Connection)cause);
            } else if (cause instanceof AerospikeException) {
                AerospikeException ae = (AerospikeException)cause;
                if (ae.getResultCode() == 9) {
                    this.command.onServerTimeout();
                } else if (ae.getResultCode() == 18) {
                    this.command.retryServerError(ae);
                } else {
                    this.command.onApplicationError(ae);
                }
            } else if (cause instanceof IOException) {
                this.command.onNetworkError(new AerospikeException(cause));
            } else {
                this.command.onApplicationError(new AerospikeException(cause));
            }
        }
    }
}

