/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.async.EventLoopStats;
import com.aerospike.client.cluster.NodeStats;

public final class ClusterStats {
    public final NodeStats[] nodes;
    public final EventLoopStats[] eventLoops;
    public final int threadsInUse;
    public final int recoverQueueSize;
    public final int invalidNodeCount;

    public ClusterStats(NodeStats[] nodes, EventLoopStats[] eventLoops, int threadsInUse, int recoverQueueSize, int invalidNodeCount) {
        this.nodes = nodes;
        this.eventLoops = eventLoops;
        this.threadsInUse = threadsInUse;
        this.recoverQueueSize = recoverQueueSize;
        this.invalidNodeCount = invalidNodeCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("nodes(inUse,inPool,opened,closed):");
        sb.append(System.lineSeparator());
        for (NodeStats stat : this.nodes) {
            sb.append(stat);
            sb.append(System.lineSeparator());
        }
        if (this.eventLoops != null) {
            sb.append("eventLoops(processSize,queueSize): ");
            for (int i = 0; i < this.eventLoops.length; ++i) {
                EventLoopStats stat = this.eventLoops[i];
                if (i > 0) {
                    sb.append(',');
                }
                sb.append('(');
                sb.append(stat);
                sb.append(')');
            }
            sb.append(System.lineSeparator());
        }
        sb.append("threadsInUse: " + this.threadsInUse);
        sb.append(System.lineSeparator());
        sb.append("recoverQueueSize: " + this.recoverQueueSize);
        sb.append(System.lineSeparator());
        sb.append("invalidNodeCount: " + this.invalidNodeCount);
        return sb.toString();
    }
}

